/**
 * \file SwamiUIObject.h
 * \brief Main Swami user interface object
 *
 * Ties all the GUI elements together and provides
 * user interface related routines for generic sound font editing
 * operations.
 */

/*
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __SWAMIUI_OBJECT_H__
#define __SWAMIUI_OBJECT_H__

#include <gtk/gtk.h>
#include <gmodule.h>
#include <instpatch.h>

#include "swamidll.h"

#include <libswami/SwamiConfig.h>
#include <libswami/SwamiObject.h>
#include <libswami/SwamiPlugin.h>

#include "SwamiUIObject.h"
#include "SwamiUITree.h"

enum {
  SWAMIUI_LOWPANE_VIEW,
  SWAMIUI_LOWPANE_CTRL,
  SWAMIUI_LOWPANE_GRAPH,
  SWAMIUI_LOWPANE_SAMVIEW,
  SWAMIUI_LOWPANE_MODEDIT
};

typedef struct _SwamiUIObject SwamiUIObject;
typedef struct _SwamiUIObjectClass SwamiUIObjectClass;

#define SWAMIUI_TYPE_OBJECT   (swamiui_object_get_type ())
#define SWAMIUI_OBJECT(obj) \
  (GTK_CHECK_CAST ((obj), SWAMIUI_TYPE_OBJECT, SwamiUIObject))
#define SWAMIUI_OBJECT_CLASS(klass) \
  (GTK_CHECK_CLASS_CAST ((klass), SWAMIUI_TYPE_OBJECT, SwamiUIObjectClass))
#define SWAMIUI_IS_OBJECT(obj) \
  (GTK_CHECK_TYPE ((obj), SWAMIUI_TYPE_OBJECT))
#define SWAMIUI_IS_OBJECT_CLASS(klass) \
  (GTK_CHECK_CLASS_TYPE ((klass), SWAMIUI_TYPE_OBJECT))

/** Swami User Interface Object */
struct _SwamiUIObject
{
  SwamiObject parent;		/* derived from SwamiObject */

  /* private */

  GtkWidget *main_window;
  IPMod *global_mods;		/* global modulator list */
  gboolean enable_global_mods;	/* enable global modulators? */
};

struct _SwamiUIObjectClass
{
  SwamiObjectClass parent_class;

  void (*patch_load)(SwamiUIObject *uiobject, char *file_name);
};

SWAMI_API extern SwamiUIObject *swamiui_object;
SWAMI_API extern SwamiObject *swami_object;


/* GUI plugin stuff */

typedef struct _SwamiUIPluginDesc SwamiUIPluginDesc;

typedef int (*SwamiUIPluginInitFunc) (GModule *module, SwamiPlugin *plugin);

/* GUI description structure for plugins */
struct _SwamiUIPluginDesc
{
  SwamiUIPluginInitFunc gui_init; /* a plugin gui initialization function */
};

#define SWAMIUI_PLUGIN_DESC(gui_init) \
SWAMI_API SwamiUIPluginDesc swamiui_plugin_desc = { \
  gui_init \
};


SWAMI_API guint swamiui_object_get_type (void);
SWAMI_API SwamiUIObject *swamiui_object_new (void);
SWAMI_API void swamiui_quit (void);
SWAMI_API void swamiui_lowpane_set_view (int view);

SWAMI_API void swamiui_register_object (GtkObject *object);
SWAMI_API GtkObject *swamiui_register_object_new (GtkType type);
SWAMI_API GList *swamiui_lookup_object_list (const char *type_name);
SWAMI_API GtkObject *swamiui_lookup_object (const char *type_name);

SWAMI_API void swamiui_update_global_mods (void);

SWAMI_API void swamiui_load_files (void);
SWAMI_API void swamiui_save_files (GList *items, gboolean saveas);
SWAMI_API void swamiui_close_files (GList *items);
SWAMI_API void swamiui_delete_items (GList *items);
SWAMI_API void swamiui_wtbl_load_patch (IPItem *item);
SWAMI_API void swamiui_item_properties (GList *items);
SWAMI_API IPItem *swamiui_new_item (IPItem *parent_hint, int type);
SWAMI_API void swamiui_goto_zone_refitem (IPZone *zone, SwamiUITree *tree);
SWAMI_API void swamiui_load_samples (IPItem *parent_hint);
SWAMI_API void swamiui_export_samples (GList *items);
SWAMI_API void swamiui_unset_gens (GList *items);
SWAMI_API void swamiui_copy_gens (IPItem *item);
SWAMI_API void swamiui_paste_gens (IPItem *zone);

#endif
