/**
 * \file SwamiUIMultiList.h
 * \brief UI multi IPItem action object header file
 */

/*
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __SWAMIUI_MULTILIST_H__
#define __SWAMIUI_MULTILIST_H__

#include <gtk/gtk.h>
#include <instpatch.h>

#include "swamidll.h"

typedef struct _SwamiUIMultiList SwamiUIMultiList;
typedef struct _SwamiUIMultiListClass SwamiUIMultiListClass;

#define SWAMIUI_TYPE_MULTILIST   (swamiui_multilist_get_type ())
#define SWAMIUI_MULTILIST(obj) \
  (GTK_CHECK_CAST ((obj), SWAMIUI_TYPE_MULTILIST, SwamiUIMultiList))
#define SWAMIUI_MULTILIST_CLASS(klass) \
  (GTK_CHECK_CLASS_CAST ((klass), SWAMIUI_TYPE_MULTILIST, SwamiUIMultiListClass))
#define SWAMIUI_IS_MULTILIST(obj) \
  (GTK_CHECK_TYPE ((obj), SWAMIUI_TYPE_MULTILIST))
#define SWAMIUI_IS_MULTILIST_CLASS(klass) \
  (GTK_CHECK_CLASS_TYPE ((klass), SWAMIUI_TYPE_MULTILIST))

/** Swami Multi sound font item action List object */
struct _SwamiUIMultiList
{
  GtkWindow parent;

  GtkWidget *label;		/* question label at top of dialog */
  GtkWidget *scroll_win;	/* scroll window to put list in */
  GtkWidget *clist;		/* list widget */
  GtkWidget *vbox;		/* main vbox */
  GtkWidget *list_btnbox;	/* list button hbox */
  GtkWidget *action_btnbox;	/* action button hbox */
  GtkWidget *ok_button;		/* OK button widget */
  GtkWidget *cancel_button;	/* Cancel button widget */
  GList *items;			/* list of items being processed */
};

/** Swami Multi sound font item action List class */
struct _SwamiUIMultiListClass
{
  GtkScrolledWindowClass parent_class;
};

/**
 * \brief Function callback type for list buttons
 * \param multi Multi list object of clicked button
 * \param func_data User defined function data passed to
 *   #swamiui_multilist_new_listbtn.
 */
typedef void (* SwamiUIMultiListCallback)(SwamiUIMultiList *multi,
					  gpointer func_data);

SWAMI_API guint swamiui_multilist_get_type (void);
SWAMI_API GtkWidget *swamiui_multilist_new (char *title, char *ques,
					    int columns,
					    char *first_label, ...);
SWAMI_API void swamiui_multilist_set_items (SwamiUIMultiList *multi,
					    GList *items);
SWAMI_API void swamiui_multilist_new_listbtn (SwamiUIMultiList *multi,
					      char *label,
					      SwamiUIMultiListCallback func,
					      gpointer func_data);
#endif
