/*
 * SwamiSamplelib.h
 * \brief Sample library object header file
 *
 * Provides an object to interface to sample file libraries
 */

/*
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <swami@resonance.org>
 * Swami homepage: http://www.resonance.org/swami/
 */
#ifndef __SWAMI_SAMPLELIB_H__
#define __SWAMI_SAMPLELIB_H__

#include <glib.h>
#include "GObjSup.h"
#include <instpatch.h>
#include "swamidll.h"

typedef struct _SwamiSamplelib SwamiSamplelib;
typedef struct _SwamiSamplelibClass SwamiSamplelibClass;
typedef struct _SwamiSamplelibHandle SwamiSamplelibHandle;
typedef struct _SwamiSamplelibParams SwamiSamplelibParams;

#define SWAMI_TYPE_SAMPLELIB   (swami_samplelib_get_type ())
#define SWAMI_SAMPLELIB(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWAMI_TYPE_SAMPLELIB, SwamiSamplelib))
#define SWAMI_SAMPLELIB_CLASS(klass) \
 (G_TYPE_CHECK_CLASS_CAST ((klass), SWAMI_TYPE_SAMPLELIB, SwamiSamplelibClass))
#define SWAMI_IS_SAMPLELIB(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWAMI_TYPE_SAMPLELIB))
#define SWAMI_IS_SAMPLELIB_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), SWAMI_TYPE_SAMPLELIB))

/* Swami Samplelib object */
struct _SwamiSamplelib
{
  GObject object;
};

/* Swami Samplelib class */
struct _SwamiSamplelibClass
{
  GObjectClass parent_class;

  /*< public >*/

  int (*open) (SwamiSamplelibHandle *handle);
  void (*close) (SwamiSamplelibHandle *handle);
  int (*read) (SwamiSamplelibHandle *handle, int frames, gint16 *buf);
  int (*write) (SwamiSamplelibHandle *handle, int frames, const gint16 *buf);
};

/* Enum for loop mode */
typedef enum
{
  SWAMI_AUDIO_LOOP_NONE,	/* no looping */
  SWAMI_AUDIO_LOOP_NORMAL,	/* normal looping */
  SWAMI_AUDIO_LOOP_UNROLL,	/* loop until release then continue */
} SwamiAudioLoop;

/* Enum for file type (WAV, AIFF, etc) */
typedef enum
{
  SWAMI_SAMPLELIB_TYPE_WAVE,
  SWAMI_SAMPLELIB_TYPE_AIFFC,
  SWAMI_SAMPLELIB_TYPE_AU,
  SWAMI_SAMPLELIB_TYPE_RAW
} SwamiSamplelibType;

struct _SwamiSamplelibParams
{
  /* write mode only variable */
  SwamiSamplelibType file_type;	/* type of file (WAV, AIFF, etc) */

  /* read and write mode variables */
  int rate;			/* sampling rate of audio */
  int channels;			/* number of channels */

  /* instrument related data (read and write mode) */
  SwamiAudioLoop loop_type;	/* loop mode */
  int loop_start;		/* start of loop in instrument */
  int loop_end;			/* end of loop in instrument */
  int root_note;		/* MIDI root note */
  int fine_tune;		/* fine tuning of sample in cents */

  /* raw audio parameters (read mode only) */
  int width;			/* bit width 8, 16, etc */
  gboolean signd;		/* signed/unsigned = TRUE/FALSE */
  gboolean lendian;		/* little endian/big endian = TRUE/FALSE */
};

/* Swami Samplelib handle for an opened file */
struct _SwamiSamplelibHandle
{
  SwamiSamplelib *samplelib;	/* audio file object owning this handle */
  void *driver_data;		/* driver defined generic pointer */

  char *filename;		/* pointer to file name to open */
  char mode;			/* mode of access 'r' = read, 'w' = write */

  guint size;			/* size of file in frames (read mode only) */
  gboolean eof_flag;		/* set on end of file (read mode only) */

  SwamiSamplelibParams params;	/* audio file parameters */

  void *data;			/* user defined data */
};

SWAMI_API GType swami_samplelib_get_type (void);
SWAMI_API SwamiSamplelib *swami_samplelib_new (void);

SWAMI_API int swami_samplelib_load_sampledata (SwamiSamplelibHandle *handle,
					       IPSampleData **left,
					       IPSampleData **right);
SWAMI_API void swami_samplelib_init_sample (SwamiSamplelibHandle *handle,
					    IPSample *sample);
SWAMI_API void
swami_samplelib_set_params_default (SwamiSamplelibParams *params);

SWAMI_API SwamiSamplelibHandle *
swami_samplelib_open (SwamiSamplelib *samplelib, char *filename, char mode,
		      SwamiSamplelibParams *params);
SWAMI_API void swami_samplelib_close (SwamiSamplelibHandle *handle);

SWAMI_API int swami_samplelib_read (SwamiSamplelibHandle *handle, int frames,
				    gint16 *buf);
SWAMI_API int swami_samplelib_write (SwamiSamplelibHandle *handle, int frames,
				     const gint16 *buf);
SWAMI_API gboolean swami_samplelib_is_eof (SwamiSamplelibHandle *handle);

#endif /* __SWAMI_SAMPLELIB_H__ */
