/**
 * \file SwamiUIModEdit.h
 * \brief UI Modulator editor object
 */

/*
 *
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __SWAMIUI_MODEDIT_H__
#define __SWAMIUI_MODEDIT_H__

#include <gtk/gtk.h>
#include <instpatch.h>

#include "swamidll.h"

typedef struct _SwamiUIModEdit SwamiUIModEdit;
typedef struct _SwamiUIModEditClass SwamiUIModEditClass;

#define SWAMIUI_TYPE_MODEDIT   (swamiui_modedit_get_type ())
#define SWAMIUI_MODEDIT(obj) \
  (GTK_CHECK_CAST ((obj), SWAMIUI_TYPE_MODEDIT, SwamiUIModEdit))
#define SWAMIUI_MODEDIT_CLASS(klass) \
  (GTK_CHECK_CLASS_CAST ((klass), SWAMIUI_TYPE_MODEDIT, SwamiUIModEditClass))
#define SWAMIUI_IS_MODEDIT(obj) \
  (GTK_CHECK_TYPE ((obj), SWAMIUI_TYPE_MODEDIT))
#define SWAMIUI_IS_MODEDIT_CLASS(klass) \
  (GTK_CHECK_CLASS_TYPE ((klass), SWAMIUI_TYPE_MODEDIT))

struct _SwamiUIModEdit
{
  GtkScrolledWindow parent;
  IPZone *zone;			/* sound font zone to sync to */
  gboolean global_mods;		/* TRUE if editing global modulators */
  IPMod *mod;			/* FIXME! no ref problem with modulators */
  GtkWidget *glade_widg;	/* glade generated editor widget */
  gboolean block_callbacks;	/* blocks modulator editor callbacks */
};

struct _SwamiUIModEditClass
{
  GtkScrolledWindowClass parent_class;
};

SWAMI_API guint swamiui_modedit_get_type (void);
SWAMI_API GtkWidget *swamiui_modedit_new (void);
SWAMI_API void swamiui_modedit_set_item (SwamiUIModEdit *modedit,
					 IPItem *item);
SWAMI_API void swamiui_modedit_global_mods (SwamiUIModEdit *modedit);

#endif
