

import os
import string
import sys

import pygtk
pygtk.require('1.2')

from gtk import *
import GtkExtra
import GDK

button_info = (
    ("0", 0),
    ("1KB/s", 1000),
    ("10KB/s", 10000),
    ("100KB/s", 100000),
    ("1MB/s", 1000000),
    )


class window1Widget:
    def __init__(self, command, limit):
        # modified from code generated by glc/glade
        window1=GtkWindow(WINDOW_TOPLEVEL)
        window1.set_title("NetThrottle: %s" % command)
        window1.set_usize(-1, -1)
        window1.set_policy(FALSE, TRUE, FALSE)
        window1.set_position(WIN_POS_NONE)

        hbox1=GtkHBox()
        window1.add(hbox1)
        hbox1.set_usize(-1, -1)
        hbox1.set_homogeneous(FALSE)
        hbox1.set_spacing(3)

        hbuttonbox1=GtkHButtonBox()
        hbox1.pack_start(hbuttonbox1, FALSE, FALSE, 0)
        hbuttonbox1.set_usize(-1, -1)
        hbuttonbox1.set_homogeneous(FALSE)
        hbuttonbox1.set_spacing(0)
        hbuttonbox1.set_border_width(2)
        hbuttonbox1.set_child_size_default(80, 10)
        hbuttonbox1.set_child_ipadding_default(3, 0)
        hbuttonbox1.set_spacing(0)
        hbuttonbox1.set_layout(BUTTONBOX_DEFAULT_STYLE)

        for label, value in button_info:
            b = GtkButton(label)
            set_button(b, value)
            hbuttonbox1.pack_start(b, TRUE, TRUE, 0)
            b.set_flags(CAN_FOCUS)
            b.set_usize(-1, -1)
            b.show()
            b.connect("clicked", buttonclick)

        hbuttonbox1.show()
        self.hbuttonbox1=hbuttonbox1

        spinbutton1_adj = GtkAdjustment(0, 0, 1000000000, 1, 1000, 1000)
        spinbutton1=GtkSpinButton(spinbutton1_adj, 1.0, 0)
        hbox1.pack_start(spinbutton1, TRUE, TRUE, 0)
        spinbutton1.set_flags(CAN_FOCUS)
        spinbutton1.set_usize(100, -1)
        spinbutton1.set_numeric(TRUE)
        spinbutton1.set_update_policy(UPDATE_ALWAYS)
        spinbutton1.set_editable(TRUE)
        spinbutton1.set_visibility(TRUE)
        spinbutton1.set_value(limit)
        spinbutton1.show()
        self.spinbutton1=spinbutton1
        self.spinbutton1_adj=spinbutton1_adj

        progressbar1=GtkProgressBar()
        hbox1.pack_start(progressbar1, TRUE, TRUE, 0)
        progressbar1.set_usize(-1, -1)
        progressbar1.set_format_string("%v")
        progressbar1.set_show_text(TRUE)
        progressbar1.configure(0, 0, limit)
        progressbar1.show()
        self.progressbar1=progressbar1

        hbox1.show()
        self.hbox1=hbox1
        window1.show()
        self.window1=window1

# we're doing this instead of using a dictionary because older versions of
# pygtk didn't make widgets immutable, apparently
buttons = []
def set_button(b, v):
    buttons.append((b, v))

def get_button(b):
    for bb, v in buttons:
        if b == bb:
            return v
    sys.exit("ack, can't find button")

def buttonclick(b):
    v = get_button(b)
    window1.spinbutton1.set_value(v)

def valuechanged(adj):
    change_limit(adj.value)
    #print 'valuechanged: %s' % adj.value

def change_limit(l):
    global limit
    limit = l
    v = window1.progressbar1.get_value()
    window1.progressbar1.configure(min(v, limit), 0, limit)
    print int(limit)
    sys.stdout.flush()

def set_current(v):
    global limit
    window1.progressbar1.set_value(min(limit, v))

def do_read(fd, cond):
    if cond & GDK.INPUT_EXCEPTION:      # might get SIGPIPE?
        sys.exit("input stream exception")
    #print 'do_read: fd %s, cond %s' % (fd, cond)
    s = os.read(fd, 80)
    if len(s) == 0:
        # SF exited
        sys.exit(0)
    #print 'do_read: got %s' % repr(s)
    words = string.split(s)             # FIX this hack
    s = words[0]
    set_current(string.atoi(s))

limit = string.atoi(sys.argv[2])

if __name__ == '__main__':
    command = sys.argv[1]
    window1=window1Widget(command, limit)
    window1.window1.connect("delete_event", mainquit)
    window1.spinbutton1_adj.connect("value_changed", valuechanged)
    input_add(0, GDK.INPUT_READ|GDK.INPUT_EXCEPTION, do_read)

    mainloop()
