

NARGS = 0
CALL = 3
SIGNATURE = 4

# These constants are from 'strace'.  All the "process" syscalls are tagged
# with TP, all the "file" syscalls are tagged with TF, etc.  SF doesn't
# currently use it, but it's here for now in case it might be useful.
TP = 1
TF = 2
TS = 4
TI = 8
TN = 16


# The original version of this table was based on info from 'strace'.  You can
# find the file it's from in a distribution of strace, in the file
# linux/syscallent.h.  The current version of this file is based on RCS version
# 1.18, 2003/04/08 of that file, from strace 4.4.98.

# Signatures need to be made for syscalls after 221.  Syscalls in general take
# either a long int or a pointer as an argument, the Signatures seem to be what
# the argument is.  If it's in parentheses, it's what's pointed to, if it's
# not, it's the actual argument.  This is, as far as I can tell.  It would be
# nice to be able to generate this file automatically in the build process but
# I don't think that can happen.

table = (
    ( 0, 0,	"sys_setup",		"setup", None),	# 0XX
    ( 1, TP,	"sys_exit",		"_exit",	None),	# 1
    ( 0, TP,	"sys_fork",		"fork",	None),	# 2
    ( 3, 0,	"sys_read",		"read",	None),	# 3
    ( 3, 0,	"sys_write",		"write",	None),	# 4
    ( 3, TF,	"sys_open",		"open",	('P', None, None)),	# 5
    ( 1, 0,	"sys_close",		"close",	None),	# 6
    ( 3, TP,	"sys_waitpid",		"waitpid",	None),# 7
    ( 2, TF,	"sys_creat",		"creat",	('P', None)),	# 8
    ( 2, TF,	"sys_link",		"link",	('P', 'P')),	# 9
    ( 1, TF,	"sys_unlink",		"unlink",	('P')),# 10
    ( 3, TF|TP,	"sys_execve",		"execve",	('P', None, None)),# 11
    ( 1, TF,	"sys_chdir",		"chdir",	('P')),	# 12
    ( 1, 0,	"sys_time",		"time",	None),	# 13
    ( 3, TF,	"sys_mknod",		"mknod",	('P', None, None)),	# 14
    ( 2, TF,	"sys_chmod",		"chmod",	('P', None)),	# 15
    ( 3, TF,	"sys_lchown16",		"lchown16",	('P', None, None)),	# 16
    ( 0, 0,	"sys_break",		"break",	None),	# 17XX
    ( 2, TF,	"sys_oldstat",		"oldstat",	('P', None)),# 18
    ( 3, 0,	"sys_lseek",		"lseek",	None),	# 19
    ( 0, 0,	"sys_getpid",		"getpid",	None),# 20
    ( 5, TF,	"sys_mount",		"mount",	('P', 'P', 's', None, None)),	# 21
    ( 1, TF,	"sys_umount",		"oldumount",	('P')),# 22
    ( 1, 0,	"sys_setuid16",		"setuid16",	None),# 23
    ( 0, 0,	"sys_getuid16",		"getuid16",	None),# 24
    ( 1, 0,	"sys_stime",		"stime",	None),	# 25
    ( 4, 0,	"sys_ptrace",		"ptrace",	None),# 26
    ( 1, 0,	"sys_alarm",		"alarm",	None),	# 27
    ( 2, 0,	"sys_oldfstat",		"oldfstat",	None),# 28
    ( 0, TS,	"sys_pause",		"pause",	None),	# 29
    ( 2, TF,	"sys_utime",		"utime",	('P', None)),	# 30
    ( 2, 0,	"sys_stty",		"stty",	None),	# 31XX
    ( 2, 0,	"sys_gtty",		"gtty",	None),	# 32XX
    ( 2, TF,	"sys_access",		"access",	('P', None)),# 33
    ( 1, 0,	"sys_nice",		"nice",	None),	# 34
    ( 0, 0,	"sys_ftime",		"ftime",	None),	# 35XX
    ( 0, 0,	"sys_sync",		"sync",	None),	# 36
    ( 2, TS,	"sys_kill",		"kill",	None),	# 37
    ( 2, TF,	"sys_rename",		"rename",	('P', 'P')),# 38
    ( 2, TF,	"sys_mkdir",		"mkdir",	('P', None)),	# 39
    ( 1, TF,	"sys_rmdir",		"rmdir",	('P')),	# 40
    ( 1, 0,	"sys_dup",		"dup",	None),	# 41
    ( 1, 0,	"sys_pipe",		"pipe",	None),	# 42
    ( 1, 0,	"sys_times",		"times",	None),	# 43
    ( 0, 0,	"sys_prof",		"prof",	None),	# 44XX
    ( 1, 0,	"sys_brk",		"brk",	None),	# 45
    ( 1, 0,	"sys_setgid16",		"setgid16",	None),# 46
    ( 0, 0,	"sys_getgid16",		"getgid16",	None),# 47
    ( 3, TS,	"sys_signal",		"signal",	None),# 48
    ( 0, 0,	"sys_geteuid16",	"geteuid16",	None),# 49
    ( 0, 0,	"sys_getegid16",	"getegid16",	None),# 50
    ( 1, TF,	"sys_acct",		"acct",	('P')),	# 51
    ( 2, TF,	"sys_umount2",		"umount",	('P', None)),# 52
    ( 0, 0,	"sys_lock",		"lock",	None),	# 53XX
    ( 3, 0,	"sys_ioctl",		"ioctl",	None),	# 54
    ( 3, 0,	"sys_fcntl",		"fcntl",	None),	# 55
    ( 0, 0,	"sys_mpx",		"mpx",	None),	# 56XX
    ( 2, 0,	"sys_setpgid",		"setpgid",	None),# 57
    ( 2, 0,	"sys_ulimit",		"ulimit",	None),# 58XX
    ( 1, 0,	"sys_oldolduname",	"oldolduname",	None),# 59
    ( 1, 0,	"sys_umask",		"umask",	None),	# 60
    ( 1, TF,	"sys_chroot",		"chroot",	('P')),# 61
    ( 2, 0,	"sys_ustat",		"ustat",	None),	# 62
    ( 2, 0,	"sys_dup2",		"dup2",	None),	# 63
    ( 0, 0,	"sys_getppid",		"getppid",	None),# 64
    ( 0, 0,	"sys_getpgrp",		"getpgrp",	None),# 65
    ( 0, 0,	"sys_setsid",		"setsid",	None),# 66
    ( 3, TS,	"sys_sigaction",	"sigaction",	None),# 67
    ( 0, TS,	"sys_siggetmask",	"siggetmask",	None),# 68
    ( 1, TS,	"sys_sigsetmask",	"sigsetmask",	None),# 69
    ( 2, 0,	"sys_setreuid16",	"setreuid16",	None),# 70
    ( 2, 0,	"sys_setregid16",	"setregid16",	None),# 71
    ( 3, TS,	"sys_sigsuspend",	"sigsuspend",	None),# 72
    ( 1, TS,	"sys_sigpending",	"sigpending",	None),# 73
    ( 2, 0,	"sys_sethostname",	"sethostname",	None),# 74
    ( 2, 0,	"sys_setrlimit",	"setrlimit",	None),# 75
    ( 2, 0,	"sys_oldgetrlimit",	"oldgetrlimit",	None),# 76
    ( 2, 0,	"sys_getrusage",	"getrusage",	None),# 77
    ( 2, 0,	"sys_gettimeofday",	"gettimeofday",	None),# 78
    ( 2, 0,	"sys_settimeofday",	"settimeofday",	None),# 79
    ( 2, 0,	"sys_getgroups16",	"getgroups16",	None),# 80
    ( 2, 0,	"sys_setgroups16",	"setgroups16",	None),# 81
    ( 1, 0,	"sys_oldselect",	"oldselect",	None),# 82
    ( 2, TF,	"sys_symlink",		"symlink",	('P', 'P')),# 83
    ( 2, TF,	"sys_oldlstat",		"oldlstat",	('P', None)),# 84
    ( 3, TF,	"sys_readlink",		"readlink",	('P', None, None)),# 85
    ( 1, TF,	"sys_uselib",		"uselib",	('P')),# 86
    ( 1, TF,	"sys_swapon",		"swapon",	('P')),# 87
    ( 3, 0,	"sys_reboot",		"reboot",	None),# 88
    ( 3, 0,	"sys_readdir",		"readdir",	None),# 89
    ( 1, 0,	"sys_mmap",		"mmap",	None),	# 90 (obsolescent: one arg pointing to struct)
    ( 2, 0,	"sys_munmap",		"munmap",	None),# 91
    ( 2, TF,	"sys_truncate",		"truncate",	('P', None)),# 92
    ( 2, 0,	"sys_ftruncate",	"ftruncate",	None),# 93
    ( 2, 0,	"sys_fchmod",		"fchmod",	None),# 94
    ( 3, 0,	"sys_fchown16",		"fchown16",	None),# 95
    ( 2, 0,	"sys_getpriority",	"getpriority",	None),# 96
    ( 3, 0,	"sys_setpriority",	"setpriority",	None),# 97
    ( 4, 0,	"sys_profil",		"profil",	None),# 98XX
    ( 2, TF,	"sys_statfs",		"statfs",	('P', None)),# 99
    ( 2, 0,	"sys_fstatfs",		"fstatfs",	None),# 100
    ( 3, 0,	"sys_ioperm",		"ioperm",	None),# 101
    ( 2, 0,	"sys_socketcall",	"socketcall",	None),# 102
    ( 3, 0,	"sys_syslog",		"syslog",	None),# 103
    ( 3, 0,	"sys_setitimer",	"setitimer",	None),# 104
    ( 2, 0,	"sys_getitimer",	"getitimer",	None),# 105
    ( 2, TF,	"sys_stat",		"stat",	('P', None)),	# 106
    ( 2, TF,	"sys_lstat",		"lstat",	('P', None)),	# 107
    ( 2, 0,	"sys_fstat",		"fstat",	None),	# 108
    ( 1, 0,	"sys_olduname",		"olduname",	None),# 109
    ( 1, 0,	"sys_iopl",		"iopl",	None),	# 110
    ( 0, 0,	"sys_vhangup",		"vhangup",	None),# 111
    ( 0, 0,	"sys_idle",		"idle",	None),	# 112XX
    ( 1, 0,	"sys_vm86old",		"vm86old",	None),# 113
    ( 4, TP,	"sys_wait4",		"wait4",	None),	# 114
    ( 1, 0,	"sys_swapoff",		"swapoff",	('P')),# 115
    ( 1, 0,	"sys_sysinfo",		"sysinfo",	None),# 116
    ( 5, 0,	"sys_ipc",		"ipc",	None),	# 117
    ( 1, 0,	"sys_fsync",		"fsync",	None),	# 118
    ( 1, TS,	"sys_sigreturn",	"sigreturn",	None),# 119
    ( 2, TP,	"sys_clone",		"clone",	None),	# 120
    ( 2, 0,	"sys_setdomainname",	"setdomainname",	None),# 121
    ( 1, 0,	"sys_uname",		"uname",	None),	# 122
    ( 3, 0,	"sys_modify_ldt",	"modify_ldt",	None),# 123
    ( 1, 0,	"sys_adjtimex",		"adjtimex",	None),# 124
    ( 3, 0,	"sys_mprotect",		"mprotect",	None),# 125
    ( 3, TS,	"sys_sigprocmask",	"sigprocmask",	None),# 126
    ( 2, 0,	"sys_create_module",	"create_module",	None),# 127
    ( 2, 0,	"sys_init_module",	"init_module",	None),# 128
    ( 1, 0,	"sys_delete_module",	"delete_module",	None),# 129
    ( 1, 0,	"sys_get_kernel_syms",	"get_kernel_syms",None),# 130
    ( 4, 0,	"sys_quotactl",		"quotactl",	(None, 'P', None, None)),# 131
    ( 1, 0,	"sys_getpgid",		"getpgid",	None),# 132
    ( 1, 0,	"sys_fchdir",		"fchdir",	None),# 133
    ( 0, 0,	"sys_bdflush",		"bdflush",	None),# 134
    ( 3, 0,	"sys_sysfs",		"sysfs",	None),	# 135
    ( 1, 0,	"sys_personality",	"personality",	None),# 136
    ( 5, 0,	"sys_afs_syscall",	"afs_syscall",	None),# 137XX
    ( 1, 0,	"sys_setfsuid16",	"setfsuid16",	None),# 138
    ( 1, 0,	"sys_setfsgid16",	"setfsgid16",	None),# 139
    ( 5, 0,	"sys_llseek",		"_llseek",	None),# 140
    ( 3, 0,	"sys_getdents",		"getdents",	None),# 141
    ( 5, 0,	"sys_select",		"select",	None),# 142
    ( 2, 0,	"sys_flock",		"flock",	None),	# 143
    ( 3, 0,	"sys_msync",		"msync",	None),	# 144
    ( 3, 0,	"sys_readv",		"readv",	None),	# 145
    ( 3, 0,	"sys_writev",		"writev",	None),# 146
    ( 1, 0,	"sys_getsid",		"getsid",	None),# 147
    ( 1, 0,	"sys_fdatasync",	"fdatasync",	None),# 148
    ( 1, 0,	"sys_sysctl",		"_sysctl",	None),# 149
    ( 1, 0,	"sys_mlock",		"mlock",	None),	# 150
    ( 2, 0,	"sys_munlock",		"munlock",	None),# 151
    ( 2, 0,	"sys_mlockall",		"mlockall",	None),# 152
    ( 1, 0,	"sys_munlockall",	"munlockall",	None),# 153
    ( 0, 0,	"sys_sched_setparam",	"sched_setparam",None), # 154
    ( 2, 0,	"sys_sched_getparam",	"sched_getparam",None), # 155
    ( 3, 0,	"sys_sched_setscheduler", "sched_setscheduler",None), # 156
    ( 1, 0,	"sys_sched_getscheduler", "sched_getscheduler",None), # 157
    ( 0, 0,	"sys_sched_yield",	"sched_yield",None), # 158
    ( 1, 0,	"sys_sched_get_priority_max", "sched_get_priority_max",None), # 159
    ( 1, 0,	"sys_sched_get_priority_min", "sched_get_priority_min",None), # 160
    ( 2, 0,	"sys_sched_rr_get_interval", "sched_rr_get_interval",None), # 161
    ( 2, 0,	"sys_nanosleep",	"nanosleep",	None),# 162
    ( 4, 0,	"sys_mremap",		"mremap",	None),# 163
    ( 3, 0,	"sys_setresuid16",	"setresuid16",	None),# 164
    ( 3, 0,	"sys_getresuid16",	"getresuid16",	None),# 165
    ( 5, 0,	"printargs",		"vm86",	None),	# 166
    ( 5, 0,	"sys_query_module",	"query_module",	None),# 167
    ( 3, 0,	"sys_poll",		"poll",	None),	# 168
    ( 3, 0,	"printargs",		"nfsservctl",	None),# 169
    ( 3, 0,	"sys_setresgid16",	"setresgid16",	None),# 170
    ( 3, 0,	"sys_getresgid16",	"getresgid16",	None),# 171
    ( 5, 0,	"printargs",		"prctl",	None),	# 172
    ( 1, TS,	"printargs",		"rt_sigreturn",	None),# 173
    ( 4, TS,	"sys_rt_sigaction",	"rt_sigaction", None), # 174
    ( 4, TS,	"sys_rt_sigprocmask",	"rt_sigprocmask",None), # 175
    ( 2, TS,	"sys_rt_sigpending",	"rt_sigpending",None),# 176
    ( 4, TS,	"sys_rt_sigtimedwait",	"rt_sigtimedwait",None), # 177
    ( 3, TS,	"sys_rt_sigqueueinfo",  "rt_sigqueueinfo",None), # 178
    ( 2, TS,	"sys_rt_sigsuspend",	"rt_sigsuspend",	None),# 179
    ( 5, TF,	"sys_pread",		"pread",	None),	# 180
    ( 5, TF,	"sys_pwrite",		"pwrite",	None),# 181
    ( 3, TF,	"sys_chown16",		"chown16",	('P', None, None)),# 182
    ( 2, 0,	"sys_getcwd",		"getcwd",	None),# 183
    ( 2, 0,	"sys_capget",		"capget",	None),# 184
    ( 2, 0,	"sys_capset",		"capset",	None),# 185
    ( 2, TS,	"sys_sigaltstack",	"sigaltstack",	None),# 186
    ( 4, TF,	"sys_sendfile",		"sendfile",	None),# 187
    ( 5, 0,	"printargs",		"SYS_188",	None),# 188XX
    ( 5, 0,	"printargs",		"SYS_189",	None),# 189XX
    ( 0, TP,	"sys_vfork",		"vfork",	None),	# 190
    ( 2, 0,	"sys_getrlimit",	"getrlimit",	None),# 191
    ( 6, 0,	"sys_mmap2",		"mmap2",	None),	# 192
    ( 2, TF,	"sys_truncate64",	"truncate64",	('P', None)),# 193
    ( 2, 0,	"sys_ftruncate64",	"ftruncate64",	None),# 194
    ( 3, TF,	"sys_stat64",		"stat64",	('P', None, None)),# 195
    ( 3, TF,	"sys_lstat64",		"lstat64",	('P', None, None)),# 196
    ( 3, 0,	"sys_fstat64",		"fstat64",	None),# 197
    ( 3, TF,	"sys_lchown",		"lchown",	('P', None, None)),# 198
    ( 0, 0,	"sys_getuid",		"getuid",	None),# 199
    ( 0, 0,	"sys_getgid",		"getgid",	None),# 200
    ( 0, 0,	"sys_geteuid",		"geteuid",	None),# 201
    ( 0, 0,	"sys_getegid",		"getegid",	None),# 202
    ( 2, 0,	"sys_setreuid",		"setreuid",	None),# 203
    ( 2, 0,	"sys_setregid",		"setregid",	None),# 204
    ( 2, 0,	"sys_getgroups",	"getgroups",	None),# 205
    ( 2, 0,	"sys_setgroups",	"setgroups",	None),# 206
    ( 3, 0,	"sys_fchown",		"fchown",	None),# 207
    ( 3, 0,	"sys_setresuid",	"setresuid",	None),# 208
    ( 3, 0,	"sys_getresuid",	"getresuid",	None),# 209
    ( 3, 0,	"sys_setresgid",	"setresgid",	None),# 210
    ( 3, 0,	"sys_getresgid",	"getresgid",	None),# 211
    ( 3, TF,	"sys_chown",		"chown",	('P', None, None)),	# 212
    ( 1, 0,	"sys_setuid",		"setuid",	None),# 213
    ( 1, 0,	"sys_setgid",		"setgid",	None),# 214
    ( 1, 0,	"sys_setfsuid",		"setfsuid",	None),# 215
    ( 1, 0,	"sys_setfsgid",		"setfsgid",	None),# 216
                                        # FIX: add to path sandbox
    ( 2, 0,	"sys_pivot_root",	"pivot_root",	('P', 'P')),# 217
    ( 3, 0,	"sys_mincore",		"mincore",	None),# 218
    ( 3, 0,	"sys_madvise",		"madvise",	None),# 219
    ( 3, 0,	"sys_getdents64",	"getdents64",	None),# 220
    ( 3, 0,	"sys_fcntl64",		"fcntl64",	None),# 221
    ( 4, 0,	"printargs",		"SYS_222",	None),# 222XX
    ( 5, 0,	"printargs",		"security",	None),# 223
    ( 0, 0,	"printargs",		"gettid",	None),# 224
    ( 4, 0,	"sys_readahead",		"readahead",	None),# 225
    ( 5, TF,	"sys_setxattr",		"setxattr",	None),# 226
    ( 5, TF,	"sys_setxattr",		"lsetxattr",	None),# 227
    ( 5, 0,	"sys_fsetxattr",		"fsetxattr",	None),# 228
    ( 4, TF,	"sys_getxattr",		"getxattr",	None),# 229
    ( 4, TF,	"sys_getxattr",		"lgetxattr",	None),# 230
    ( 4, 0,	"sys_fgetxattr",		"fgetxattr",	None),# 231
    ( 3, TF,	"sys_listxattr",		"listxattr",	None),# 232
    ( 3, TF,	"sys_listxattr",		"llistxattr",	None),# 233
    ( 3, 0,	"sys_flistxattr",		"flistxattr",	None),# 234
    ( 2, TF,	"sys_removexattr",		"removexattr",	None),# 235
    ( 2, TF,	"sys_removexattr",		"lremovexattr",	None),# 236
    ( 2, 0,	"sys_fremovexattr",		"fremovexattr",	None),# 237
    ( 2, TS,	"sys_kill",		"tkill",	None),# 238
    ( 4, TF,	"sys_sendfile64",		"sendfile64",	None),# 239
    ( 4, 0,	"sys_futex",		"futex",	None),# 240
    ( 3, 0,	"sys_sched_setaffinity",		"sched_setaffinity",	None),# 241
    ( 3, 0,	"sys_sched_getaffinity",		"sched_getaffinity",	None),# 242
    ( 1, 0,	"sys_set_thread_area",		"set_thread_area",	None),# 243
    ( 1, 0,	"sys_get_thread_area",		"get_thread_area",	None),# 244
    ( 2, 0,	"printargs",		"io_setup",	None),# 245
    ( 1, 0,	"printargs",		"io_destroy",	None),# 246
    ( 5, 0,	"printargs",		"io_getevents",	None),# 247
    ( 3, 0,	"printargs",		"io_submit",	None),# 248
    ( 3, 0,	"printargs",		"io_cancel",	None),# 249
    ( 5, 0,	"printargs",		"SYS_250",	None),# 250XX
    ( 5, 0,	"printargs",		"SYS_251",	None),# 251XX
    ( 1, TP,	"sys_exit",		"exit_group",	None),# 252
    ( 4, 0,	"printargs",		"lookup_dcookie",	None),# 253
    ( 1, 0,	"printargs",		"epoll_create",	None),# 254
    ( 4, 0,	"printargs",		"epoll_ctl",	None),# 255
    ( 4, 0,	"printargs",		"epoll_wait",	None),# 256
    ( 5, 0,	"sys_remap_file_pages",		"remap_file_pages",	None),# 257
    ( 1, 0,	"printargs",		"set_tid_address",	None),# 258
    ( 3, 0,	"sys_timer_create",		"timer_create",	None),# 259
    ( 4, 0,	"sys_timer_settime",		"timer_settime",	None),# 260
    ( 2, 0,	"sys_timer_gettime",		"timer_gettime",	None),# 261
    ( 1, 0,	"sys_timer_getoverrun",		"timer_getoverrun",	None),# 262
    ( 1, 0,	"sys_timer_delete",		"timer_delete",	None),# 263
    ( 2, 0,	"sys_clock_settime",		"clock_settime",	None),# 264
    ( 2, 0,	"sys_clock_gettime",		"clock_gettime",	None),# 265
    ( 2, 0,	"sys_clock_getres",		"clock_getres",	None),# 266
    ( 4, 0,	"sys_clock_nanosleep",		"clock_nanosleep",	None),# 267
    ( 5, 0,	"printargs",		"SYS_268",	None),# 268XX
    ( 5, 0,	"printargs",		"SYS_269",	None),# 269XX
    ( 5, 0,	"printargs",		"SYS_270",	None),# 270XX
    ( 5, 0,	"printargs",		"SYS_271",	None),# 271XX
    ( 5, 0,	"printargs",		"SYS_272",	None),# 272XX
    ( 5, 0,	"printargs",		"SYS_273",	None),# 273XX
    ( 5, 0,	"printargs",		"SYS_274",	None),# 274XX
    ( 5, 0,	"printargs",		"SYS_275",	None),# 275XX
    ( 5, 0,	"printargs",		"SYS_276",	None),# 276XX
    ( 5, 0,	"printargs",		"SYS_277",	None),# 277XX
    ( 5, 0,	"printargs",		"SYS_278",	None),# 278XX
    ( 5, 0,	"printargs",		"SYS_279",	None),# 279XX
    ( 5, 0,	"printargs",		"SYS_280",	None),# 280XX
    ( 5, 0,	"printargs",		"SYS_281",	None),# 281XX
    ( 5, 0,	"printargs",		"SYS_282",	None),# 282XX
    ( 5, 0,	"printargs",		"SYS_283",	None),# 283XX
    ( 5, 0,	"printargs",		"SYS_284",	None),# 284XX
    ( 5, 0,	"printargs",		"SYS_285",	None),# 285XX
    ( 5, 0,	"printargs",		"SYS_286",	None),# 286XX
    ( 5, 0,	"printargs",		"SYS_287",	None),# 287XX
    ( 5, 0,	"printargs",		"SYS_288",	None),# 288XX
    ( 5, 0,	"printargs",		"SYS_289",	None),# 289XX
    ( 5, 0,	"printargs",		"SYS_290",	None),# 290XX
    ( 5, 0,	"printargs",		"SYS_291",	None),# 291XX
    ( 5, 0,	"printargs",		"SYS_292",	None),# 292XX
    ( 5, 0,	"printargs",		"SYS_293",	None),# 293XX
    ( 5, 0,	"printargs",		"SYS_294",	None),# 294XX
    ( 5, 0,	"printargs",		"SYS_295",	None),# 295XX
    ( 5, 0,	"printargs",		"SYS_296",	None),# 296XX
    ( 5, 0,	"printargs",		"SYS_297",	None),# 297XX
    ( 5, 0,	"printargs",		"SYS_298",	None),# 298XX
    ( 5, 0,	"printargs",		"SYS_299",	None),# 299XX
    ( 8, 0,	"printargs",		"socket_subcall",	None),# 300
    ( 3, TN,	"sys_socket",		"socket",	None),# 301
    ( 3, TN,	"sys_bind",		"bind",	None),# 302
    ( 3, TN,	"sys_connect",		"connect",	None),# 303
    ( 2, TN,	"sys_listen",		"listen",	None),# 304
    ( 3, TN,	"sys_accept",		"accept",	None),# 305
    ( 3, TN,	"sys_getsockname",		"getsockname",	None),# 306
    ( 3, TN,	"sys_getpeername",		"getpeername",	None),# 307
    ( 4, TN,	"sys_socketpair",		"socketpair",	None),# 308
    ( 4, TN,	"sys_send",		"send",	None),# 309
    ( 4, TN,	"sys_recv",		"recv",	None),# 310
    ( 6, TN,	"sys_sendto",		"sendto",	None),# 311
    ( 6, TN,	"sys_recvfrom",		"recvfrom",	None),# 312
    ( 2, TN,	"sys_shutdown",		"shutdown",	None),# 313
    ( 5, TN,	"sys_setsockopt",		"setsockopt",	None),# 314
    ( 5, TN,	"sys_getsockopt",		"getsockopt",	None),# 315
    ( 5, TN,	"sys_sendmsg",		"sendmsg",	None),# 316
    ( 5, TN,	"sys_recvmsg",		"recvmsg",	None),# 317
    ( 4, 0,	"printargs",		"ipc_subcall0",	None),# 318
    ( 4, TI,	"sys_semop",		"semop",	None),# 319
    ( 4, TI,	"sys_semget",		"semget",	None),# 320
    ( 4, TI,	"sys_semctl",		"semctl",	None),# 321
    ( 5, TI,	"sys_semtimedop",		"semtimedop",	None),# 322
    ( 4, 0,	"printargs",		"ipc_subcall1",	None),# 323
    ( 4, 0,	"printargs",		"ipc_subcall2",	None),# 324
    ( 4, 0,	"printargs",		"ipc_subcall3",	None),# 325
    ( 4, 0,	"printargs",		"ipc_subcall4",	None),# 326
    ( 4, 0,	"printargs",		"ipc_subcall5",	None),# 327
    ( 4, 0,	"printargs",		"ipc_subcall6",	None),# 328
    ( 4, TI,	"sys_msgsnd",		"msgsnd",	None),# 329
    ( 4, TI,	"sys_msgrcv",		"msgrcv",	None),# 330
    ( 4, TI,	"sys_msgget",		"msgget",	None),# 331
    ( 4, TI,	"sys_msgctl",		"msgctl",	None),# 332
    ( 4, 0,	"printargs",		"ipc_subcall7",	None),# 333
    ( 4, 0,	"printargs",		"ipc_subcall8",	None),# 334
    ( 4, 0,	"printargs",		"ipc_subcall9",	None),# 335
    ( 4, 0,	"printargs",		"ipc_subcallA",	None),# 336
    ( 4, 0,	"printargs",		"ipc_subcallB",	None),# 337
    ( 4, 0,	"printargs",		"ipc_subcallC",	None),# 338
    ( 4, TI,	"sys_shmat",		"shmat",	None),# 339
    ( 4, TI,	"sys_shmdt",		"shmdt",	None),# 340
    ( 4, TI,	"sys_shmget",		"shmget",	None),# 341
    ( 4, TI,	"sys_shmctl",		"shmctl",	None),# 342
    )

# socketcall subcommands
# XXX: clean this up somehow
sockettable = (
    ( "invalid_call", ('bogus') ),	# subcommands are numbered from 1
    ( "socket", ('family', 'type', 'protocol')),
    ( "bind", ('f', 'A', 'l')),
    ( "connect", ('f', 'A', 'l')),
    ( "listen", ('f', 'i')),
    ( "accept", ('f', 'Ar', 'lp')), 		# 5
    ( "getsockname", ('f', 'Ar', 'lp')),
    ( "getpeername", ('f', 'Ar', 'lp')),
    ( "socketpair", ()),
    ( "send", ('f', 'buff', 'len', 'flags')),
    ( "recv", ('f', 'buff', 'Len', 'flags')),   # 10
    ( "sendto", ('f', 'buff', 'Len', 'flags', 'A', 'l')),
    ( "recvfrom", ('f', 'buff', 'len', 'flags', 'Ar', 'lp')),
    ( "shutdown", ('f', 'how')),
    ( "setsockopt", ('f', 'level', 'optname', 'optval', 'optlen')),
    ( "getsockopt", ('f', 'level', 'optname', 'optval', 'optlenp')), #15
    ( "sendmsg", ('f', 'msg', 'flags')),
    ( "recvmsg", ('f', 'msg', 'flags')),
    )

sockettable_num = len(sockettable) - 1

# XXX: Move callaccess from BoxTrick here? [Pavel]


def _init_call_to_number():
    result = {}
    for n in xrange(len(table)):
        name = table[n][3]
        assert not result.has_key(name), "duplicate call %s" % name
        result[name] = n
    return result

_call_to_number = _init_call_to_number()

def lookup_number(callname):
    assert _call_to_number.has_key(callname), \
           "no such call as %s" % callname
    return _call_to_number[callname]


def _call_table_is_valid():
    valid = 1
    for c in table:
        if c[SIGNATURE] and c[NARGS] != len(c[SIGNATURE]):
            print 'syscallmap: call %s signature is wrong length' % c[CALL]
            valid = 0
    return valid

assert _call_table_is_valid(), 'syscallmap invalid'
