/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DIFFPARAM_H
#define _SC_DIFFPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/Revision.h"
#include "svn/DiffSummarizeBaton.h"


namespace Diff
{
  enum Type
  {
    OneSource = 0,
    TwoSources = 1
  };
}


/**
 * Parameter class for DiffCmd.
 */
class DiffParam : public ScParam
{
public:
  DiffParam( 
    const sc::String& pathOrUrl1, const svn::RevisionPtr rev1,
    const sc::String& pathOrUrl2, const svn::RevisionPtr rev2,
    bool peg, const svn::RevisionPtr revPeg, bool recurse,
    bool ancestry, bool deleted, bool summarize, bool patch,
    svn::DiffSummarizeBaton* baton = 0 )
    : _pathOrUrl1(pathOrUrl1), _rev1(rev1),
      _pathOrUrl2(pathOrUrl2), _rev2(rev2),
      _peg(peg), _revPeg(revPeg), _recurse(recurse), _ancestry(ancestry),
      _deleted(deleted), _summarize(summarize), _patch(patch),
      _baton(baton)
  {
  }

  ~DiffParam()
  {
    delete _baton;
  }

  bool isPeg() const
  {
    return _peg;
  }

  const sc::String& getPathOrUrl1() const
  {
    return _pathOrUrl1;
  }

  void setPathOrUrl1( const sc::String& pathOrUrl )
  {
    _pathOrUrl1 = pathOrUrl;
  }

  const sc::String& getPathOrUrl2() const
  {
    return _pathOrUrl2;
  }

  void setPathOrUrl2( const sc::String& pathOrUrl )
  {
    _pathOrUrl2 = pathOrUrl;
  }

  svn::RevisionPtr getRevision1() const
  {
    return _rev1;
  }

  void setRevision1( svn::RevisionPtr rev )
  {
    _rev1 = rev;
  }

  svn::RevisionPtr getRevision2() const
  {
    return _rev2;
  }

  void setRevision2( svn::RevisionPtr rev )
  {
    _rev2 = rev;
  }

  const svn::RevisionPtr getPegRevision() const
  {
    return _revPeg;
  }

  void setPegRevision( svn::RevisionPtr rev )
  {
    _revPeg = rev;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  void setRecurse( bool recurse )
  {
    _recurse = recurse;
  }

  bool getAncestry() const
  {
    return _ancestry;
  }

  void setAncestry( bool ancestry )
  {
    _ancestry = ancestry;
  }

  bool getDeleted() const
  {
    return _deleted;
  }

  void setDeleted( bool deleted )
  {
    _deleted = deleted;
  }

  bool getSummarize() const
  {
    return _summarize;
  }

  void setSummarize( bool summarize )
  {
    _summarize = summarize;
  }

  svn::DiffSummarizeBaton* getBaton() const
  {
    return _baton;
  }

  void setBaton( svn::DiffSummarizeBaton* baton )
  {
    _baton = baton;
  }

  bool getPatch() const
  {
    return _patch;
  }

  sc::String& getPatchFile()
  {
    return _patchFile;
  }

  ScParamAccept(DiffParam);

private:
  // in
  sc::String               _pathOrUrl1;
  svn::RevisionPtr         _rev1;

  sc::String               _pathOrUrl2;  ///< only valid if _revPeg is 0
  svn::RevisionPtr         _rev2;

  bool                     _peg;
  svn::RevisionPtr         _revPeg;

  bool                     _recurse;
  bool                     _ancestry;
  bool                     _deleted;

  bool                     _summarize;
  bool                     _patch;      ///< true if patch file request

  svn::DiffSummarizeBaton* _baton;

  // out
  sc::String               _patchFile;  ///< the patch file if _patch is true
};

#endif // _SC_DIFFPARAM_H
