/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGLVI_H
#define _SC_LOGLVI_H

// sc
#include "LogData.h"
#include "util/Id.h"
class Cancel;

// qt
#include <Qt3Support/Q3ListView>


class LogLvi : public Q3ListViewItem
{
  typedef Q3ListViewItem super;

public:
  LogLvi( Q3ListView* parent, const LogData* data );
  LogLvi( Q3ListViewItem* parent, const LogData* data );
  virtual ~LogLvi();

  // -1  i > this
  // 0   i = this
  // 1   i < this
  int compare( Q3ListViewItem*, int, bool ) const;
  void paintCell( QPainter* p, const QColorGroup& cg, int column, int width, int alignment );

  unsigned long getId();

  void add( const LogData* data );
  void start();
  void stop();

  bool isStopped() const;
  bool isCancelable() const;
  bool isError() const;

  void setCancelable( Cancel* );
  void setCanceled();
  void setCancelNormal();
  void setCancelActive();
  void setCancelDisabled();
  
  bool isOnCancel( int x );

private:
  bool hasError();
  void adjustColumns();

  unsigned long    _sortId;
  const LogData*   _data;

  bool             _stopped;
  bool             _canceled;
  LogLvi*          _last;
  Cancel*          _cancel;
};


#endif //  _SC_LOGLVI_H
