/* ====================================================================
 * Copyright (c) 2003-2007, 2009  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// @todo rename!?!?!  StatusHelper? StatusDisplay? Status??

#ifndef _SC_STATUSID_H
#define _SC_STATUSID_H

// sc
#include "ColorId.h"
#include "svn/WcStatusTypes.h"
#include "util/String.h"

// qt
#include <QtCore/QVariant>
#include <QtCore/QString>
#include <QtGui/QColor>


/** @todo move to cpp, still used in WcStatusLvi.cpp */
// this must match with the columns added to the status views.
enum StatusColumns
{
  StatusColumnName,
  StatusColumnTextStatus,
  StatusColumnPropStatus,
  StatusColumnWcLocked,
  StatusColumnCopied,
  StatusColumnSwitched,
  StatusColumnRepLock,
  StatusColumnUpToDate,
  StatusColumnWcRev,
  StatusColumnCmtRev,
  StatusColumnCmtAuthor,
  StatusColumnDeepStatus,
  StatusColumnEmpty
};


enum StatusId
{
  // general (svn_wc_status_kind)
  StatusNone = 0,
  StatusUnversioned,
  StatusNormal,
  StatusAdded,
  StatusMissing,
  StatusDeleted,   
  StatusReplaced,
  StatusModified,
  StatusMerged,
  StatusConflicted,
  StatusIgnored,
  StatusObstructed,
  StatusExternal,
  StatusIncomplete,
  StatusFallback,

  // working copy lock
  StatusWcLockNone,
  StatusWcLockLocked,

  // history
  StatusHistoryNone,
  StatusHistory,

  // switched
  StatusSwitchedNo,
  StatusSwitched,

  // update to date
  StatusUpToDateNo,
  StatusUpToDate,

  // repository lock
  StatusLockNone,
  StatusLockLocked,
  StatusLockStolen,
  StatusLockOther,
  StatusLockBroken
};

/** make available to QVariant. */
Q_DECLARE_METATYPE(StatusId);


/** get a localized @a QString representing @a status. */
QString getStatusCode( svn::WcStatusKind status );

/** get a localized @a QString representing @a status. */ 
QString getLockStatusCode( svn::WcStatusLockKind status );

/** get a @a QColor set for @a status in the @a ColorStorage. */
QColor getStatusColor( svn::WcStatusKind status );


/** get the localized @a code for @a id. */
QString getStatusCode( StatusId id );

/** get the localized @a name for @a id. */
QString getStatusName( StatusId id );

/** get the @a QColor for @a id. */
QColor getStatusColor( StatusId id );

#endif // #define _SC_STATUSID_H
