/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ScParamEvent.h"
#include "../commands/ScParam.h"
#include "util/Error.h"


ScParamEvent::ScParamEvent( ScParam* param, const sc::Error* err )
: QCustomEvent(ScParameterEvent), _param(param), _error(err)
{
}

ScParamEvent::~ScParamEvent()
{
  delete _param;
  delete _error;
}

ScParam* ScParamEvent::getParam() const
{
  return _param;
}

const sc::Error* ScParamEvent::getError() const
{
  return _error;
}
