/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DELETEPARAM_H
#define _SC_DELETEPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/ClientTypes.h"
#include "svn/CommitInfo.h"

/**
 * Parameter class for DeleteCmd.
 */
class DeleteParam : public ScParam
{
public:
  DeleteParam( const svn::Paths& paths, bool force )
    : _paths(paths), _force(force)
  {
  }

  const svn::Paths& getPaths() const
  {
    return _paths;
  }

  bool getForce() const
  {
    return _force;
  }

  svn::CommitInfo& getCommitInfo()
  {
    return _info;
  }

  ScParamAccept(DeleteParam);

private:
  // in
  svn::Paths      _paths;
  bool            _force;

  // out
  svn::CommitInfo _info;
};

#endif // _SC_DELETEPARAM_H
