/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_COMMITDIALOG_H
#define _SC_COMMITDIALOG_H

// sc
#include "svn/ClientTypes.h"
#include "svn/CommitItemTypes.h"
#include "util/Id.h"
class ScModel;
namespace sc {
  class Condition;
}

// qt
#include <qdialog.h>
class QComboBox;
class QCheckBox;
class QPushButton;
class QTextEdit;
class QListView;
class QListViewItem;
class QLabel;


/**
 * closing the commit dialog will set the results through this
 * interface.
 */
class CommitResult
{
public:
  virtual ~CommitResult() {};

  virtual void setCommit( bool ) = 0;
  virtual void setLog( const sc::String& log ) = 0;
};


class CommitDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  CommitDialog( bool direct, ScModel* model, QWidget *parent, ID tid );
  virtual ~CommitDialog();

  void setPaths( const svn::Paths& items );
  void setCommitItems( const svn::CommitItems& items );
  void setCondition( sc::Condition* cond );
  void setResult( CommitResult* res );
  
public slots:
  void doubleClicked( QListViewItem*, const QPoint&, int );
  void cursorChanged( int x, int y );
  void logChanged();
  void logHistory(int);
  
  void list();
  void commit();
  void cancel();

private:
  void finish( bool commit );

  bool         _direct; 
  ScModel*     _model;
  ID           _tid;

  QComboBox*   _log;
  QCheckBox*   _recurse;
  QCheckBox*   _keepLocks;
  QTextEdit*   _edit;
  QLabel*      _pos;
  QLabel*      _url;
  QLabel*      _path;
  QListView*   _list;

  bool         _commitTriggered;

  QPushButton* _ls;
  QPushButton* _ok;
  QPushButton* _ca;

  svn::Paths     _items;
  sc::Condition* _cond;
  CommitResult*  _result;
};

#endif // _SC_COMMITDIALOG_H
