/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "ActionFactory.h"

// qt
#include <qaction.h>
#include <qobject.h>

// sys
#include <cassert>


QAction* ActionFactory::createAction(
  long key, QObject* parent, const QObject* receiver, const char* slot )
{
  QAction* qa = createAction(key,parent);
  QObject::connect( qa, SIGNAL(activated()), receiver, slot );
  return qa;
}

QAction* ActionFactory::createAction(
  long key, QObject* parent, const char* signal, const QObject* receiver, const char* slot )
{
  QAction* qa = createAction(key,parent);
  QObject::connect( qa, signal, receiver, slot );
  return qa;
}

QAction* ActionFactory::createAction( long key, QObject* parent )
{
  assert( key > afNull && key < afMax );

  switch( key )
  {
  case afDiffDlg:
    {
      // diff dialog
      QAction* qa = new QAction( _q("&diff.."), _q("Ctrl+Shift+D"), parent );
      qa->setStatusTip( _q("show diff between 2 selected revisions") );
      return qa;
    }
  default:
    assert(false);
    return NULL;
  }
}
