/*
 * Storm Package Manager
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <sys/types.h>
#include <sys/stat.h>	/* umask */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <assert.h>

#include "../libstormpkg/libstormpkg_app_include.h"


int maxID;
char *MainState=NULL;
pkgCache *MainPkgCache=NULL;
pkgRecords *MainPkgRecords=NULL;
pkgDepCache	 *MainPkgDepCache=NULL;
pkgCacheFile *MainPkgCacheFile=NULL;


int get_package_list(){
	static OpTextProgress	*otp=NULL;
	static FileFd *CacheF=NULL;
	static DynamicMMap *map=NULL;
	static pkgCacheGenerator *gen=NULL;
	
    _error->Discard();

	if  (gen)   delete(gen);
	if  (map)   delete(map);
	if  (CacheF)delete(CacheF);
    if  (MainPkgCacheFile)  {
//        MainPkgCacheFile->ReleaseLock();
        MainPkgCacheFile->Close();    
        delete(MainPkgCacheFile);
        }
    if  (otp)   delete(otp);

//	if (pkgInitialize(*_config)==false){
    if (pkgInitConfig(*_config)==false || 
	pkgInitSystem(*_config, _system)==false){
		return -1;
		}
//_config->Set("quiet", "2");
	otp=new OpTextProgress(*_config);
	if	(_error->PendingError()==true){
		return -2;
	    }

	MainPkgCacheFile=new pkgCacheFile();
//	if	(MainPkgCacheFile->Open(*otp, false)==false)	
	if	(MainPkgCacheFile->Open(*otp, true)==false)	
		return -3;

    MainPkgDepCache=MainPkgCacheFile->operator->();

//	CacheF=new FileFd(_config->FindFile("Dir::Cache::pkgcache"),FileFd::ReadOnly);
	CacheF=new FileFd(_config->FindFile("Dir::Cache::pkgcache"),FileFd::WriteAny);
	if	(_error->PendingError()==true)
		return -4;
    	
	map=new DynamicMMap(*CacheF, MMap::Public);
//	map=new DynamicMMap(*CacheF, MMap::ReadOnly);
	if	(_error->PendingError()==true)
		return	-5;

//	gen=new pkgCacheGenerator(*map, *otp);
	gen=new pkgCacheGenerator(map, otp);
	if	(_error->PendingError()==true)
		return	-6;

	MainPkgCache=&gen->GetCache();
	if	(_error->PendingError()==true)
		return	-7;

	pkgCache::PkgIterator pi;
	maxID=0;
	for	(pi=MainPkgCache->PkgBegin(); pi.end()==false; pi++)
        maxID++;

    if  (MainState)  free(MainState);
    MainState=(char*)malloc(maxID*sizeof(char));
    memset(MainState, 0, maxID);

	return MainPkgCache->Head().PackageCount;
    }


#define NUM_PACKAGE_PRIORITIES 6
static char *package_priorities[NUM_PACKAGE_PRIORITIES] = {
   "No priority",
   "Important",
   "Required",
   "Standard",
//   "Recommended",
   "Optional",
   "Extra",
//   "Contrib",
//   "Other",
};

char *get_package_priority_string(pkgCache::VerIterator* vi){
	char c;
	if	(vi->end()==false)
		c=(*vi)->Priority;
	else
		c='\0';
	return package_priorities[(int)c];

}










