/***************************************************************************
 *   Copyright (C) 2007 by Patrick Matthäi                                 *
 *   me@linux-development.eu                                               *
 *   http://www.Linux-Dev.org/                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "sshm.h"

int Connect::initial(char *serv){
	if(Search::line(serv) != 0){
		string serverstring = Search::get(serv);
		session(serverstring, serv);
	} else {
		cerr << "Can't find this server. Please have a look at the server list." << endl;
		return EXIT_SUCCESS;
	}
}

int Connect::session(string server, char *servalias){
	int cut=0,i=0;
	string ip,port,user;

	while(cut < 4){
		if(i > BUFFER){
			cerr << "Errorcode -2. Aborting!" << endl;
			exit(-2);
		}
		else if(isspace(server[i]) && cut == 0){
			cut++;
		}
		else if(cut == 1 && !isspace(server[i])){
			user += server[i];
		}
		else if(cut == 1 && isspace(server[i])){
			cut++;
		}
		else if(cut == 2 && !isspace(server[i])){
			ip += server[i];
		}
		else if(cut == 2 && isspace(server[i])){
			cut++;
		}
		else if(cut == 3 && !isspace(server[i])){
			port += server[i];
		}
		else if(cut == 3 && server[i] == '\0' || server[i] == '\n'){
			cut++;
		}
		i++;
	}

	stringstream ss;
	ss << "ssh -l " << user << " -p " << port << " " << ip;
	cout << "Connecting now to: " << servalias << endl;

	system(ss.str().c_str());
	return EXIT_SUCCESS;
}

Connect::~Connect(){
}
