##############################################################################  
#   
# This software is released under the Zope Public License (ZPL) Version 1.0
#
# Copyright (c) Digital Creations.  All rights reserved.  
# Portions Copyright (c) 1999 by Butch Landingin.
# Portions Copyright (c) 2000-2001 by Chris Withers.
#   
##############################################################################  

from Products.Squishdot.Squishdot import SquishSite,__doc__
from Globals import HTMLFile
from ImageFile import ImageFile  

__version__='$Revision: 1.5 $'[11:-2]  
    
# Register the Squishdot Site class
def initialize(context):

        context.registerClass(
            SquishSite,
            meta_type='Squishdot Site',
            constructors = (
                manage_addSquishdotForm,
                manage_addSquishdot
            )
        )            
        
# Load addSquishdotForm from disk
manage_addSquishdotForm = HTMLFile('addSquishdotForm', globals())

# method to construct a Squishdot Site
def manage_addSquishdot(self,id,title='',mailhost='',exp=0,expire='0',     
                              moderated=0, max_itemlist=30, default_doc='',
			mail_articles=0, mail_replies=0, REQUEST=None):     
    """Create Squishdot Site"""     
    if exp:     
        try:    expire=atoi(expire)     
        except: expire=0     
    else:   expire=0     
    if mailhost:     
        try:    v=getattr(self, mailhost)     
        except: return MessageDialog(title='Invalid Mail Host',     
                                     message='Cannot find the named mail host!',     
                                     action=REQUEST['URL1']+'/manage_main'     
                                    )     
    ob=SquishSite(id, title, mailhost, expire, moderated,
				       max_itemlist, default_doc,mail_articles,
				       mail_replies, parent=self)         
    self._setObject(id, ob)     
     
    if REQUEST: return self.manage_main(self,REQUEST,update_menu=1)  

# Load images from disk and make them accessible
misc_={'squishdot_img':  ImageFile('squishdot.gif',globals()),  
       'posting_img':    ImageFile('posting.gif',globals()),  
       'comment_img':    ImageFile('comment.gif',globals()),  
       'squishfile_img': ImageFile('squishfile.gif',globals()),  
       'squishlogo':     ImageFile('squishlogo.gif',globals())  
      }  

# make the mailhost_list method accessible
# does this need to be changed to the new system?
methods={ 'mailhost_list': SquishSite.mailhost_list }  


