-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--Note that the Process procedure does not return to point of call. Instead   --
--it raises an exception which is trapped by the main program, which causes   --
--the program to stop politely.                                               --
--                                                                            --
--The use of the State variable makes it easy to see where fatal errors may   --
--occur                                                                       --
--------------------------------------------------------------------------------

with E_Strings;

--# inherit CommandLine,
--#         E_Strings,
--#         SPARK_IO;

package FatalErrors
--# own State;
--# initializes State;
is
   type Error_Type is (
                       Could_Not_Open_Input_File,
                       Could_Not_Create_Report_File,
                       Data_Structure_Inconsistency,
                       VC_Data_Structure_Inconsistency,
                       Expected_Directory_Missing,
                       File_Heap_Full,
                       VC_Heap_Full,
                       Invalid_Command_Line,
                       Problem_Reading_File,
                       Problem_Creating_Temp_File,
                       Subprogram_Totals_Inconsistent);

   -- note Process DOES NOT return
   procedure Process (Error   : in Error_Type;
                      Message : in E_Strings.T);
   --# global out State;
   --# derives State from Error,
   --#                    Message;
   --# post False; -- does not terminate normally

end FatalErrors;
