/*  Sonicmail - POP3 email notifier
 *  Copyright (C) 2000  Cameron Edwards
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef SONICMAIL_PROPERTIES_H_INCLUDED
#define SONICMAIL_PROPERTIES_H_INCLUDED

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>

#include <applet-widget.h>
#include <libgnome/gnome-config.h>

#include "sonicmail-vars.h"
#include "sonicmail-pixmap.h"


// Check that pixmaps/wavs file path has been defined in the Makefile 
#ifndef XPMSPATH
#error "XPMSPATH not defined"
#endif

#ifndef WAVSPATH
#error "WAVSPATH not defined"
#endif

// Default pixmap/wav files are defined below:
#define SM_DEFAULT_EMPTY_XPM	"/ultrafina-nomail.xpm"
#define SM_DEFAULT_FULL_XPM	"/ultrafina-newmail.xpm"
#define SM_DEFAULT_OFFLINE_XPM	"/ultrafina-offline.xpm"
#define SM_DEFAULT_WAV		"/default.wav"

void sonicmail_properties_load(SonicmailVars *vars);
void sonicmail_properties_save(SonicmailVars *vars);

#endif
