/*  Sonicmail - POP3 email notifier
 *  Copyright (C) 2000  Cameron Edwards
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "sonicmail-pixmap.h"


void sonicmail_pixmap_gdk_load(GdkPixmap **dest, SonicmailVars *vars, char *filename)
{
   if(*dest) {
      gdk_pixmap_unref(*dest);
      *dest = NULL;
   }
   
   if(!vars->applet->window)
      gtk_widget_realize(GTK_WIDGET(vars->applet));
   
   gdk_color_alloc(gdk_colormap_get_system(), &vars->transp_col);
   
   *dest = gdk_pixmap_colormap_create_from_xpm(vars->applet->window, NULL, NULL,
                                              &vars->transp_col,
					      filename);
   if(! *dest)
      printf("Failed to load %s in function sonicmail_pixmap_gdk_load()\n", filename);
}



void sonicmail_pixmap_gtk_pixmap_set(GtkWidget **dest, SonicmailVars *vars, GdkPixmap *src)
{
   if(!(*dest)) {
      *dest = gtk_pixmap_new(src, NULL);
      gtk_box_pack_start(GTK_BOX(vars->box), *dest, TRUE, FALSE, 0);
   }
   else {
      gtk_pixmap_set(GTK_PIXMAP(*dest), src, NULL);
   }
   
   if(*dest) {
      gtk_widget_show(*dest);
   }
   else {
      printf("Error: GtkPixmap couldnt be created\n");
      exit(-1);
   }
}

void sonicmail_pixmap_refresh(SonicmailVars *vars)
{
   GdkPixmap *curr;   
   
   pthread_mutex_lock(&(vars->mut));
      switch(vars->state) {
 
         case Sonicmail_Offline:   curr = vars->pixmaps.offline_pixmap;
        			   break;
         case Sonicmail_Empty:     curr = vars->pixmaps.empty_pixmap;
        			   break;
         case Sonicmail_Full:	   curr = vars->pixmaps.full_pixmap;
        			   break;
         default:		   curr = vars->pixmaps.offline_pixmap;
      }
   pthread_mutex_unlock(&(vars->mut));
   
   sonicmail_pixmap_gtk_pixmap_set(&(vars->pixmaps.display_pixmap), vars, curr);
   
}
