/* $Id: sp_priority.h,v 1.2 2001/06/11 05:49:28 roesch Exp $ */
/*
** Copyright (C) 2001 Brian Caswell <bmc@mitre.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef __SP_PRIORITY_H__
#define __SP_PRIORITY_H__

#include "snort.h"

#define PLUGIN_PRIORITY_NUMBER    24

typedef struct _PriorityData
{
  int priority;
  char *type;
  char *name;
  int id;
} PriorityData;

void SetupPriority();
void TypeInit(char *, OptTreeNode *, int);
void PriorityInit(char *, OptTreeNode *, int);

void TypeRuleParseFunction(char *, OptTreeNode *);
void PriorityRuleParseFunction(char *, OptTreeNode *);

void NewPriorityNode(OptTreeNode *);

#endif  /* __SP_PRIORITY_H__ */
