<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: Displays stats on an individual IP address   
 *
 * Input GET/POST variables
 *   - action:
 *   - submit:
 *   - ip:
 *   - netmask:
 */

  include("acid_conf.php");
  include("acid_db.inc");
  include("acid_net.inc");
  include("acid_signature.inc");
  include("acid_db_common.php");
  include("acid_common.php");

  RegisterGlobalState();

  /* Explicitly choosing to ignore all other criteria but
   * the IP address
   */
  //ImportGlobalState();

  $ip = ImportHTTPVar("ip");
  $netmask = ImportHTTPVar("netmask");
  $action = ImportHTTPVar("action");
  $submit = ImportHTTPVar("submit");

  InitGlobalState();
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Roman Danyliw">
    <META HTTP-EQUIV="pragma" CONTENT="no-cache">
    <TITLE>ACID: Lookup for
     <?php
       echo $ip.'/'.$netmask;
      ?> 
    </TITLE>
    <LINK rel="stylesheet" type="text/css" href="acid_style.css">
</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle">
     <?php
       echo $ip.'/'.$netmask;
      ?> 
      Lookup</TD>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("acid_hdr2.html");
     ?>
  </TD>
</TR>
</TABLE>
<P><P>

<?php

function PrintPortscanEvents($db, $ip)
{
  GLOBAL $portscan_file;

  if ( !$portscan_file )
  {
     ErrorMessage("PORTSCAN EVENT ERROR: ".
                  "No file was specified in the \$portscan_file variable.");
     return;
  }

  $fp = fopen($portscan_file,"r");
  if ( !$fp )
  {
     ErrorMessage("PORTSCAN EVENT ERROR: ".
                  "Unable to open Portscan event file '".$portscan_file."'");
     return;
  }

  echo '<TABLE BORDER=1 width="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
        <TR>
           <TD CLASS="plfieldhdr">Date/Time</TD>
           <TD CLASS="plfieldhdr">Source IP</TD>
           <TD CLASS="plfieldhdr">Source Port</TD>
           <TD CLASS="plfieldhdr">Destination IP</TD>
           <TD CLASS="plfieldhdr">Destination Port</TD>
           <TD CLASS="plfieldhdr">TCP Flags</TD>
        </TR>';

  $total = 0;

  while ( !feof($fp) )
  {
   $contents = fgets($fp, 255);   

   if(ereg($ip, $contents)) {
     $total++;
     if( $i % 2 == 0 ) {
        $color="DDDDDD";
     }else{
        $color="FFFFFF";
     }
     $contents = ereg_replace("  "," ",$contents);
     $elements = explode(" ", $contents);
     echo '<tr bgcolor='.$color.'><td align="center">'.
             $elements[0].' '.$elements[1].' '.$elements[2].'</td>';
     ereg("([0-9]*\.[0-9]*\.[0-9]*\.[0-9]*):([0-9]*)",$elements[3],$store);
     echo '<td align="center">'.$store[1].'</td>';
     echo '<td align="center">'.$store[2].'</td>';
     ereg("([0-9]*\.[0-9]*\.[0-9]*\.[0-9]*):([0-9]*)",$elements[5],$store);
     echo '<td align="center">'.$store[1].'</td>';
     echo '<td align="center">'.$store[2].'</td>';
     echo '<td align="center">'.$elements[7].'</td></tr>';

   }
  }

  fclose($fp);

  echo '<TR>
         <TD CLASS="plfieldhdr" align="left">Total Hosts Scanned</TD>
         <TD CLASS="plfieldhdr">'.$total.'</TD>
         <TD CLASS="plfieldhdr" colspan="4">&nbsp;</TD>
        </TR>
        </TABLE>';
}

function PrintEventsByIP($db, $ip)
{
  /* Jeffs stuff */
  /* Count total events for the given address */
  $event_cnt = EventCntByAddr($db, $ip);

  /* Grab unique alerts and count them */
  $unique_events = UniqueEventCntByAddr($db, $ip, $count);
  $unique_event_cnt = count($unique_events);

 echo '<B>'.$unique_event_cnt.' unique alerts detected among '.$event_cnt.' alerts on '.
       $ip.'/32</B><BR>';
   
  /* Print the Statistics on Each of the Unique Alerts */
  echo '<TABLE BORDER=1>
        <TR>
           <TD CLASS="plfieldhdr">Signature</TD>
           <TD CLASS="plfieldhdr">Total<BR> Occurrences</TD>
           <TD CLASS="plfieldhdr">Num of Sensors</TD>
           <TD CLASS="plfieldhdr">First<BR> Occurrance</TD>
           <TD CLASS="plfieldhdr">Last<BR> Occurrance</TD>
        </TR>';

 for ( $i = 0; $i < $unique_event_cnt; $i++ ) 
 {
   $current_event = $unique_events[$i];

   $total = UniqueEventTotalsByAddr($db, $ip, $current_event);
   $num_sensors = UniqueSensorCntByAddr($db, $ip, $current_event);
   $start_time = StartTimeForUniqueEventByAddr($db, $ip, $current_event);
   $stop_time = StopTimeForUniqueEventByAddr($db, $ip, $current_event);

   /* Print out */ 
   echo '<TR>';
   echo "  <TD ALIGN=CENTER> ".BuildSigByID($unique_events[$i], $db);
   $tmp_iplookup = 'acid_pkt_main.php?new=1'.
                   '&sig%5B0%5D=%3D&sig%5B1%5D='.(rawurlencode($unique_events[$i])).
                   '&num_result_rows=-1'.
                   '&submit=Query+DB&current_view=-1&ip_addr_cnt=2'.
                   BuildIPFormVars($ip);

   echo "  <TD ALIGN=CENTER> <A HREF=\"$tmp_iplookup\">$total</A> ";
   echo "  <TD ALIGN=CENTER> $num_sensors ";
   echo "  <TD ALIGN=CENTER> $start_time";
   echo "  <TD ALIGN=CENTER VALIGN=CENTER> $stop_time";
   echo '</TR>';
}

echo "</TABLE>\n";
}

  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidPConnect($alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  if ( strstr($sig[1], "spp_portscan") )
     $sig[1] = "";

   $tmp_srcdst_iplookup = 'acid_pkt_main.php?new=2'.
                          '&num_result_rows=-1'.
                          '&submit=Query+DB&current_view=-1&ip_addr_cnt=2'.
                          BuildIPFormVars($ip);

   $tmp_src_iplookup    = 'acid_pkt_main.php?new=2'.
                          '&num_result_rows=-1'.
                          '&submit=Query+DB&current_view=-1&ip_addr_cnt=1'.
                          BuildSrcIPFormVars($ip);

   $tmp_dst_iplookup    = 'acid_pkt_main.php?new=2'.
                          '&num_result_rows=-1'.
                          '&submit=Query+DB&current_view=-1&ip_addr_cnt=1'.
                          BuildDstIPFormVars($ip);
?>

<CENTER>
 <FONT> all alerts with      
     <?php
       echo $ip.'/'.$netmask;
      ?>  as :</FONT> 
<?php
  echo '
 <A HREF="'.$tmp_src_iplookup.'">source</A> | 
 <A HREF="'.$tmp_dst_iplookup.'">destination</A> | 
 <A HREF="'.$tmp_srcdst_iplookup.'">source/destination</A><BR>';

 echo '<FONT>
       lookup (whois) in: ';
 if ( !VerifySocketSupport() )
    echo '
       <A HREF="http://www.arin.net/cgi-bin/whois.pl?queryinput='.$ip.'">ARIN</A> |
       <A HREF="http://www.ripe.net/cgi-bin/whois?query='.$ip.'">RIPE</A> |
       <A HREF="http://www.apnic.net/apnic-bin/whois.pl?search='.$ip.'">APNIC</A> &nbsp;&nbsp;||&nbsp; ';
 echo '<A HREF="http://www.samspade.org/t/lookat.cgi?whois=on&ipblock=on&address='.$ip.'">SamSpade</A><BR>';

  echo 'show: 
       <A HREF="acid_stat_ipaddr.php?ip='.$ip.'&netmask='.$netmask.'&action=events">unique alerts</A>
       &nbsp; | &nbsp;
       <A HREF="acid_stat_ipaddr.php?ip='.$ip.'&netmask='.$netmask.'&action=portscan">portscan events</A>
       </FONT>';
?>
 <P>

</CENTER>
<HR>

<FORM METHOD="POST" ACTION="acid_stat_ipaddr.php">

<?php
  if ( $debug_mode == 1 )
     echo '<TABLE BORDER=1>
             <TR><TD>action</TD><TD>submit</TD><TD>ip</TD><TD>netmask</TD></TR>
             <TR><TD>'.$action.'</TD><TD>'.$submit.'</TD>
                 <TD>'.$ip.'</TD><TD>'.$netmask.'</TD></TR>
           </TABLE>';

  /* Print the Statistics the IP address */
  echo '<CENTER><B>'.$ip.'</B><BR>FQDN: <B>';
  if ( $ip != "255.255.255.255" )
        echo acidGetHostByAddr($ip, $db, $dns_cache_lifetime);
   else
        echo $ip.' (Broadcast)';
 
  if ( VerifySocketSupport() )
     echo '&nbsp;&nbsp;( <A HREF="acid_stat_ipaddr.php?ip='.$ip.'&netmask='.$netmask.'&action=whois">whois</A> )';
 
  echo    '</B>
        <TABLE BORDER=1>
        <TR>
           <TD CLASS="plfieldhdr">Num of <BR>Sensors</TD>
           <TD CLASS="plfieldhdr">Occurances <BR>as Src.</TD>
           <TD CLASS="plfieldhdr">Occurances <BR>as Dest.</TD>
           <TD CLASS="plfieldhdr">First<BR> Occurance</TD>
           <TD CLASS="plfieldhdr">Last<BR> Occurance</TD>
        </TR>';

  $ip_src32 = acidIP2long($ip);
  $ip_dst32 = $ip_src32;
  /* Number of Sensor  */
  $temp = "SELECT DISTINCT sid FROM iphdr WHERE ".
          "(ip_src = $ip_src32 OR ip_dst = $ip_dst32 )";
  $result2 = $db->acidExecute($temp);
  $num_sensors = $result2->acidRecordCount();
  $result2->acidFreeRows();

  /* Unique instances as Source Address  */
  $temp = "SELECT sid from iphdr WHERE ip_src=$ip_src32";  
  $result2 = $db->acidExecute($temp);
  $num_src_ip = $result2->acidRecordCount();
  $result2->acidFreeRows(); 

  /* Unique instances Dest. Address  */
  $temp = "SELECT sid from iphdr WHERE ip_dst=$ip_dst32";
  $result2 = $db->acidExecute($temp);
  $num_dst_ip = $result2->acidRecordCount();
  $result2->acidFreeRows(); 

  /* First and Last timestamp of this address */
  $temp = "SELECT min(timestamp), max(timestamp) FROM event INNER JOIN iphdr ".
          "ON (event.sid=iphdr.sid AND event.cid=iphdr.cid) WHERE ".
          "( (ip_src=$ip_src32) OR (ip_dst=$ip_dst32) )";
  $result2 = $db->acidExecute($temp);
  $myrow = $result2->acidFetchRow();
  $start_time = $myrow[0];
  $stop_time = $myrow[1];
  $result2->acidFreeRows();

  /* Print out */ 
  echo '<TR>
         <TD ALIGN=CENTER>'.$num_sensors;
  if ( $num_src_ip == 0 )
         echo '<TD ALIGN=CENTER>'.$num_src_ip;
  else
         echo '<TD ALIGN=CENTER><A HREF="'.$tmp_src_iplookup.'">'.$num_src_ip.'</A>';
  if ( $num_dst_ip == 0 )         
         echo '<TD ALIGN=CENTER>'.$num_dst_ip;
  else
         echo '<TD ALIGN=CENTER><A HREF="'.$tmp_dst_iplookup.'">'.$num_dst_ip.'</A>';
  echo '
         <TD ALIGN=CENTER>'.$start_time.'
         <TD ALIGN=CENTER VALIGN=CENTER>'.$stop_time.'
       </TR>
      </TABLE></CENTER>';

  if ( $action == "events" )
  {
     echo '<HR>
            <CENTER><P>';
     PrintEventsByIP($db, $ip);
     echo ' </CENTER>';	
  }
  else if ( $action == "whois" )
  {
     echo "\n<B>Whois Information</B>".
          "<PRE>".acidGetWhois($ip, $db, $whois_cache_lifetime)."</PRE>";
  }
  else if ( $action == "portscan" )
  {
     echo '<HR>
            <CENTER><P>';
     PrintPortscanEvents($db, $ip);
     echo ' </CENTER>';	
  }  
?>

</FORM>

<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>

</HTML>




