<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: Displays statistics on the detected alerts   
 *
 * Input GET/POST variables
 *   - caller: specifies the canned snapshot to run
 *   - action:
 *   - submit:
 *   - sort_order:
 *   - action_arg:
 *   - current_view:
 *   - num_result_rows:
 */
?>
<?php
  $start = time();

  include ("acid_conf.php");
  include ("acid_db.inc");
  include ("acid_signature.inc");
  include ("acid_action.inc");
  include ("acid_net.inc");
  include ("acid_db_common.php");
  include ("acid_common.php");
  include ("acid_pkt_common.php");
  include ("acid_stat_common.php");
  include ("acid_ag_common.php");

  RegisterGlobalState();
  ImportGlobalState();

  $caller = ImportHTTPVar("caller");
  $action = ImportHTTPVar("action");
  $submit = ImportHTTPVar("submit");
  $sort_order = ImportHTTPVar("sort_order");
  $ag_add_key = ImportHTTPVar("action_arg");
  $current_view = ImportHTTPVar("current_view");
  $num_result_rows = ImportHTTPVar("num_result_rows");

  //if ( $HTTP_GET_VARS["caller"] != "" )
  //   $caller = $HTTP_GET_VARS["caller"];
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Roman Danyliw">
    <META HTTP-EQUIV="pragma" CONTENT="no-cache">
    <TITLE>ACID: Unique Alert Listing</TITLE>
  <LINK rel="stylesheet" type="text/css" href="acid_style.css">

</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle">Alert Listing
     <?php if ( $caller == "most_frequent" ) echo ": Most Frequent $freq_num_alerts Alerts";
           if ( $caller == "last_alerts" )   echo ": Last $last_num_ualerts Alerts"; 
      ?></TD>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("acid_hdr2.html");
     ?>
  </TD>

</TR>
</TABLE>
<P><P>

<?php
  if ( $debug_mode > 0 )  PrintPageHeader();

  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidPConnect($alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  PrintCriteria("");
  $criteria_clauses = ProcessCriteria();  

  $from = " FROM event ".$criteria_clauses[0];
  $where = " WHERE ".$criteria_clauses[1];

  $valid_action = array ("ag_by_id", "ag_by_name", "del_alert", "clear_alert", 
                         "email_alert", "email_alert2", 
                         "archive_alert", "archive_alert2");
  $valid_action_op = array ("Selected", "ALL on Screen");
  $action_sql = $from.$where;

  ActOnSelectedAlerts($action, $valid_action, $submit, $valid_action_op, $action_arg,
                      2,
                      $action_chk_lst, $action_lst,
                      $show_rows, $num_result_rows,
                      $action_sql, $caller,
                      $db );

  /* Initialized Data */
  if ( $submit == "" )
  {
     $num_result_rows = -1;
     $current_view = -1;
  }
  /* Moving among the views */
  else
    $current_view = $submit;

  /* Get total number of events */
  //if ( ($caller != "most_frequent") && ($caller != "last_alerts") )
     $event_cnt = EventCnt($db);

  /* create SQL to get Unique Alerts */
  $sql = "SELECT DISTINCT signature ".$from.$where;
  $cnt_sql = "SELECT count(DISTINCT signature) ".$from.$where;

  /* Run the query to determine the number of rows (No LIMIT)*/
  if ( ($caller != "last_alerts") && ($caller !="most_frequent") &&
       ($num_result_rows == -1) )
  {
     $current_view = 0;
     $result = $db->acidExecute($cnt_sql);
     if ( $result )
     {
        //$num_result_rows = $result->acidRecordCount();
        $rows = $result->acidFetchRow();
        $num_result_rows = $rows[0];
        $result->acidFreeRows();
     }
     else
        $num_result_rows = 0;
   } 

  /* Generate SQL with the sort criteria */
  $field_tmp = "";
  $join = " ";

  if ( $sort_order == "" ) $sort_order = "sig_a";

  $ver = db_schema_version($db);
  if ( ($sort_order == "sig_a") ||
       ($sort_order == "sig_d")    )   
  { 
     //$field_tmp = ", sig_name ";
     //if ( $ver >= 100 )
     //{
        /* Catch PostgreSQL schema version 100 bug */
     //   if ( ($DBtype == "postgres") && $ver == 100 )
     //      $join = " INNER JOIN signature ON event.signature::int4=signature.sig_id ";           
     //   else
     //      $join = " INNER JOIN signature ON event.signature=signature.sig_id ";
     //}
  }

  if ( ($sort_order == "first_a") ||
       ($sort_order == "first_d") )    $field_tmp = ", min(timestamp) AS first_timestamp ";

  if ( ($sort_order == "last_a") ||
       ($sort_order == "last_d") )     $field_tmp = ", max(timestamp) AS last_timestamp ";

  if ( ($sort_order == "occur_a") ||
       ($sort_order == "occur_d") )    $field_tmp = " "; //$field_tmp = ", count(signature) AS sig_cnt ";

  if ( ($sort_order == "saddr_a") ||
       ($sort_order == "saddr_d") )    $field_tmp = ", count(ip_src) AS saddr_cnt ";

  if ( ($sort_order == "daddr_a") ||
       ($sort_order == "daddr_d") )    $field_tmp = ", count(ip_dst) AS daddr_cnt ";

  $sql = "SELECT DISTINCT signature, count(signature) as sig_cnt, min(timestamp), max(timestamp) ".
         $field_tmp.$from.$join.$where;

  //$sql = "SELECT DISTINCT signature ".$field_tmp.$from.$where;

  //$sql = "SELECT DISTINCT signature, COUNT(event.cid) ".$field_tmp.$from.$where;
  //$sql = "SELECT signature, count(event.cid) ".$field_tmp.$from.$where." GROUP BY signature"; 

  $sort_tmp = " ORDER BY signature ";
  if ( $sort_order == "sig_a" )
  {
     //if ( $ver >= 100 )
     // $sort_tmp = " GROUP BY signature ORDER BY sig_name ASC";
     //else 
     // $sort_tmp = " GROUP BY signature ORDER BY signature ASC";
     $sort_tmp = " GROUP BY signature ORDER BY signature ASC";
  }
  if ( $sort_order == "sig_d" )
  {  
     //if ( $ver >= 100 )
     // $sort_tmp = " GROUP BY ORDER BY sig_name DESC";
     //else    
     // $sort_tmp = " GROUP BY ORDER BY signature DESC";
     $sort_tmp = " GROUP BY signature ORDER BY signature DESC";
  }
  if ( $sort_order == "first_a" )    $sort_tmp = " GROUP BY signature ORDER BY first_timestamp ASC";
  if ( $sort_order == "first_d" )    $sort_tmp = " GROUP BY signature ORDER BY first_timestamp DESC";
  if ( $sort_order == "last_a" )     $sort_tmp = " GROUP BY signature ORDER BY last_timestamp ASC";
  if ( $sort_order == "last_d" )     $sort_tmp = " GROUP BY signature ORDER BY last_timestamp DESC";
  if ( $sort_order == "occur_a" )    $sort_tmp = " GROUP BY signature ORDER BY sig_cnt ASC";
  if ( $sort_order == "occur_d" )    $sort_tmp = " GROUP BY signature ORDER BY sig_cnt DESC ";
  if ( $sort_order == "saddr_a" )    $sort_tmp = " GROUP BY signature ORDER BY saddr_cnt ASC";
  if ( $sort_order == "saddr_d" )    $sort_tmp = " GROUP BY signature ORDER BY saddr_cnt DESC ";  
  if ( $sort_order == "daddr_a" )    $sort_tmp = " GROUP BY signature ORDER BY daddr_cnt ASC";
  if ( $sort_order == "daddr_d" )    $sort_tmp = " GROUP BY signature ORDER BY daddr_cnt DESC ";

  /* Run the Query again for the actual data (with the LIMIT) */
  if ( $caller == "most_frequent" )
  {
     $result = $db->acidExecute($sql.$sort_tmp, 0, $freq_num_alerts);
     $limit_tmp_offset = 0;  $limit_tmp_count = $freq_num_alerts;
  }
  else if ( $caller == "last_alerts" )
  {
     $result = $db->acidExecute($sql.$sort_tmp, 0, $last_num_ualerts);
     $limit_tmp_offset = 0;  $limit_tmp_count = $last_num_ualerts;
  }
  else
  {
     $result = $db->acidExecute($sql.$sort_tmp, ($current_view * $show_rows), $show_rows); 
     $limit_tmp_offset = $current_view * $show_rows;  $limit_tmp_count = $show_rows;
  }

  if ( $debug_mode == 1 )
     echo $sql.$sort_tmp." - (".$limit_tmp_offset.", ".$limit_tmp_count.")";

  /* Print the current view number and # of rows */
  if ( $num_result_rows != 0 )
  {
     if ( $caller == "most_frequent" )
        printf("<FONT><CENTER>Displaying %d Most Frequent Alerts<BR> ".
            "</CENTER></FONT><BR>\n", 
            $freq_num_alerts);
     else if ( $caller == "last_alerts" )
        printf("<FONT><CENTER>Displaying the Last %d Alerts<BR> ".
            "</CENTER></FONT><BR>\n", 
            $last_num_ualerts);
     else        
         printf("<FONT><CENTER>Displaying alerts %d-%d of %d total<BR> ".
            "(Aggregating %d events)</CENTER></FONT><BR>\n", 
            ($current_view * $show_rows)+1, 
            (($current_view * $show_rows) + $show_rows-1) < $num_result_rows ? 
            (($current_view * $show_rows) + $show_rows) : $num_result_rows, 
            $num_result_rows,
            $event_cnt);
  }
  else
     printf("<P><B>No Alerts were found.  Is the database empty?</B><P>\n");

  echo '<FONT>&nbsp<B>Queried DB on </B><FONT> : '.date("D F d, Y H:i:s",time()).'</FONT>';
  /* Print the Statistics on Each of the Unique Alerts */

  echo '<FORM METHOD="post" NAME="PacketForm" ACTION="acid_stat_alerts.php">';
  
  echo '<TABLE CELLSPACING=0 CELLPADDING=2 BORDER=0 WIDTH="100%" BGCOLOR="#000000">
        <TR><TD>';
  echo '<TABLE CELLSPACING=0 CELLPADDING=0 BORDER=0 WIDTH="100%" BGCOLOR="#FFFFFF">
        <TR>
           <TD CLASS="plfieldhdr">&nbsp;</TD>
           <TD CLASS="plfieldhdr">
              <A HREF="acid_stat_alerts.php?caller='.$caller.'&sort_order=sig_a">&lt;</A>&nbsp; Signature 
              <A HREF="acid_stat_alerts.php?caller='.$caller.'&sort_order=sig_d">&gt;</A></TD>
           <TD CLASS="plfieldhdr">
              <A HREF="acid_stat_alerts.php?caller='.$caller.'&sort_order=occur_a">&lt;</A>&nbsp;Total<BR># 
              <A HREF="acid_stat_alerts.php?caller='.$caller.'&sort_order=occur_d">&gt;</A></TD>
           <TD CLASS="plfieldhdr"># <BR>Sensors</TD>
           <TD CLASS="plfieldhdr">Src. <BR>Addr</TD>
           <TD CLASS="plfieldhdr">Dst. <BR>Addr</TD>
           <TD CLASS="plfieldhdr">
              <A HREF="acid_stat_alerts.php?caller='.$caller.'&sort_order=first_a">&lt;</A>&nbsp;First 
              <A HREF="acid_stat_alerts.php?caller='.$caller.'&sort_order=first_d">&gt;</A></TD>';

   if ( $show_previous_alert == 1 )
        echo '<TD CLASS="plfieldhdr">Previous</TD>';

   echo '   <TD CLASS="plfieldhdr">
              <A HREF="acid_stat_alerts.php?caller='.$caller.'&sort_order=last_a">&lt;</A>&nbsp;Last
              <A HREF="acid_stat_alerts.php?caller='.$caller.'&sort_order=last_d">&gt;</A></TD>
        </TR>';

           //<TD CLASS="plfieldhdr">
           //   <A HREF="acid_stat_alerts.php?caller=$caller&sort_order=saddr_a">&lt;</A>&nbsp;Src. Addr
           //   <A HREF="acid_stat_alerts.php?caller=$caller&sort_order=saddr_d">&gt;</A></TD>
           //<TD CLASS="plfieldhdr">
           //   <A HREF="acid_stat_alerts.php?caller=$caller&sort_order=daddr_a">&lt;</A>&nbsp;Dst. Addr
           //   <A HREF="acid_stat_alerts.php?caller=$caller&sort_order=daddr_d">&gt;</A></TD>

  $i = 0;
  while ( ($myrow = $result->acidFetchRow()) && ($i < $limit_tmp_count) )
  {
     $sig_name = $myrow[0];

     /* get Total Occurance */
     $total_occurances = $myrow[1];

     /* Unique sensor, source and destination IPs with this signature */
     if ( strstr($from, "iphdr")  )
        $temp = "SELECT COUNT(DISTINCT event.sid), ".
                "COUNT(DISTINCT ip_src), COUNT(DISTINCT ip_dst) ".
                $from.$where." AND signature='".$sig_name."'";
     else
        $temp = "SELECT COUNT(DISTINCT event.sid), ".
                "COUNT(DISTINCT ip_src), COUNT(DISTINCT ip_dst) ".$from.
                "LEFT JOIN iphdr ON event.sid=iphdr.sid AND event.cid=iphdr.cid ".
                $where." AND signature='".$sig_name."'";

     $result2 = $db->acidExecute($temp);
     $statrow = $result2->acidFetchRow();
     $num_sensors = $statrow[0];
     $num_src_ip = $statrow[1];
     $num_dst_ip = $statrow[2];
     $result2->acidFreeRows(); 

     /* First and Last timestamp of this signature */
     $start_time = $myrow[2];
     $stop_time = $myrow[3];

     $temp = "SELECT timestamp, event.sid, event.cid ".$from.$where.
             " AND signature='".$sig_name."'
             ORDER BY timestamp DESC";
     $result2 = $db->acidExecute($temp, 0, 2);
     $last = $result2->acidFetchRow();
     $last_num = $total_occurances - 1;

     /* Getting the previous timestamp of this signature 
      * (I.E. The occurance before Last Timestamp) 
      */
     if ( $show_previous_alert == 1 )
     {
        if ( $total_occurances == 1 )
        {
           $prev = $last;
           $prev_time = $prev[0];
           $prev_num = 0;
        }
        else
        {
                $prev = $result2->acidFetchRow();
                $prev_time = $prev[0];
		$prev_num = $total_occurances - 2;
                $result2->acidFreeRows();
        }
     }

     /* Doing the same as above for the first entry that we are searching for.
      * The reason for doing this is because some older DB's such as ones using ODBC
      * probably don't support the move() function. Therefore, for the older DB's 
      * to get the first entry from the $temp variable above, we would need to 
      * continue to call MoveNext() for each and every entry for that signature. For 
      * signatures with a large amount of alerts(i.e. >1000), this could cause a severe
      * performance hit for those users.
      */ 
     $temp = "SELECT timestamp, event.sid, event.cid ".$from.$where.
             " AND signature='".$sig_name."'
             ORDER BY timestamp ASC";
     $result2 = $db->acidExecute($temp, 0, 1);
     $first = $result2->acidFetchRow();
     $first_num = 0;
     $result2->acidFreeRows();

     if (strstr($from, "iphdr") == "" )
        $from_link = $from." INNER JOIN iphdr ON event.sid=iphdr.sid AND event.cid=iphdr.cid ";
     else
        $from_link = $from;

     /* Print out */ 
     echo '<TR BGCOLOR="'.((($i % 2) == 0) ? "DDDDDD" : "FFFFFF").'">';
     $tmp_rowid = rawurlencode($sig_name);
     echo '  <TD>&nbsp;&nbsp;
                 <INPUT TYPE="checkbox" NAME="action_chk_lst['.$i.']" VALUE="'.$tmp_rowid.'">
                 &nbsp;&nbsp;
             </TD>';
     echo '      <INPUT TYPE="hidden" NAME="action_lst['.$i.']" VALUE="'.$tmp_rowid.'">';
     echo '  <TD ALIGN=CENTER>&nbsp;&nbsp;'.BuildSigByID($sig_name, $db).'&nbsp;&nbsp;</TD>';
     echo '  <TD ALIGN=CENTER>&nbsp;&nbsp;
               <FONT>
               <A HREF="acid_pkt_main.php?new=1&sig%5B0%5D=%3D&sig%5B1%5D='.
                              (rawurlencode($sig_name)).'&sig_type=1&caller=stat_alerts'.
                              '&submit=Query+DB&num_result_rows=-1">'.$total_occurances.'</A> 
                    ('.(round($total_occurances/$event_cnt*100)).'%)
               </FONT>&nbsp;&nbsp;</TD>';
     echo '  <TD ALIGN=CENTER>&nbsp;<FONT>'.$num_sensors.'</FONT>&nbsp;</TD>';

     if ( db_schema_version($db) >= 100 )
        $addr_link = '&sig_type=1&sig%5B0%5D=%3D&sig%5B1%5D='.$sig_name;
     else
        $addr_link = '&sig%5B0%5D=%3D&sig%5B1%5D='.$sig_name;

     echo '  <TD ALIGN=CENTER>&nbsp;&nbsp;
               <FONT>'.BuildUniqueAddressLink(1, $addr_link).$num_src_ip.'</A>
               </FONT>&nbsp;&nbsp;</TD>';
               
     echo '  <TD ALIGN=CENTER>&nbsp;&nbsp;
               <FONT>'.BuildUniqueAddressLink(2, $addr_link).$num_dst_ip.'</A>
               </FONT>&nbsp;&nbsp;</TD>';

     echo '  <TD ALIGN=CENTER>&nbsp;&nbsp;
             <FONT>
	     <A HREF="acid_pkt_main.php?sig%5B0%5D=%3D&sig%5B1%5D='.
             rawurlencode($sig_name).'&sig_type=1'.
             '&submit=%23'.$first_num.'-%28'.$first[1].'-'.$first[2].'%29">'.
	     $start_time.'</FONT>&nbsp;&nbsp;</TD>';

     if ( $show_previous_alert == 1 )
        echo '  <TD ALIGN=CENTER>&nbsp;&nbsp;
                <FONT>
                <A HREF="acid_pkt_main.php?sig%5B0%5D=%3D&sig%5B1%5D='.
                rawurlencode($sig_name).'&sig_type=1'.
                '&submit=%23'.$prev_num.'-%28'.$prev[1].'-'.$prev[2].'%29">'.
		$prev_time.'</FONT>&nbsp;&nbsp;</TD>';
     
     echo '  <TD ALIGN=CENTER>&nbsp;&nbsp;
             <FONT>
             <A HREF="acid_pkt_main.php?sig%5B0%5D=%3D&sig%5B1%5D='.
             rawurlencode($sig_name).'&sig_type=1'.
             '&submit=%23'.$last_num.'-%28'.$last[1].'-'.$last[2].'%29">'.
             $stop_time.'</FONT>&nbsp;&nbsp;</TD>';

     echo '  </TR>';

     $i++;
     $prev_time = null;
}

$result->acidFreeRows();

echo "</TABLE>\n";
echo "</TD></TR></TABLE>";


echo '<INPUT TYPE="hidden" NAME="num_result_rows" VALUE="'.$num_result_rows.'">';
echo '<INPUT TYPE="hidden" NAME="current_view" VALUE="'.$current_view.'">';
echo '<INPUT TYPE="hidden" NAME="sort_order" VALUE="'.$sort_order.'">';

/* ****** Print out Browsing Buttons ********************************************/
if ( $caller != "most_frequent" && $caller != "last_alerts" )
   PrintBrowseButtons($num_result_rows, $show_rows, $max_scroll_buttons, $current_view);

PrintQueryResultAction($action, $ag_add_key, 5); 

echo '</FORM>';

$stop = time();
echo "<H3>$event_cnt, ".($stop-$start)." seconds</H3>"; 

?>

<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>
