 <?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 */

  /* **************** Run the Query ************************************************** */

  /* If this is the first call to the search, process the raw user-entered criteria.
   * Otherwise, retrieve the previously generated SQL string from the shared state. 
   */
//  if ( $num_result_rows == -1 )
//  {
     ProcessCriteria();
     $sql = $sql.$join_sql.$where_sql.$criteria_sql;

     /* Apply sort criteria */
     if ( $caller == "last_tcp" || $caller == "last_udp" || 
         $caller == "last_icmp" || $caller == "last_any" )
            $sql = $sql." ORDER BY timestamp DESC ";
     else
     {
        if ( $sort_order == "time_a" )      $sql = $sql." ORDER BY timestamp ASC ";  
        else if ( $sort_order == "time_d" ) $sql = $sql." ORDER BY timestamp DESC ";
        else if ( $sort_order == "sig_a" )  $sql = $sql." ORDER BY signature ASC ";
        else if ( $sort_order == "sig_d" )  $sql = $sql." ORDER BY signature DESC ";
        else if ( $sort_order == "sip_a" )  $sql = $sql." ORDER BY ip_src ASC ";
        else if ( $sort_order == "sip_d" )  $sql = $sql." ORDER BY ip_src DESC ";
        else if ( $sort_order == "dip_a" )  $sql = $sql." ORDER BY ip_dst ASC ";
        else if ( $sort_order == "dip_d" )  $sql = $sql." ORDER BY ip_dst DESC ";
        else if ( $sort_order == "proto_a" )  $sql = $sql." ORDER BY ip_proto ASC ";
        else if ( $sort_order == "proto_d" )  $sql = $sql." ORDER BY ip_proto DESC ";
     }
//     $save_sql = $sql;
//  }
//  else
//     $sql = $save_sql;

  /* Export the SQL into the shared state variable */
  /* if ( $save_sql == "" )
     $save_sql = $sql;
  else
     $sql = $save_sql; */

  if ( $debug_mode > 0 )
     echo "<P>SQL (save_sql): $sql";

  /* Run the query to determine the number of rows (No LIMIT)*/
  if ( $num_result_rows == -1 )
  {
     $current_view = 0;
     $result = $db->acidExecute($sql, -1, -1, false);

     if ( ($db->acidErrorMessage() != "") || !$result )
     {
        ErrorMessage("<B>Query execution error:</B> ".$db->acidErrorMessage());
        die();
     }

     if ( $result )
     {
        $num_result_rows = $result->acidRecordCount();
        $result->acidFreeRows();
     }
     else
        $num_result_rows = 0;
   }

  /* Run the Query again for the actual data (with the LIMIT) */

  /* When display a Snapshot of alerts limit the number displayed */
  if ( $caller == "last_tcp" || $caller == "last_udp" || 
       $caller == "last_icmp" || $caller == "last_any" )
  {
     $result = $db->acidExecute($sql, 0, $last_num_alerts);
     $tmp_start = 0;  
     $tmp_count = $last_num_alerts;
     $limit_offset = $last_num_alerts;
  }
  else
  {
     $result = $db->acidExecute($sql, ($current_view * $show_rows), $show_rows);
     $tmp_start = ($current_view * $show_rows);  $tmp_count = $show_rows;
     $limit_offset = $show_rows;
  }

  if ( $debug_mode == 1 )
     printf("<P>%s - (LIMIT %d, %d)<HR>\n", $sql, $tmp_start, $tmp_count);

  if ( !$printing_ag )
  {
     /* ***** Generate and print the criteria in human readable form */
     echo '<TABLE WIDTH="100%">
           <TR>
             <TD WIDTH="60%">';

     PrintCriteria($caller);
     if ( $caller == "last_tcp" || $caller == "last_udp" ||
          $caller == "last_icmp" || $caller == "last_any" )
     {
        $tmp_limit_start = 0;
        $tmp_limit_offset = $last_num_alerts;
     }
     else
     {
       $tmp_limit_start = -1;
       $tmp_limit_offset = -1;    
     } 

     echo '</TD>
           <TD WIDTH="40%" VALIGN=TOP>

            <TABLE WIDTH="100%" CELLSPACING=0 CELLPADDING=2 BORDER=0 BGCOLOR="#669999">
            <TR><TD> 
            <TABLE WIDTH="100%" CELLSPACING=0 CELLPADDING=2 BORDER=0 BGCOLOR="#FFFFFF">
              <TR><TD class="sectiontitle">&nbsp;Statistics</TD></TR>
              <TR><TD>
               <UL>
                 <LI>General statistics
                 <LI>Unique addresses: '. 
                   BuildUniqueAddressLink(1).'source</A> | '.
                   BuildUniqueAddressLink(2).'destination</A>
                 <LI><A HREF="acid_stat_alerts.php">Alert Listing</A>
               </UL>
              </TD></TR></TABLE>
             </TD></TR></TABLE>
            </TD>
          </TR>
         </TABLE>';
  }

  /* Print the current view number and # of rows */
  if ( $num_result_rows != 0 )
  {
     if (  $caller == "last_tcp" || $caller == "last_udp" || 
           $caller == "last_icmp" || $caller == "last_any" ) 
        printf("<HR><FONT><CENTER> Displaying <B>last %d</B> rows of %d</CENTER></FONT><BR>\n", 
               $last_num_alerts, $num_result_rows);
     else
        printf("<HR><FONT><CENTER>Displaying rows %d-%d of %d </CENTER></FONT><BR>\n", 
               ($current_view * $show_rows)+1, 
         (($current_view * $show_rows) + $show_rows-1) < $num_result_rows ? 
           (($current_view * $show_rows) + $show_rows) : $num_result_rows, 
         $num_result_rows);
  }
  else
     printf("<P><HR><B>No Packets were found matching the specified criteria.  0 Rows returned.</B><P><P>\n");

  /* Print the search results */
  //if ( $num_rows > 0 )
  if ( $num_result_rows > 0 )
  {
     /* Client-side Javascript to select all the check-boxes on the screen
      *   - Bill Marque (wlmarque@hewitt.com) */
     echo '
          <SCRIPT Language=Javascript>
            function SelectAll()
            {
               for(var i=0;i<document.PacketForm.elements.length;i++)
               {
                  if(document.PacketForm.elements[i].type == "checkbox")
                  {
                    document.PacketForm.elements[i].checked = true;
                  }
               }
            }
      
            function UnselectAll()
            {
                for(var i=0;i<document.PacketForm.elements.length;i++)
                {
                    if(document.PacketForm.elements[i].type == "checkbox")
                    {
                      document.PacketForm.elements[i].checked = false;
                    }
                }
            }
           </SCRIPT>';

    if ( !$printing_ag )
       $page = "acid_pkt_main.php";
    else
       $page = "acid_ag_main.php";

    echo '<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 WIDTH="100%" BGCOLOR="#000000">
          <TR><TD>';
    echo '<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 BGCOLOR="#FFFFFF" WIDTH="100%">';
    echo '<TR>
             <TD><INPUT type=checkbox value="Select All" onClick="if (this.checked) SelectAll(); if (!this.checked) UnselectAll();"></TD>
              <TD CLASS="plfieldhdr">ID</TD>
              <TD CLASS="plfieldhdr">
               <A HREF="'.$page.'?num_result_rows='.$num_result_rows.'&submit=Query%20DB'.
                 '&current_view='.$current_view.'&sort_order=sig_a'.
                 '&caller='.$caller.'">&lt;</A>
                 Signature
               <A HREF="'.$page.'?num_result_rows='.$num_result_rows.'&submit=Query%20DB'.
                 '&current_view='.$current_view.'&sort_order=sig_d'.
                 '&caller='.$caller.'">&gt;</A></TD>
              <TD CLASS="plfieldhdr">
               <A HREF="'.$page.'?num_result_rows='.$num_result_rows.'&submit=Query%20DB'.
                 '&current_view='.$current_view.'&sort_order=time_a'.
                 '&caller='.$caller.'">&lt;</A>
                  TimeStamp
               <A HREF="'.$page.'?num_result_rows='.$num_result_rows.'&submit=Query%20DB'.
                 '&current_view='.$current_view.'&sort_order=time_d'.
                 '&caller='.$caller.'">&gt;</A></TD>
              <TD CLASS="plfieldhdr">
               <A HREF="'.$page.'?num_result_rows='.$num_result_rows.'&submit=Query%20DB'.
                 '&current_view='.$current_view.'&sort_order=sip_a'.
                 '&caller='.$caller.'">&lt;</A>
                  Source<BR>Address
               <A HREF="'.$page.'?num_result_rows='.$num_result_rows.'&submit=Query%20DB'.
                 '&current_view='.$current_view.'&sort_order=sip_d'.
                 '&caller='.$caller.'">&gt;</A></TD>
              <TD CLASS="plfieldhdr">
               <A HREF="'.$page.'?num_result_rows='.$num_result_rows.'&submit=Query%20DB'.
                 '&current_view='.$current_view.'&sort_order=dip_a'.
                 '&caller='.$caller.'">&lt;</A>
                 Dest.<BR>Address
               <A HREF="'.$page.'?num_result_rows='.$num_result_rows.'&submit=Query%20DB'.
                 '&current_view='.$current_view.'&sort_order=dip_d'.
                 '&caller='.$caller.'">&gt;</A></TD>
              <TD CLASS="plfieldhdr">
               <A HREF="'.$page.'?num_result_rows='.$num_result_rows.'&submit=Query%20DB'.
                 '&current_view='.$current_view.'&sort_order=proto_a'.
                 '&caller='.$caller.'">&lt;</A>
                Layer 4<BR>Proto
               <A HREF="'.$page.'?num_result_rows='.$num_result_rows.'&submit=Query%20DB'.
                 '&current_view='.$current_view.'&sort_order=proto_d'.
                 '&caller='.$caller.'">&gt;</A></TD>';

    /* Clear the old checked positions */
    for ( $i = 0; $i < $show_rows; $i++)  
    { 
        $action_lst[$i] = "";  
        $action_chk_lst[$i] = ""; 
    }

    $i = 0;
    //for ( $i = 0; $i < $num_rows; $i++ )
    while ( ($myrow = $result->acidFetchRow()) && ($i < $limit_offset) )
    {
      $current_sip32 = $myrow[4];
      $current_sip = acidLong2IP($current_sip32);
      $current_dip32 = $myrow[5];
      $current_dip = acidLong2IP($current_dip32); 
      $current_proto = $myrow[6];
      $current_sig = BuildSigByID($myrow[2], $db);
      $current_sig_txt = BuildSigByID($myrow[2], $db, 2);
      $current_sport = $current_dport = "";

      //$myrow = $result->acidFetchRow();
      echo '<TR BGCOLOR="'.((($i % 2) == 0) ? "DDDDDD" : "FFFFFF").'">';

      $tmp_rowid = "#".(($current_view * $show_rows)+$i)."-(".$myrow[0]."-".$myrow[1].")";

      echo '    <TD><INPUT TYPE="checkbox" NAME="action_chk_lst['.$i.']" VALUE="'.$tmp_rowid.'"></TD>';
      echo '    <INPUT TYPE="hidden" NAME="action_lst['.$i.']" VALUE="'.$tmp_rowid.'">';
      echo '    <TD>';
      echo '        <CENTER>
                    <A HREF="acid_pkt_main.php?submit='.rawurlencode($tmp_rowid).'">'.
                       $tmp_rowid.
                   '</A>
                    </CENTER>';
      echo '        </FONT></TD>';
      echo '    <TD ALIGN=CENTER>'.$current_sig.'</TD>';
      echo '    <TD ALIGN=CENTER>'.$myrow[3].'</TD>';
      $tmp_iplookup = 'acid_pkt_main.php?sig%5B0%5D=%3D'.
                          '&num_result_rows=-1'.
                          '&time%5B0%5D%5B0%5D=+&time%5B0%5D%5B1%5D=+'.
                          '&submit=Query+DB&current_view=-1&ip_addr_cnt=2';
      echo '    <TD ALIGN=CENTER>';

      /* TCP or UDP show the associated port # */ 
      if ( $current_proto == 6 )
         $result4 = $db->acidExecute("SELECT tcp_sport, tcp_dport FROM tcphdr ".
                                     "WHERE sid=".$myrow[0]." AND cid=".$myrow[1]);
      else if ( $current_proto == 17 )
         $result4 = $db->acidExecute("SELECT udp_sport, udp_dport FROM udphdr ".
                                     "WHERE sid=".$myrow[0]." AND cid=".$myrow[1]);
      
      if ( ($current_proto == 6) || ($current_proto == 17) )
      {
         $myrow4 = $result4->acidFetchRow();

         if ( $myrow4[0] != "" )  $current_sport = ":".$myrow4[0];
         if ( $myrow4[1] != "" )  $current_dport = ":".$myrow4[1];
      }
      
      if ( $current_sip32 != "" )
      {
         echo '   <A HREF="acid_stat_ipaddr.php?ip='.$current_sip.'&netmask=32">'.
                     $current_sip.
                 '</A><FONT SIZE="-1">'.$current_sport.'</FONT>';
      }
      else
      {
        /* if no IP address was found check if this is a spp_portscan message
         * and try to extract a source IP
         * - contrib: Michael Bell <michael.bell@web.de>
         */
        if ( stristr($current_sig_txt, "portscan") )
        {
           $line = split (" ", $current_sig_txt);
           foreach ($line as $ps_element) 
           {
             if ( ereg("[0-9]*\.[0-9]*\.[0-9]*\.[0-9]", $ps_element)  )
             {
                $ps_element = ereg_replace (":", "", $ps_element);
                echo "<A HREF=\"acid_stat_ipaddr.php?ip=".$ps_element."&netmask=32\">".$ps_element."</A>";
             }
           }
        }
        else
           echo '   <A HREF="acid_app_faq.php#1">unknown</A>';
      }
      echo '    </TD>';
      echo '    <TD ALIGN=CENTER>';
      if ( $current_dip32 != "" )
         echo '   <A HREF="acid_stat_ipaddr.php?ip='.$current_dip.'&netmask32">'.
                     $current_dip.
                 '</A><FONT SIZE="-1">'.$current_dport.'</FONT>';
       else
         echo '   <A HREF="acid_app_faq.php#1">unknown</A>';    

      echo '    </TD>';
      echo '    <TD ALIGN=CENTER><FONT>'.IPProto2str($current_proto).'</FONT></TD></TR>';

      $i++;
      if ( ($current_proto == 6) || ($current_proto == 17) )
      {
         $result4->acidFreeRows();
         $myrow4[0] = $myrow4[1] = "";
      }
    }
    $result->acidFreeRows();
  }
  echo "</TABLE>";
  echo "</TD></TR></TABLE>";

  /* Print Browsing Buttons
   *   Only print the browsing buttons if not returning a snapshot */
  if ( !($caller == "last_tcp" || $caller == "last_udp" || 
         $caller == "last_icmp" || $caller == "last_any") )
     PrintBrowseButtons($num_result_rows, $show_rows, $max_scroll_buttons, $current_view);

  /* Print out the Action information */
  if ( $num_result_rows > 0 )
  {
     if ( !$printing_ag ) 
        PrintQueryResultAction($action, $action_arg, 2);
     else
        PrintQueryResultAction($action, $action_arg, 4); 
  }
?>








