<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 * Input GET/POST variables
 *   - caller: specifies the canned snapshot to run
 *   - action:
 *   - submit:
 *   - sort_order:
 *   - action_arg:
 *   - current_view:
 *   - num_result_rows:
 *
 */

/*
 * $caller: an auxiliary variable used to determine the how the search parameters were entered (i.e.
 *          whether through a form or through another mechanism
 *  - "stat_alerts" : display results based on the the Alert Listings
 *  - "top_tcp" :
 *  - "top_udp" :
 *  - "top_icmp" :
 *  - "last_tcp" :
 *  - "last_udp" :
 *  - "last_icmp" :
 *
 * $submit: used to determine the next action which should be taken when the form is submitted.
 *  - "Query DB"       : triggers a query into the database
 *  - "ADD Time"       : adds another date/time row 
 *  - "ADD Addr"       : adds another IP address row
 *  - "ADD IP Field"   : adds another IP field row
 *  - "ADD TCP Port"   : adds another TCP port row
 *  - "ADD TCP Field"  : adds another TCP field row
 *  - "ADD UDP Port"   : adds another UDP port row
 *  - "ADD UDP Field"  : adds another UDP field row
 *  - "ADD ICMP Field" : adds another ICMP field row
 *  - "#X-(X-X)"       : sid-cid keys for a packet lookup
 *
 * $layer4: stores the layer 4 protocol used in query
 *
 * $save_sql: the current sql string generating the query
 *
 * $save_criteria: HTML-human readable criteria of the $save_sql string
 *
 * $num_result_rows: rows in the entire record set retried under the current 
 *                   query
 *
 * $current_view: current view of the result set
 *
 * $sort_order: how to sort the output
 *
 * Meta
 * ====
 * 
 * $ag: AG ID 
 *
 * $sensor: sensor ID
 *
 * $sig[2]: stores signature
 *   - [0] : exactly, roughly             [1] : signature
 *
 * $time[MAX][10]: stores the date/time of the packet detection
 *  - [][0] : (                           [][5] : hour  
 *  - [][1] : =, !=, <, <=, >, >=         [][6] : minute
 *  - [][2] : month                       [][7] : second
 *  - [][3] : day                         [][8] : (, )
 *  - [][4] : year                        [][9] : AND, OR
 *
 * $time_cnt : number of rows in the $time[][] structure
 *
 * IP Variables
 * ============
 *
 * $ip_addr[MAX][10]: stores an ip address parameters/operators row
 *  - [][0] : (                          [][5] : octet3 of address
 *  - [][1] : source, dest               [][6] : octet4 of address
 *  - [][2] : =, !=                      [][7] : network mask
 *  - [][3] : octet1 of address          [][8] : (, )
 *  - [][4] : octet2 of address          [][9] : AND, OR
 *
 * $ip_addr_cnt: number of rows in the $ip_addr[][] structure
 *
 * $ip_field[MAX][6]: stores all other ip fields parameters/operators row
 *  - [][0] : (                            [][3] : field value
 *  - [][1] : TOS, TTL, ID, offset, length [][4] : (, )
 *  - [][2] : =, !=, <, <=, >, >=          [][5] : AND, OR
 *
 * $ip_field_cnt: number of rows in the $ip_field[][] structure
 *
 * TCP Variables
 * =============
 *
 * $tcp_port[MAX][6]: stores all port parameters/operators row
 *  - [][0] : (                            [][3] : port value
 *  - [][1] : Source Port, Dest Port       [][4] : (, )
 *  - [][2] : =, !=, <, <=, >, >=          [][5] : AND, OR
 *
 * $tcp_port_cnt: number of rows in the $tcp_port[][] structure
 *
 * $tcp_flags[7]: stores all other tcp flags parameters/operators row
 *  - [0] : is, contains                   [4] : 8     (RST)
 *  - [1] : 1   (FIN)                      [5] : 16    (ACK)
 *  - [2] : 2   (SYN)                      [6] : 32    (URG)
 *  - [3] : 4   (PUSH)
 *
 * $tcp_field[MAX][6]: stores all other tcp fields parameters/operators row
 *  - [][0] : (                            [][3] : field value
 *  - [][1] : windows, URP                 [][4] : (, )
 *  - [][2] : =, !=, <, <=, >, >=          [][5] : AND, OR
 *
 * $tcp_field_cnt: number of rows in the $tcp_field[][] structure
 *
 * UDP Variables
 * =============
 *
 * $udp_port[MAX][6]: stores all port parameters/operators row
 *  - [][0] : (                            [][3] : port value
 *  - [][1] : Source Port, Dest Port       [][4] : (, )
 *  - [][2] : =, !=, <, <=, >, >=          [][5] : AND, OR
 *
 * $udp_port_cnt: number of rows in the $udp_port[][] structure
 *
 * $udp_field[MAX][6]: stores all other udp fields parameters/operators row
 *  - [][0] : (                            [][3] : field value
 *  - [][1] : length                       [][4] : (, )
 *  - [][2] : =, !=, <, <=, >, >=          [][5] : AND, OR
 *
 * $udp_field_cnt: number of rows in the $udp_field[][] structure
 *
 * ICMP Variables
 * ==============
 * $icmp_field[MAX][6]: stores all other icmp fields parameters/operators row
 *  - [][0] : (                            [][3] : field value
 *  - [][1] : code, length                 [][4] : (, )
 *  - [][2] : =, !=, <, <=, >, >=          [][5] : AND, OR
 *
 * $icmp_field_cnt: number of rows in the $icmp_field[][] structure
 *
 * Payload Variables
 * =================
 * $data_encode[2]: how the payload should be interpreted and converted
 *  - [0] : encoding type (hex, ascii)
 *  - [1] : conversion type (hex, ascii) 
 *
 * $data[MAX][5]: stores all the payload related parameters/operators row
 *  - [][0] : (                            [][3] : (, )
 *  - [][1] : =, !=                        [][4] : AND, OR
 *  - [][2] : field value
 *
 * $data_cnt: number of rows in the $data[][] structure
 *
 * ----- Search Result Variables ----
 * $action_chk_lst[]: array of check boxes to determine if an alert
 *                    was selected for action
 * $action_lst[]: array of (sid,cid) of all alerts on screen
 */
?>
<?php
  include("acid_conf.php");
  include("acid_db.inc");
  include("acid_net.inc");
  include("acid_signature.inc");
  include("acid_action.inc");
  include("acid_db_common.php");
  include("acid_common.php");
  include("acid_ag_common.php");
  include("acid_pkt_common.php");

  $new = ImportHTTPVar("new");

  $caller = ImportHTTPVar("caller");
  $action = ImportHTTPVar("action");
  $submit = ImportHTTPVar("submit");
  $sort_order = ImportHTTPVar("sort_order");
  $action_arg = ImportHTTPVar("action_arg");
  $current_view = ImportHTTPVar("current_view");
  $num_result_rows = ImportHTTPVar("num_result_rows");
  $layer4 = ImportHTTPVar("layer4");
  $ip_addrs = ImportHTTPVar("ip_addrs");
  $ip_address_input2 = ImportHTTPVar("ip_address_input2");

  if ( $new == 2 )
  {
     InitGlobalState();
     /* Required to re-init these variables in the GET enviroment
      * because they are both in the shared state and sent
      * via the GET.
      */
     $HTTP_GET_VARS["layer4"] = "";
     $HTTP_GET_VARS["caller"] = "";
     $new = 1;
  }

/* Code to correct 'interesting' (read: unexplained) browser behavior
 *
 *  Lynx incorrectly modifies appended variables at the end of the URL occasionally.
 *    e.g. ...Submit+Query&num_result_row=-1  becomes ...Submit+Query#_result_row=-1
 *  I am at a loss as to why this happens, however, I am inserting logic here and
 *  there to prevent it from breaking ACID too seriously. 
 */
if ( $num_result_rows == "" )
   $num_result_rows = -1;

/* Something with Netscape 4.75 such that the $submit variable is no recognized
 * under certain circumstances.  This one is a result of using HTTPS and 
 * clicking on TCP traffic profile from acid_main.php 
 */
if ( $layer4 != "" && $submit == "" )
   $submit = "Query DB";

/* End 'interesting' browser code fixes */

  /* if scrolling between pages read the session */
  if ( !($new >= 1) )
  {
     RegisterGlobalState();
     ImportGlobalState();
  }

  /* if access the first query result page from the criteria specification
   *   then read the session and migrate the POST variables into the session
   */ 
  if ( ($new >= 1) && ($submit == "Query DB") )
  {
     RegisterGlobalState();
     ImportGlobalState();

     /* If the search form is configured to accept IP address as a single
      * field, re-populate the auxiliary array which breaks the addr into octets
      */
     if ( ($ip_address_input == 2) || ($ip_address_input2 == 2) )
     {
        if ( $debug_mode > 0 )  ErrorMessage("Converting IP address to 4 octets");
        for ( $i = 0; $i < $ip_addr_cnt; $i++)
        {
           $tmp = $ip_addrs[$i];
           if ( $ip_addrs[$i] != "" )
           {
              $ip_addr[$i][3] = strtok($tmp, ".");
              $ip_addr[$i][4] = strtok(".");
              $ip_addr[$i][5] = strtok(".");
              $ip_addr[$i][6] = strtok("");
           }
         }
      }
  }
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Roman Danyliw">
    <META HTTP-EQUIV="pragma" CONTENT="no-cache">

<?php
  if ( $caller == "last_tcp" || $caller == "last_udp" || 
       $caller == "last_icmp" || $caller == "last_any" )
       PrintFreshPage($refresh_stat_page, $stat_page_refresh_time);

    if ( $caller == "last_tcp" )
       echo '  <TITLE>ACID: Last '.$last_num_alerts.' TCP Alerts</TITLE>'; 
    else if ( $caller == "last_udp" )
       echo '  <TITLE>ACID: Last '.$last_num_alerts.' UDP Alerts</TITLE>'; 
    else if ( $caller == "last_icmp" )
       echo '  <TITLE>ACID: Last '.$last_num_alerts.' ICMP Alerts</TITLE>'; 
    else if ( $caller == "last_any" )
       echo '  <TITLE>ACID: Last '.$last_num_alerts.' Alerts</TITLE>';
    else if ( $caller == "stat_alerts" )
       echo '  <TITLE>ACID: Alert Search Results</TITLE>';
    else if ($submit == "Query DB" )
       echo '  <TITLE>ACID: Query Results</TITLE>';
    else if ( strstr($submit, "#") != "" )
       echo '  <TITLE>ACID: Alert Display</TITLE>';
    else 
       echo '  <TITLE>ACID: Query by Packet</TITLE>';
?>

  <LINK rel="stylesheet" type="text/css" href="acid_style.css">

</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_hdr1.html");
     ?>
  </TD>
<?php
  if ( $caller == "last_tcp" )
     echo '  <TD class="mainheadertitle">Last '.$last_num_alerts.' TCP Alerts</TD>';
  else if ( $caller == "last_udp" )
     echo '  <TD class="mainheadertitle">Last '.$last_num_alerts.' UDP Alerts</TD>';
  else if ( $caller == "last_icmp" )
     echo '  <TD class="mainheadertitle">Last '.$last_num_alerts.' ICMP Alerts</TD>';
  else if ( $caller == "last_any" )
     echo '  <TD class="mainheadertitle">Last '.$last_num_alerts.' Alerts</TD>';
  else if ( $caller == "stat_alerts" )
     echo '  <TD class="mainheadertitle">Alert Search Results</TD>';
  else if ($submit == "Query DB" )
     echo '  <TD class="mainheadertitle">Query Results</TD>';
  else if ( strstr($submit, "#") != "" )
     echo '  <TD class="mainheadertitle">Alert Display</TD>';
  else
     echo '  <TD class="mainheadertitle">Query by Packet</TD>';
?>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("acid_hdr2.html");
     ?>
  </TD>
</TR>
</TABLE>
<P><P>

<?php
  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidConnect($alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  //$t = rawurldecode($save_criteria);
  //$save_criteria = $t;
  $printing_ag = false;
?>

<FORM METHOD="POST" NAME="PacketForm" ACTION="acid_pkt_main.php">

<?php
/* Initialized Data */
if ( $submit == "" )
{
   $time_cnt = 1;
   $ip_addr_cnt = 1;
   $ip_field_cnt = 1;
   $tcp_port_cnt = 1;
   $tcp_field_cnt = 1;
   $udp_port_cnt = 1;
   $udp_field_cnt = 1;
   $icmp_field_cnt = 1;
   $data_cnt = 1;
   $layer4 = "";
   $num_result_rows = -1;
   $current_view = -1;
}

if ( $submit == "TCP" )   {  $layer4 = "TCP";   }
if ( $submit == "UDP" )   {  $layer4 = "UDP";   }
if ( $submit == "ICMP" )  {  $layer4 = "ICMP";  }
if ( $submit == "no layer4" )  {  $layer4 = "";      }

if ( $submit == "ADD Time"             && $time_cnt < $MAX_ROWS)         
   AddCriteriaFormRow($submit, $layer4, $time_cnt, $time[$time_cnt-1][9]);
if ( $submit == "ADD Addr"             && $ip_addr_cnt < $MAX_ROWS)     
   AddCriteriaFormRow($submit, $layer4, $ip_addr_cnt, $ip_addr[$ip_addr_cnt-1][9]);
if ( $submit == "ADD IP Field"         && $ip_field_cnt < $MAX_ROWS)    
   AddCriteriaFormRow($submit, $layer4, $ip_field_cnt, $ip_field[$ip_field_cnt-1][5]);
/*if ( $submit == "ADD IP Option Field"  && $ip_opt_cnt < $MAX_ROWS)      
{  $submit = $layer4;  $ip_opt_cnt++;     }*/
if ( $submit == "ADD TCP Port"         && $tcp_port_cnt < $MAX_ROWS)    
   AddCriteriaFormRow($submit, $layer4, $tcp_port_cnt, $tcp_port[$tcp_port_cnt-1][5]);
if ( $submit == "ADD TCP Field"        && $tcp_field_cnt < $MAX_ROWS)   
   AddCriteriaFormRow($submit, $layer4, $tcp_field_cnt, $tcp_field[$tcp_field_cnt-1][5]);
/*if ( $submit == "ADD TCP Option Field" && $tcp_opt_cnt < $MAX_ROWS)     
{  $submit = $layer4;  $tcp_opt_cnt++;    } */
if ( $submit == "ADD UDP Port"         && $udp_port_cnt < $MAX_ROWS)    
   AddCriteriaFormRow($submit, $layer4, $udp_port_cnt, $udp_port[$udp_port_cnt-1][5]);
if ( $submit == "ADD UDP Field"        && $udp_field_cnt < $MAX_ROWS)
   AddCriteriaFormRow($submit, $layer4, $udp_field_cnt, $udp_field[$udp_field_cnt-1][5]);
if ( $submit == "ADD ICMP Field"       && $icmp_field_cnt < $MAX_ROWS)
   AddCriteriaFormRow($submit, $layer4, $icmp_field_cnt, $icmp_field[$icmp_field_cnt-1][5]);
if ( $submit == "ADD Payload"          && $data_cnt < $MAX_ROWS)
   AddCriteriaFormRow($submit, $layer4, $data_cnt, $data[$data_cnt-1][4]);

/* Dump some debugging information on the shared state */
if ( $debug_mode > 0 )
{
   PrintPageHeader();
   PrintCriteriaState();
}

/* If an action is specified on the query results, it may
 * required the associated SQL to perform its operation.
 * ("Entire Query") operations need this string.
 */
if ( $action != "" )
{
   $tmp_action_sql = ProcessCriteria();
   $action_sql = "SELECT event.sid, event.cid FROM event ".
                 $tmp_action_sql[0]." WHERE ".$tmp_action_sql[1];
}

/* Initialize Alert Actions and run it, if one was selected */

$valid_action = array ("del_alert", "ag_by_id", "ag_by_name", 
                       "email_alert", "email_alert2", 
                       "archive_alert", "archive_alert2");
$valid_action_op = array ("Selected", "ALL on Screen", "Entire Query");

ActOnSelectedAlerts($action, $valid_action, $submit, $valid_action_op, $action_arg,
                             1,
                             $action_chk_lst, $action_lst,
                             $show_rows, $num_result_rows,
                             $action_sql, $caller,
                             $db );

/* a browsing button was clicked */
if ( $num_result_rows >= 0 && is_numeric($submit) )
{
    $current_view = $submit;
    $submit = "Query DB";
}

/* Run the SQL Query and get results */
if ( $submit == "Query DB" || 
     $caller == "last_any" || $caller == "last_tcp" || 
     $caller == "last_udp" || $caller == "last_icmp" ||
     $sort_order != "" )
{
   include("acid_pkt_sqlcalls.php");
}
/* Packet Lookup based on sid/cid */
else if ( strstr($submit, "#") != "" || strstr($caller, "#") != "")
{
   echo '<INPUT TYPE=hidden NAME="action_chk_lst[0]" VALUE="'.$submit.'">';   
   $caller = $submit;
   $save_sql_elements = ProcessCriteria();
   $save_sql = "SELECT event.sid, event.cid FROM event ".
                $save_sql_elements[0]." WHERE ".$save_sql_elements[1];
   PacketLookup( $submit, $db, $save_sql, $mod_snort_config);
}

/* Return the input form to get more criteria from user */
else
{
   include("acid_pkt_form.php");
}

/* Stores the neccessary variables for shared state between calls */

/* These variables will ultimately be stored in the session, but are 
 * temporarily required while criteria is being entered in the form
 */
//if ( ($HTTP_POST_VARS["new"] == 1) || ($HTTP_GET_VARS["new"] == 1) )
if ( $new == 1 )
{ 
   echo '<INPUT TYPE="hidden" NAME="time_cnt" VALUE="'.$time_cnt.'">';
   echo '<INPUT TYPE="hidden" NAME="ip_addr_cnt" VALUE="'.$ip_addr_cnt.'">';
   echo '<INPUT TYPE="hidden" NAME="ip_field_cnt" VALUE="'.$ip_field_cnt.'">';
   echo '<INPUT TYPE="hidden" NAME="tcp_port_cnt" VALUE="'.$tcp_port_cnt.'">';
   echo '<INPUT TYPE="hidden" NAME="tcp_field_cnt" VALUE="'.$tcp_field_cnt.'">';
   echo '<INPUT TYPE="hidden" NAME="udp_port_cnt" VALUE="'.$udp_port_cnt.'">';
   echo '<INPUT TYPE="hidden" NAME="udp_field_cnt" VALUE="'.$udp_field_cnt.'">';
   echo '<INPUT TYPE="hidden" NAME="icmp_field_cnt" VALUE="'.$icmp_field_cnt.'">';
   echo '<INPUT TYPE="hidden" NAME="data_cnt" VALUE="'.$data_cnt.'">';
}

echo '<INPUT TYPE="hidden" NAME="layer4" VALUE="'.$layer4.'">';
echo '<INPUT TYPE="hidden" NAME="num_result_rows" VALUE="'.$num_result_rows.'">';
echo '<INPUT TYPE="hidden" NAME="current_view" VALUE="'.$current_view.'">';
echo '<INPUT TYPE="hidden" NAME="have_meta" VALUE="'.$have_meta.'">';
echo '<INPUT TYPE="hidden" NAME="have_ip" VALUE="'.$have_ip.'">';
echo '<INPUT TYPE="hidden" NAME="have_tcp" VALUE="'.$have_tcp.'">';
echo '<INPUT TYPE="hidden" NAME="have_udp" VALUE="'.$have_udp.'">';
echo '<INPUT TYPE="hidden" NAME="have_icmp" VALUE="'.$have_icmp.'">';
echo '<INPUT TYPE="hidden" NAME="have_data" VALUE="'.$have_data.'">';
echo '<INPUT TYPE="hidden" NAME="caller" VALUE="'.$caller.'">';
echo '<INPUT TYPE="hidden" NAME="sort_order" VALUE="'.$sort_order.'">';
//  $db->acidClose();
?>

</FORM>

<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>

</HTML>





