#ifndef SNDCONFIG_H
#define SNDCONFIG_H

enum cards { 
    ACERNB, AD1816, ADLIB, 
#ifdef kernel_got_fixed
	ALIM15XX,
#endif
	ALS007, ALS100, SGALAXY, CMI8330, 
    CMI8X38, DESKPROXL, CS4232, 
	CS46XX, CS4281, 
	ES1370, ES1371, SOUNDSCAPE,
    SSVIVO, ESS688, ESS1688, ESS1868, ESSMAESTRO, ESSMAESTRO3, ESSSOLO1, GUS,
    GUSMAX, GUSPNP, I810, SMGAMES, AUDIOTRIX, JAZZ16, MOZART, MAD16PRO,
    MIROSOUND, NEOMAGIC, OPL3_SA, OPL3_SAX, PAS16, PSS, SONICVIBES,
    SBORIG, SBPRO, SB16, SB32, SBLIVE, TRIDENT,
    MSND_CLASSIC, MSND_PINNACLE, /* WAVEFRONT, */ VIA82CXXX, WSS,
    YMFPCI,
    AMD7930, CS4231, DBRI, UNSPEC
};

/* buses */
#define isa		1
#define pci		(1<<2)
#define sbus		(1<<3)

/* Card flags... */
#define HAS_OPL3	1
#define HAS_MPU401	(1<<1)
#define SB_AS_LIB	(1<<2)
#define LOAD_CS4232	(1<<3)
#define SM_GAMES	(1<<4)
#define ACER		(1<<5)
#define JOYSTICK	(1<<6)
#define NO_INPUT_REQ	(1<<7)
#define COMPAQ		(1<<8)
#define ACI		(1<<9)
#define NEEDS_SOX	(1<<10)
#define HAS_AWE		(1<<11)
#define SOUNDPRO	(1<<12)
#define IS_ISAPNP	(1<<13)

struct settings {
    enum cards type;
    int irq[10];
    int io[10];
    int dma[10];
    int dma2[10];
    int mpu_io[10];
    int mpu_irq[10];
    int mem[10];
    int	flags;
    char modulename[32];
    char descr[256];
    int messageno;
    int bus;
    int avail;
};

#define CONFFILE "/etc/sysconfig/soundcard"

#endif

