/*
 * This file is part of the sn package.
 * Distribution of sn is covered by the GNU GPL. See file COPYING.
 * Copyright  1998-2000 Harold Tay.
 * Copyright  2000- Patrik Rdman.
 */

#include <sys/param.h>
#include <unistd.h>
#include <sys/stat.h>
#include <errno.h>
#include "format.h"

static const char rcsid[] = "$Id$";
static char buf[MAXPATHLEN + 1];

int statf (struct stat *stp, char *fmt, ...)
{
   va_list ap;

   va_start(ap, fmt);
   if (formatv(buf, sizeof (buf) - 1, fmt, ap) >= sizeof (buf))
   {
      errno = ENAMETOOLONG;
      return (-1);
   }
   return (stat(buf, stp));
}
