/***************************************************************************
    smb4ksharetab.cpp  -  description
                             -------------------
    begin                : Mit Mr 12 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qdir.h>
#include <qregexp.h>
#include <qvaluelist.h>

// KDE includes
#include <klocale.h>
#include <kiconloader.h>

// system includes
#include <cmath>

// application specific includes
#include "smb4ksharetab.h"
#include "../smb4k.h"
#include "../core/smb4kuser.h"

Smb4KShareTab::Smb4KShareTab( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  QGridLayout *grid = new QGridLayout( this );
  grid->setMargin( 30 );

  QLabel *picLabel = new QLabel( this );
  picLabel->setPixmap( DesktopIcon( "hdd_mount", 32 ) );
  picLabel->setFixedWidth( 64 );
  picLabel->setMargin( 5 );

  QLabel *topLabel = new QLabel( i18n( "<font size=+2><b>Share</b></font>" ), this );

  QFrame *line1 = new QFrame( this );
  line1->setFrameShadow( QFrame::Sunken );
  line1->setFrameShape( QFrame::HLine );

  QSpacerItem *spacer1 = new QSpacerItem( 10, 20, QSizePolicy::Preferred, QSizePolicy::Preferred );

  m_shareLabel = new QLabel( QString::null, this );
  m_share = new KSqueezedTextLabel( QString::null, this );

  m_mountpointLabel = new QLabel( QString::null, this );
  m_mountpoint = new KSqueezedTextLabel( QString::null, this );
  
  m_userLabel = new QLabel( QString::null, this );
  m_user = new KSqueezedTextLabel( QString::null, this );
  
  m_groupLabel = new QLabel( QString::null, this );
  m_group = new KSqueezedTextLabel( QString::null, this );

  QSpacerItem *spacer2 = new QSpacerItem( 10, 20, QSizePolicy::Preferred, QSizePolicy::Preferred );

  m_totalLabel = new QLabel( QString::null, this );
  m_total = new KSqueezedTextLabel( QString::null, this );
  
  m_freeLabel = new QLabel( QString::null, this );
  m_free = new KSqueezedTextLabel( QString::null, this );
  
  m_usedLabel = new QLabel( QString::null, this );
  m_used = new KSqueezedTextLabel( QString::null, this );

  QSpacerItem *spacer3 = new QSpacerItem( 10, 20, QSizePolicy::Preferred, QSizePolicy::Preferred );

  m_usageLabel = new QLabel( QString::null, this );
  m_usage = new KProgress( 100, this );
  m_usage->setMaximumWidth( 100 );
  m_usage->setTextEnabled( true );

  m_contentsLabel = new QLabel( QString::null, this );
  m_contents = new KSqueezedTextLabel( QString::null, this );
  
  QSpacerItem *spacer4 = new QSpacerItem( 10, 10, QSizePolicy::Expanding, QSizePolicy::Expanding );

  grid->addMultiCellWidget( picLabel, 0, 1, 0, 0, 0 );
  grid->addMultiCellWidget( topLabel, 0, 1, 1, 4, 0 );
  grid->addMultiCellWidget( line1, 2, 2, 0, 4, 0 );
  grid->addMultiCell( spacer1, 3, 3, 0, 4, 0 );
  grid->addWidget( m_shareLabel, 4, 1, 0 );
  grid->addMultiCellWidget( m_share, 4, 4, 2, 4, 0 );
  grid->addWidget( m_mountpointLabel, 5, 1, 0 );
  grid->addMultiCellWidget( m_mountpoint, 5, 5, 2, 4, 0 );
  grid->addWidget( m_userLabel, 6, 1, 0 );
  grid->addMultiCellWidget( m_user, 6, 6, 2, 4, 0 );
  grid->addWidget( m_groupLabel, 7, 1, 0 );
  grid->addMultiCellWidget( m_group, 7, 7, 2, 4, 0 );
  grid->addMultiCell( spacer2, 8, 8, 0, 4, 0 );
  grid->addWidget( m_usageLabel, 9, 1, 0 );
  grid->addMultiCellWidget( m_usage, 9, 9, 2, 4, 0 );
  grid->addMultiCell( spacer3, 10, 10, 0, 4 );
  grid->addWidget( m_totalLabel, 11, 1, 0 );
  grid->addMultiCellWidget( m_total, 11, 11, 2, 4, 0 );
  grid->addWidget( m_freeLabel, 12, 1, 0 );
  grid->addMultiCellWidget( m_free, 12, 12, 2, 4, 0 );
  grid->addWidget( m_usedLabel, 13, 1, 0 );
  grid->addMultiCellWidget( m_used, 13, 13, 2, 4, 0 );
  grid->addWidget( m_contentsLabel, 14, 1, 0 );
  grid->addMultiCellWidget( m_contents, 14, 14, 2, 4, 0 );
  grid->addMultiCell( spacer4, 15, 15, 0, 4, 0 );
  
  connect( sapp->core(), SIGNAL( usage( const QString &, double, double, double, double, int, int ) ), 
                   this, SLOT( slotUsage( const QString &, double, double, double, double, int, int ) ) );
}


Smb4KShareTab::~Smb4KShareTab()
{
}


void Smb4KShareTab::clear()
{
  m_shareLabel->setText( QString::null );
  m_share->setText( QString::null );
  m_mountpointLabel->setText( QString::null );
  m_mountpoint->setText( QString::null );
  m_userLabel->setText( QString::null );
  m_user->setText( QString::null );
  m_groupLabel->setText( QString::null );
  m_group->setText( QString::null );
  m_totalLabel->setText( QString::null );
  m_total->setText( QString::null );
  m_freeLabel->setText( QString::null );
  m_free->setText( QString::null );
  m_usedLabel->setText( QString::null );
  m_used->setText( QString::null );
  m_usageLabel->setText( QString::null );
  m_usage->hide();
  m_contentsLabel->setText( QString::null );
  m_contents->setText( QString::null );
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KShareTab::slotUsage( const QString &mountpoint, double total, double used, double free, double percent, int dirs, int files )
{
  Smb4KShare *share = sapp->core()->mounter()->findShareByPath( mountpoint );
  
  if ( share && !share->isBroken() )
  {
    // Show all labels at once.
    m_shareLabel->setText( i18n( "Share:" ) );
    m_mountpointLabel->setText( i18n( "Mount Point:" ) );
    m_userLabel->setText( i18n( "User:" ) );
    
    if ( share->getFilesystem() == "smbfs" )
    {
      m_groupLabel->setText( i18n( "Group:" ) );
      m_user->setText( QString( "%1   (%2)" ).arg( share->getUser() ).arg( share->getUID() ) );
      m_group->setText( QString( "%1   (%2)" ).arg( share->getGroup() ).arg( share->getGID() ) );
    }
    else
    {
      m_groupLabel->setText( QString::null );
      m_user->setText( QString( "%1" ).arg( share->getCIFSLogin() ) );
      m_group->setText( QString::null );
    }
    
    m_usageLabel->setText( i18n( "Usage:" ) );
    m_totalLabel->setText( i18n( "Total:" ) );
    m_freeLabel->setText( i18n( "Free:" ) );
    m_usedLabel->setText( i18n( "Used:" ) );
    m_contentsLabel->setText( i18n( "Contents:" ) );
    
    m_share->setText( share->getName() );
    m_mountpoint->setText( share->getPath() );

    double integer;        
    double fractional = modf( percent, &integer );
    
    if ( fractional > 0.5 )
    {
      integer += 1;
    }
    
    m_usage->setProgress( (int)integer );
      
    if ( !m_usage->isShown() )
    {
      m_usage->show();
    }
        
    double temp;
    QString dim;
      
    if ( total > 1023 )
    {
      temp = total / 1024;   // MB
      dim = " MB";
        
      if ( temp > 1023 )
      {
        temp = temp / 1024;               // GB
        dim = " GB";
      }
    }
    else
    {
      temp = total;
      dim = " KB";
    }
    m_total->setText( QString( "%1" ).arg( temp, 0, 'f', 2 ). append( dim ).stripWhiteSpace() );
      
    if ( free > 1023 )
    {
      temp = free / 1024;   // MB
      dim = " MB";
        
      if ( temp > 1023 )
      {
        temp = temp / 1024;               // GB
        dim = " GB";
      }
    }
    else
    {
      temp = free;
      dim = " KB";
    }
    m_free->setText( QString( "%1" ).arg( temp, 0, 'f', 2 ).append( dim ).stripWhiteSpace() );  
        
    if ( used > 1023 )
    {
      temp = used / 1024;   // MB
      dim = " MB";
      if ( temp > 1023 )
      {
        temp = temp / 1024;               // GB
        dim = " GB";
      }
    }
    else
    {
      temp = used;
      dim = " KB";
    }
    m_used->setText( QString( "%1" ).arg( temp, 0, 'f', 2 ).append( dim ).stripWhiteSpace() );
      
    // FIXME: This may be solved smarter.
    
    QString part1, part2, part3, output;
    
    if ( dirs+files == 1 )
    {
      part1 = QString( i18n( "%1 Item   " ) ).arg( dirs+files );
    }
    else
    {
      part1 = QString( i18n( "%1 Items   " ) ).arg( dirs+files );
    }
    
    if ( dirs == 1 )
    {
      part2 = QString( i18n( "(%1 Directory, " ) ).arg( dirs );
    }
    else
    {
      part2 = QString( i18n( "(%1 Directories, " ) ).arg( dirs );
    }
    
    if ( files == 1 )
    {
      part3 = QString( i18n( "%1 File)" ) ).arg( files );
    }
    else
    {
      part3 = QString( i18n( "%1 Files)" ) ).arg( files );
    }
   
    output.append( part1 ).append( part2 ).append( part3 );

    m_contents->setText( output );
  }
  else
  {
    clear();
  }
}


#include "smb4ksharetab.moc"
