/***************************************************************************
                          smb4kmountdialog  -  description
                             -------------------
    begin                : Mo Nov 29 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h> 

// KDE includes
#include <klocale.h>
#include <kmessagebox.h>
 
// application specific includes
#include "smb4kmountdialog.h"
#include "../core/smb4kmounter.h"
#include "../core/smb4kbookmarkhandler.h"
#include "../core/smb4kbookmark.h"
#include "../smb4k.h"

Smb4KMountDialog::Smb4KMountDialog( QWidget *parent, const char *name ) :
KDialogBase( Plain, i18n( "Mount Share" ), Ok|Cancel, Ok, parent, name, false, true )
{
  setWFlags( Qt::WDestructiveClose );

  setupView();
}


Smb4KMountDialog::~Smb4KMountDialog()
{
}


void Smb4KMountDialog::setupView()
{
  QFrame *frame = plainPage();
  QGridLayout *layout = new QGridLayout( frame );
  
  QGroupBox *input_box = new QGroupBox( 2, Qt::Horizontal, i18n( "Input" ), frame, "InputBox" );
  new QLabel( i18n( "Share:" ), input_box );
  m_share_input = new KLineEdit( input_box, "ShareInputLine" );
  m_share_input->setMinimumWidth( 200 );
  m_share_input->setFocus();
  new QLabel( i18n( "IP Address:" ), input_box );
  m_ip_input = new KLineEdit( input_box, "IPInputLine" );
  m_ip_input->setMinimumWidth( 200 );
  new QLabel( i18n( "Workgroup:" ), input_box );
  m_workgroup_input = new KLineEdit( input_box, "WorkgroupInputLine" );
  m_workgroup_input->setMinimumWidth( 200 );
  
  QGroupBox *bookmark_box = new QGroupBox( 1, Qt::Horizontal, i18n( "Bookmark" ), frame, "BookmarkBox" );
  m_bookmark = new QCheckBox( i18n( "Add this share to the bookmarks." ), bookmark_box, "BookmarkButton" );
  
  layout->addWidget( input_box, 0, 0, 0 );
  layout->addWidget( bookmark_box, 1, 0, 0 );
}

/////////////////////////////////////////////////////////////////////////////
//  SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KMountDialog::slotOk()
{
  if ( !m_share_input->text().stripWhiteSpace().isEmpty() )
  {
#ifndef __FreeBSD__
    if ( m_share_input->text().contains( "/" ) == 3 )
#else
    if ( m_share_input->text().contains( "/" ) == 3
         && m_share_input->text().contains( '@' ) == 0 )
#endif
    {
      QString host = m_share_input->text().stripWhiteSpace().section( "/", 2, 2 ).section( "/", 0, 0 );
      QString share = m_share_input->text().stripWhiteSpace().section( "/", 3, 3 );
      QString ip = m_ip_input->text().stripWhiteSpace();
      QString workgroup = m_workgroup_input->text().stripWhiteSpace();
      
      sapp->core()->mounter()->mountShare( workgroup, host, ip, share );
      
      if ( m_bookmark->isChecked() )
      {
        sapp->core()->bookmarkHandler()->addBookmark( new Smb4KBookmark( m_share_input->text().stripWhiteSpace(), QString::null ) );
      }
      
      accept();
    }
    else
    {
      KMessageBox::error( this, i18n( "The input of the share is wrong. It must have the form //HOST/SHARE." ) );
    }
  }
}
