/***************************************************************************
    smb4kbookmarkmenuwidget.h  - A bookmark popup menu.
                             -------------------
    begin                : Feb 04 2004
    copyright            : (C) 2004 by Franck Babin
                           (C) 2004 by Alexander Reinholdt
    email                : babinfranck@yahoo.ca
                           dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef SMB4KBOOKMARKMENUWIDGET_H
#define SMB4KBOOKMARKMENUWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <kaction.h>
#include <kactionclasses.h>

class Smb4KBookmarkMenuWidget : public KActionMenu
{
  Q_OBJECT
  
  public:
    /**
     * The constructor.
     */
    Smb4KBookmarkMenuWidget( int display_mode, QObject *parent= 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KBookmarkMenuWidget();
    /**
     * This enumeration is for determing the display mode.
     */
    enum Mode{ Tray, Normal };
    
  protected slots:
    /**
     * This slot is activated when the list of shares has been updated.
     * It reads that list and enables/disables the bookmarks accordingly.
     */
    void slotUpdatedShareList();
    /**
     * This slot is activated if an item in the menu has been activated.
     * @param id The id of the activated item.
     */
    void slotActivated( int id );
    /**
     * This slot is activated if the list of bookmarks has been updated.
     */
    void slotBookmarksUpdated();
  
  private:
    /**
     * Initializes the actions.
     */
    void initActions();
    /**
     * Inserts the bookmarks.
     */
    void insertBookmarks();
    /**
     * Holds the diaplay mode.
     */
    int m_display_mode;
};

#endif
