/***************************************************************************
    smb4kprintinfo  -  This is a container that carries information needed
    for printing.
                             -------------------
    begin                : Mo Apr 19 2004
    copyright            : (C) 2004-2008 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <QHostAddress>

// application specific includes
#include <smb4kprintinfo.h>


Smb4KPrintInfo::Smb4KPrintInfo( Smb4KShare *share )
: m_share( *share ), m_path( QString() ), m_copies( 0 )
{
}


Smb4KPrintInfo::Smb4KPrintInfo( const Smb4KPrintInfo &info )
: m_share( *info.shareItem() ), m_path( info.path() ), m_copies( info.copies() )
{
}


Smb4KPrintInfo::~Smb4KPrintInfo()
{
}


void Smb4KPrintInfo::setShareItem( Smb4KShare *share )
{
  m_share = *share;
}


void Smb4KPrintInfo::setPath( const QString &path )
{
  m_path = path;
}


void Smb4KPrintInfo::setCopies( int num )
{
  m_copies = num;
}

