/*
    This file is part of the sly ident daemon (slidentd).
   slidentd was written by Sean Hunter <sean@uncarved.com> as a minimal
    RFC1413 (ident) daemon.

   slidentd is copyright (c) 2001 Uncarved Systems Ltd.

   slidentd is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

   slidentd is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along withslidentd; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef SLIDENTD_DATESTAMP_H
#define SLIDENTD_DATESTAMP_H
#include <stralloc.h>
#include <buffer.h>

#define SLID_DATESTAMP_LEN 29

/* create an ISO-8601 datestamp in UTC.  stralloc must be destroyed by caller */
void slid_get_datestamp(stralloc * buffer);
void slid_put_datestamp(buffer * buffer);

#endif
