/*
  A symbol table.
  Copyright (C) 2005 The MITRE Corporation

  Author: John D. Ramsdell

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

#if !defined INTERN_H
#define INTERN_H

#ifdef __cplusplus
extern "C"
{
#endif

/* To use the symbol table, you must implement the symbol interface.  */

/* Initializes the symbol table */
void intern_init(void);
/* Free all space used by the symbol table */
void intern_free(void);
/* Find the symbol associated with a name or create it if it is
   missing.  */
symbol_t intern(const char *);

#ifdef __cplusplus
}
#endif

#endif
