/* # skkinput (Simple Kana-Kanji Input)
 * skkldic.c --- search/create/update local dictionary.
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <X11/Intrinsic.h>

#include "commondef.h"
#include "buffers.h"
#include "config.h"

/*
 * ޥ
 */
#define SafeFree(ptr)	do{ if( (ptr) != NULL ) free((ptr)) ; } while(0)

/*
 * ؿΥץȥ
 */
int check_skkinput_jisyo_code( unsigned char *path ) ;
static int skkinput_copyFile( unsigned char *from, unsigned char *to ) ;

/*
 * ؿΥץȥ
 */
extern SkkinpSearchVector *add_SkkinpSearchVector
( SkkinpSearchVector *topp,   struct myChar *str,
  SkkinpSearchVector **rnode, int *rpos ) ;
extern SkkinpSearchVector *searchSudeniHenkanKakuteiShitamono
( struct myChar *henkankey, SkkinpSearchVector *top, int okuri ) ;
extern VectorIndex *makeSearchVectorIndex
( SkkinpSearchVector *top, int *totalnum, int flag ) ;
extern void free_SkkinpSearchVector( SkkinpSearchVector **top ) ;
extern void free_VectorIndex( VectorIndex **top ) ;
/* skkldrec.c */
extern unsigned long recentlyHenkanKakuteiKouhoWoFileNiKaku
( FILE *fp, FILE *motoJisyoFp, int okuri ) ;
extern void clearHenkanKakuteiHash( void ) ;
extern SkkinpSearchVector *searchSudeniPurgeSaretamono
( struct myChar *henkankey, SkkinpSearchVector *top, int okuri ) ;
extern void skkinputNoNaibuNoKouhoWoFileNiKaku
( FILE *fp, int okuri, int purge ) ;
extern void skkinputAutoSaveFileWoYondeFukugenSuru( FILE *fp ) ;
/* parseStr.c */
unsigned char *expand_file_name( unsigned char *path ) ;

/*
 * Хѿ
 */
/* skkinput Ѥɽ꼭Υѥ*/
static unsigned char	*skkinput_local_jisyo_path ;
static unsigned char	*skkinput_autosave_path ;
/* local-jisyo θΥѡߥå*/
static mode_t		skkinput_local_jisyo_mode ;
/* skkinput Ѥɽ꼭ΥХååפΥѥ*/
static unsigned char	*skkinput_jisyo_backup_path ;
/* skk Ѥɽ꼭Υѥ*/
static unsigned char	*skk_local_jisyo_path ;
/* skkinput record Υѥ*/
static unsigned char	*skkinput_record_path ;
static unsigned char	*skkinput_record_path_tmp ;
/* skkinput Ѥɽ꼭δɡ*/
static int		skkinput_local_jisyo_coding_system ;
/* skkinput Ѥɽ꼭 backup δɡ*/
static int		skkinput_jisyo_backup_coding_system ;
/* ~/.skk-jisyo Ѥɽ꼭δɡ*/
static int		skk_local_jisyo_coding_system ;
/* 񤬱Ƥ뤫ɤġ*/
extern Boolean		skkinput_jisyo_dirty ;
extern Boolean		skkinput_autosave_jisyo_dirty ;

/* skk-local-jisyo õ뤫ɤ*/
extern int		skkinput_search_skk_jisyo ;
/* skkinput-record 뤫ɤ*/
extern int		skkinput_keep_record ;

extern unsigned long	skkinput_j_count_kakutei ;
extern unsigned long	skkinput_j_count_touroku ;

/*
 * ɽ꼭˴ؤԤؿ
 */
int set_localjisyo
( unsigned char *jisyo_path,  unsigned char *jisyobak_path,
  unsigned char *record_path, unsigned char *master_localjisyo )
{
  struct stat local_jisyo_buf ;

  /* ΤʥѥĴ٤롣*/
  skkinput_local_jisyo_path  = expand_file_name( jisyo_path ) ;
  skkinput_jisyo_backup_path = expand_file_name( jisyobak_path ) ;
  skkinput_record_path       = expand_file_name( record_path ) ;
  skk_local_jisyo_path       = expand_file_name( master_localjisyo ) ;
  /* record ¤Ӥդ֥ե뤬ɬפˤʤ롣*/
  skkinput_record_path_tmp   =
    malloc( strlen( skkinput_record_path ) + 2 ) ;
  if( skkinput_record_path_tmp != NULL ){
    strcpy( skkinput_record_path_tmp, skkinput_record_path ) ;
    strcat( skkinput_record_path_tmp, "~" ) ;
  }
  if( ( skkinput_autosave_path = malloc
	( strlen( skkinput_local_jisyo_path ) + 10 ) ) != NULL ){
    strcpy( skkinput_autosave_path, skkinput_local_jisyo_path ) ;
    strcat( skkinput_autosave_path, "-autosave" ) ;
  }
  /* coding system å롣*/
  skkinput_local_jisyo_coding_system =
    check_skkinput_jisyo_code( skkinput_local_jisyo_path ) ;
  skkinput_jisyo_backup_coding_system =
    check_skkinput_jisyo_code( skkinput_jisyo_backup_path ) ;
  skk_local_jisyo_coding_system =
    check_skkinput_jisyo_code( skk_local_jisyo_path ) ;
  
  /* skkinput-local-jisyo ΥѡߥåĴ٤롣*/
  if( stat( skkinput_local_jisyo_path, &local_jisyo_buf ) ){
    /* ޤumask 롣 umask  000 Ǥ롣*/
    skkinput_local_jisyo_mode = umask( 0 ) ;
    /*  umask ᤹*/
    umask( skkinput_local_jisyo_mode ) ;
    /* umask 򤫤ĤΥ⡼ɤ롣*/
    skkinput_local_jisyo_mode = 
      ( S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH ) &
      ( ~( skkinput_local_jisyo_mode ) ) ;
  } else {
    /* ȤäѡߥåѾ롣*/
    skkinput_local_jisyo_mode = local_jisyo_buf.st_mode ;
  }
  skkinput_j_count_touroku = 0 ;
  skkinput_j_count_kakutei = 0 ;
  return 0 ;
}

/*
 * ɽ꼭Τ˳ݤƤؿ
 */
int close_localjisyo( void )
{
  SafeFree( skkinput_local_jisyo_path ) ;
  SafeFree( skkinput_jisyo_backup_path ) ;
  SafeFree( skkinput_record_path ) ;
  SafeFree( skkinput_record_path_tmp ) ;
  SafeFree( skkinput_autosave_path ) ;
  SafeFree( skk_local_jisyo_path ) ;
  return 0 ;
}

/*
 * "["  "\0" ȸ򴹤ؿ
 */
static int replace_kakkoToNul( struct myChar *string )
{
  while( !IS_END_OF_STRING( *string ) ){
    if( IS_ASCII_EQUAL( *string, '[' ) ){
      MYCHAR_SET_END_OF_STRING( *string ) ;
      return True ;
    }
    string ++ ;
  }
  return False ;
}

/*
 * ʸо줹ޤǡեɤФؿ
 */
int skip_file_until( FILE *fp, unsigned char *string, int coding_system )
{
  struct myChar *oneline = NULL ;

  while( !feof( fp ) ){
    oneline = mychar_readOneLine( fp, coding_system ) ;
    if( oneline == NULL )
      return False ;
    if( !myCharCharStrcmp( oneline, string ) ){
      free( oneline ) ;
      return True ;
    }
    free( oneline ) ;
  }
  return False ;
}

static SkkinpSearchVector *j_okurinasi_search_skkinput_jisyo
( FILE *jisyoFp, struct myChar *key,
  SkkinpSearchVector *top, int coding_system )
{
  int status = 0, kflag, klen, found ;
  struct myChar *oneline = NULL ;

  /* Ƭޤ᤹ȤȤ롣*/
  rewind( jisyoFp ) ;
  /* 겾̾γϰ֤ޤ֡*/
  skip_file_until( jisyoFp, ";; okuri-nasi entries.", coding_system ) ;

  /* ĹƤ strncmp Τɬס*/
  klen = myCharStrlen( key ) ;
  found = False ;

  /* եƬ˸Ƥ*/
  while( !feof( jisyoFp ) ){
    /* ʸɤ򸫤ơ EUC ؤѴ롣*/
    if( ( oneline = mychar_readOneLine( jisyoFp, coding_system ) ) == NULL )
      break ;	/*  continue ǤϤʤΤ */
    /* ȤιԤäˤϡԤޤɤФ*/
    if( IS_ASCII_EQUAL( *oneline, ';' ) ||
	myCharStrncmp( oneline, key, klen ) || 
	!IS_ASCII_EQUAL( oneline[ klen ], ' ' ) ){
      /* 겾̾ˤʤäƤޤä齪λ롣*/
      if( !myCharCharStrcmp( oneline, ";; okuri-ari entries." ) ){
	/* ޤ malloc ʸ롣*/
	free( oneline ) ;
	oneline = NULL ;
	/* ޤ뤫⤷ʤȥõġ*/
	if( !skip_file_until
	    ( jisyoFp, ";; okuri-nasi entries.", coding_system ) )
	  break ;
      } else {
	/* ޤ malloc ʸ롣*/
	free( oneline ) ;
	oneline = NULL ;
      }
      status = 0 ;
      kflag = False ;
    } else {
      /* Ƥʸ󤬸դäν*/
      found = True ;
      break ;
    }
  }
  /* դʤäˤϡNULL ֤*/
  if( !found || oneline == NULL ){
    return top ;
  }
  /* դäνɤ߹ʸˤäƤϰԤɤ *
   * Ƥʤǽ⤢롣ա*/
  top = add_SkkinpSearchVector
    ( top, oneline + klen + 1, NULL, NULL ) ;
  free( oneline ) ;
  return top ;
}


/*
 * 겾̵̾ζɽ꼭θԤؿ
 */
static SkkinpSearchVector *j_okurinasi_search_skkinput_jisyo_with_path
( unsigned char *jisyo_path, struct myChar *key,
  SkkinpSearchVector *top, int coding_system )
{
  FILE *fp ;
  /* ޤ񤬳ʤСäˤʤʤ*/
  if( ( fp = fopen( jisyo_path, "rb" ) ) == NULL )
    return top ;
  top = j_okurinasi_search_skkinput_jisyo
    ( fp, key, top, coding_system ) ;
  fclose( fp ) ;
  return top ;
}

/*
 * 겾̾ζɽ꼭θԤؿ
 */
static SkkinpSearchVector *j_okuriari_search_skkinput_jisyo
( FILE *jisyoFp, struct myChar *key,
  SkkinpSearchVector *top, int coding_system )
{
  int status = 0, kflag, klen, found ;
  struct myChar *oneline = NULL ;

  /* ĹƤ strncmp Τɬס*/
  klen = myCharStrlen( key ) ;
  found = False ;

  rewind( jisyoFp ) ;
  /* 겾̾γϰ֤ޤ֡*/
  skip_file_until( jisyoFp, ";; okuri-ari entries.", coding_system ) ;

  /* եƬ˸Ƥ*/
  while( !feof( jisyoFp ) ){
    /* ʸɤ򸫤ơ EUC ؤѴ롣*/
    if( ( oneline = mychar_readOneLine
	  ( jisyoFp, coding_system ) ) == NULL )
      break ;	/*  continue ǤϤʤΤ */

    /* ȤιԤäˤϡԤޤɤФ*/
    if( IS_ASCII_EQUAL( *oneline, ';' ) ||
	myCharStrncmp( oneline, key, klen ) ||
	!IS_ASCII_EQUAL( oneline[ klen ], ' ' ) ){
      /* 겾̵̾ˤʤäƤޤä齪λ롣*/
      if( !myCharCharStrcmp( oneline, ";; okuri-nasi entries." ) ){
	free( oneline ) ;
	oneline = NULL ;
	/* ޤ뤫⤷ʤȥõġ*/
	if( !skip_file_until
	    ( jisyoFp, ";; okuri-ari entries.", coding_system ) )
	  break ;
      } else {
	free( oneline ) ;
	oneline = NULL ;
      }
      status = 0 ;
      kflag = False ;
    } else {
      /* Ƥʸ󤬸դäν*/
      found = True ;
      break ;
    }
  }
  /* դʤäˤϡNULL ֤*/
  if( !found || oneline == NULL ){
    return top ;
  }

  /* ľѴˤϴط̵ "/[/]/" ʬõ롣*/
  replace_kakkoToNul( oneline ) ;
  top = add_SkkinpSearchVector( top, oneline + klen + 1, NULL, NULL ) ;
  free( oneline ) ;
  return top ;
}

/*
 * 겾̾ζɽ꼭θԤؿ
 */
static SkkinpSearchVector *j_okuriari_search_skkinput_jisyo_with_path
( unsigned char *jisyo_path, struct myChar *key,
  SkkinpSearchVector *top, int coding_system )
{
  FILE *fp ;

  /* ޤ񤬳ʤСäˤʤʤ*/
  if( ( fp = fopen( jisyo_path, "rb" ) ) == NULL )
    return top ;
  top = j_okuriari_search_skkinput_jisyo
    ( fp, key, top, coding_system ) ;
  fclose( fp ) ;
  return top ;
}

/*
 * ɽ꼭θԤؿ
 */
SkkinpSearchVector *j_search_skkinput_local_jisyo
( struct myChar *key, SkkinpSearchVector *top, int okuri )
{
  if( okuri ){
    /* ɽ꼭񤫤õޤ礦ġ*/
    top = j_okuriari_search_skkinput_jisyo_with_path
      ( skkinput_local_jisyo_path, key, top,
	skkinput_local_jisyo_coding_system ) ;
    /* .skk-jisyo 򸫤ΤߤʤΡ */
    if( skkinput_search_skk_jisyo )
      top = j_okuriari_search_skkinput_jisyo_with_path
	( skk_local_jisyo_path, key, top,
	  skk_local_jisyo_coding_system ) ;
  } else {
    /* ɽ꼭񤫤õޤ礦ġ*/
    top = j_okurinasi_search_skkinput_jisyo_with_path
      ( skkinput_local_jisyo_path, key, top,
	skkinput_local_jisyo_coding_system ) ;
    /* .skk-jisyo 򸫤ΤߤʤΡ */
    if( skkinput_search_skk_jisyo )
      top = j_okurinasi_search_skkinput_jisyo_with_path
	( skk_local_jisyo_path, key, top,
	  skk_local_jisyo_coding_system ) ;
  }
  return top ;
}

/*
 * ɽ꼭backup鸡Ԥؿ
 */
SkkinpSearchVector *j_search_skkinput_jisyo_with_fileptr
( struct myChar *key, SkkinpSearchVector *top, int okuri, FILE *fp )
{
  if( okuri ){
    /* ɽ꼭񤫤õޤ礦ġ*/
    return j_okuriari_search_skkinput_jisyo
      ( fp, key, top, skkinput_local_jisyo_coding_system ) ;
  } else {
    /* ɽ꼭񤫤õޤ礦ġ*/
    return j_okurinasi_search_skkinput_jisyo
      ( fp, key, top, skkinput_local_jisyo_coding_system ) ;
  }
}

/*
 * ɽ꼭 completion Ԥؿ
 */
static SkkinpSearchVector *j_completion_skkinput_local_jisyo_sub
( unsigned char *jisyo_path, struct myChar *key,
  SkkinpSearchVector *top,  int coding_system )
{
  FILE *fp ;
  int status = 0, kflag, klen, found ;
  struct myChar *oneline, *ptr ;
  static struct myChar kouhoNoSeparator[] = {
    { CHARSET_ASCII, '/' }, { CHARSET_ASCII, '\0' },
  } ;

  /* ޤ񤬳ʤСäˤʤʤ*/
  if( ( fp = fopen( jisyo_path, "rb" ) ) == NULL )
    return top ;

  /* 겾̾γϰ֤ޤ֡*/
  skip_file_until( fp, ";; okuri-nasi entries.", coding_system ) ;
  
  /* ĹƤ strncmp Τɬס*/
  klen = myCharStrlen( key ) ;
  found = False ;

  /* եƬ˸Ƥ*/
  while( !feof( fp ) ){
    if( ( oneline = mychar_readOneLine( fp, coding_system ) ) == NULL )
      break ;
    /* ȤιԤäˤϡԤޤɤФ*/
    if( IS_ASCII_EQUAL( *oneline, ';' ) || 
	myCharStrncmp( oneline, key, klen ) ){
      /* 겾̾ˤʤäƤޤä齪λ롣*/
      if( !myCharCharStrcmp( oneline, ";; okuri-ari entries." ) ){
	free( oneline ) ;
	oneline = NULL ;
	/* ޤ뤫⤷ʤȥõġ*/
	if( !skip_file_until
	    ( fp, ";; okuri-nasi entries.", coding_system ) )
	  break ;
      } else {
	free( oneline ) ;
	oneline = NULL ;
      }
      status = 0 ;
      kflag = False ;
    } else {
      /* Ƥʸ󤬸դäν*/
      if( !found ){
	/* Ƭ '/' Ƥ*/
	top = add_SkkinpSearchVector
	  ( top, kouhoNoSeparator, NULL, NULL ) ;
	found = True ;
      }
      /* ڡäƤƤ̣Τǡޤ*/
      ptr = oneline ;
      while( !IS_ASCII_EQUAL( *ptr, ' ' ) && !IS_END_OF_STRING( *ptr ) )
	ptr ++ ;
      MYCHAR_SET_END_OF_STRING( *ptr ) ;
      /* Ͽޤ*/
      top = add_SkkinpSearchVector
	( top, oneline, NULL, NULL ) ;
      top = add_SkkinpSearchVector
	( top, kouhoNoSeparator, NULL, NULL ) ;
      free( oneline ) ;
      oneline = NULL ;
    }
  }
  fclose( fp ) ;
  return top ;
}

/*
 * completion search ɽ꼭ФƤؿ
 */
SkkinpSearchVector *j_completion_skkinput_local_jisyo
( SkkinpSearchVector *top, struct myChar *completion_key )
{
  top = j_completion_skkinput_local_jisyo_sub
    ( skkinput_local_jisyo_path, completion_key, top,
      skkinput_local_jisyo_coding_system ) ;
  /* .skk-jisyo 򸫤ΤߤʤΡ */
  if( skkinput_search_skk_jisyo )
    top = j_completion_skkinput_local_jisyo_sub
      ( skk_local_jisyo_path, completion_key, top,
	skk_local_jisyo_coding_system ) ;
  return top ;
}

/*
 * եįơESC äƤ JIS8bit ܤΩäƤ륳
 * äƤ EUC ȤȽǤ뤫ʤŬʴؿ
 *----
 * skkinput-jisyo Ѥʴɤʤ褦ˡġ
 */
int check_skkinput_jisyo_code( unsigned char *path )
{
  FILE *fp ;
  int ret = KANJI_CODE_UNKNOWN, flag8bit = False ;
  unsigned char buffer[ TEXTBUFSIZE ] ;

  /* ե뤬¸ߤʤˤϡǾcoding system *
   * 򤹤롣*/
  if( ( fp = fopen( path, "rb" ) ) == NULL ){
    return CODING_SYSTEM_IS_EUC ;
  }
  while( !feof( fp ) ){
    fgets( buffer, TEXTMAXLEN, fp ) ;
    buffer[ TEXTMAXLEN ] = '\0' ;
    ret = check_kanjiCode( buffer, strlen( buffer ) ) ;
    /* ⤷ 8bit ܤΩäƤȽԲǽǤä硣*/
    if( ret == KANJI_CODE_EUC_SJIS_UNKNOWN ){
      flag8bit = True ;
      continue ;
    }
    /* ΥɤȽ̲ǽä硣*/
    if( ret != KANJI_CODE_UNKNOWN )
      break ;
  }
  if( ret == KANJI_CODE_EUC_SJIS_UNKNOWN ){
    ret = KANJI_CODE_EUC ;
  } else if( ret == KANJI_CODE_UNKNOWN ){
    ret = ( flag8bit )? KANJI_CODE_EUC : KANJI_CODE_JIS ;
  }
  fclose( fp ) ;
  return ret ;
}

/*
 * VectorIndexList ˤҤüեؤžؿ
 */
void writeVectorIndexToFile( FILE *fp, VectorIndex *vNode )
{
  int len ;
  SkkinpSearchVector *sNode ;
  struct myChar *ptr ;

  /* ޤǽ "/" ɽ롣*/
  fputc( '/', fp ) ;
#ifdef DEBUG
  printf( "%c", 0x2f ) ;
#endif

  /* ʲ򤿤ɤ롣*/
  while( vNode != NULL ){
    sNode = vNode->node ;
    ptr   = sNode->text + vNode->position ;
    len   = vNode->length ;
    while( len > 0 ){
      if( IS_END_OF_STRING( *ptr ) ){
	sNode = sNode->next ;
	/* ޤ̵ȤϡԳФä㤢ʤ롼פȴ *
	 * 褫*/
	if( sNode == NULL ){
#ifdef DEBUG
	  fprintf( stderr, "I lost next skkinput-search-vector!\n" ) ;
#endif
	  fputc( '\n', fp ) ;
	  return ;
	}
	ptr = sNode->text ;
      }
#ifdef DEBUG
      myCharFputEUCc( *ptr, stdout ) ;
#endif
      myCharFputEUCc( *ptr ++, fp ) ;
      len -- ;
    }
#ifdef DEBUG
    printf( "%c", 0x2f ) ;
#endif
    fputc( 0x2f, fp ) ;
    vNode = vNode->next ;
  }
#ifdef DEBUG
  printf( "\n" ) ;
#endif
  fputc( '\n', fp ) ;
  return ;
}

/*
 * Ѵη̤񤭽Фؿ
 *-----
 * int okuri  char *daimoku ˤäꤢȤʤζ̤ĤƤޤ
 */
static unsigned long skkinput_updateHenkanResult
( FILE *fpSrc, FILE *fpDest, int okuri,
  unsigned char *daimoku, int coding_system )
{
  SkkinpSearchVector *top, *purgeTop ;
  VectorIndex *vTop, *vTopPurge ;
  int len ;
  unsigned long count = 0 ;
  struct myChar *search_key = NULL, *ptr ;

  /* ޤܤ򾧤롣󥫥ޥ參*/
  fprintf( fpDest, "%s\n", daimoku ) ;
  fflush( fpDest ) ;
  count ++ ;

  /* ˴ϿƤѴ¤٤򤹤롣*/
  count += recentlyHenkanKakuteiKouhoWoFileNiKaku
    ( fpDest, fpSrc, okuri ) ;

  /* ͤˤե뤬̵ä顢ʲν̵롪 ɬ *
   * Ϥʤ */
  if( fpSrc == NULL )
    return count ;

  /* եƬޤᤷƤ*/
  rewind( fpSrc ) ;

  /* 겾̾γϰ֤ޤ֡*/
  skip_file_until( fpSrc, daimoku, coding_system ) ;

  /* եνλޤǥ󤹤롣*/
  while( !feof( fpSrc ) ){
    /* ʸɤ򸫤ơ EUC ؤѴ롣*/
    if( ( search_key = mychar_readOneLine( fpSrc, coding_system ) ) == NULL )
      break ;

    /* ȤιԤäˤϡԤޤɤФ*/
    /* ޤĹ᤮Ѵ⤹äȤФʤλȤʤ */
    if( IS_ASCII_EQUAL( search_key[ 0 ], ';' ) ||
	IS_END_OF_STRING( search_key[ 0 ] ) ||
	IS_ASCII_EQUAL( search_key[ 0 ], '\n' ) ||
	IS_ASCII_EQUAL( search_key[ 0 ], '\r' ) ||
	IS_ASCII_EQUAL( search_key[ 0 ], ' ' ) ){
      free( search_key ) ;
      search_key = NULL ;
      /* ޤ뤫⤷ʤȥõġ*/
      if( !skip_file_until( fpSrc, daimoku, coding_system ) )
	break ;
      /* 餫Υȥ꤬դäˤϡļġʤ *
       * Ȥ⺣ ";" ʤƥܥܥɽƤϤʤ*/
      continue ;
    }
    for( ptr = search_key ; !IS_END_OF_STRING( *ptr ) ; ptr ++ ){
      if( IS_ASCII_EQUAL( *ptr, ' ' ) ){
	MYCHAR_SET_END_OF_STRING( *ptr ) ;
	ptr ++ ;
	break ;
      }
    }
    if( IS_END_OF_STRING( *ptr ) ){
      free( search_key ) ;
      search_key = ptr = NULL ;
      continue ;
    }
    top = NULL ;
    /* ѴꤷΤ¸ߤ뤫ɤå롣*/
    top = searchSudeniHenkanKakuteiShitamono
      ( search_key, top, okuri ) ;
    if( top == NULL ){
      purgeTop = NULL ;
      /* ѡ٤ΤǤ뤫ɤȽǤɬפǤ롣*/
      purgeTop = searchSudeniPurgeSaretamono
	( search_key, purgeTop, okuri ) ;
      if( purgeTop != NULL ){
	/* ɤ顢purge 줿Τ餷*/
	top = add_SkkinpSearchVector( top, ptr, NULL, NULL ) ;
	/* öѡ¦ϥåơ֥áࡣ*/
	vTopPurge = makeSearchVectorIndex( purgeTop, &len, False ) ;
	/* 줫顢ϥåơ֥򸫤ʤñڤФ*/
	/* ڤФ˥ϥå夬ꥢƤϺΤǡFalse Ǥ  */
	/* 롣ɤ줫ĤǤҥåȤʤСѡꥹȤ򸡺  */
	/* ̵̣*/
	vTop = makeSearchVectorIndex( top, &len, True ) ;
	/* ĤǤѴ̤¸ߤΤʤġ */
	if( vTop != NULL && len > 0 ){
	  /* դäѴ񤭽Ф*/
	  myCharFputstring( fpDest, search_key ) ;
	  fputc( ' ', fpDest ) ;
	  /* VectorIndex եݤФĤοͤϺǸ'\n'  *
	   * Ƥ롣*/
	  writeVectorIndexToFile( fpDest, vTop ) ;
	  count ++ ;
	}
	/* ݤβ*/
	free_VectorIndex( &vTop ) ;
	free_VectorIndex( &vTopPurge ) ;
	free_SkkinpSearchVector( &top ) ;
	free_SkkinpSearchVector( &purgeTop ) ;
      } else {
	/* դäѴ񤭽Ф*/
	myCharFputstring( fpDest, search_key ) ;
	fputc( ' ', fpDest ) ;
	/* ѴꤷΤäƤʤȤȤϡΤ *
	 * ޽񤭽ФƤסĤǤȤǤȤ*/
	myCharFputstring( fpDest, ptr ) ;
	fputc( '\n', fpDest ) ;
	fflush( fpDest ) ;
	count ++ ;
      }
    } else {
      /* ѴꤷƤΤǤФƤ롣ΤƤ롣*/
      free_SkkinpSearchVector( &top ) ;
    }
    free( search_key ) ;
    search_key = ptr = NULL ;
  }
  return count ;
}

/*
 * ե¸ߤ̵ͭĴ٤ؿ
 */
static int isFileExist( unsigned char *path )
{
  FILE *fp ;
  /* եɤ߹ߥ⡼ɤǳƤߤ롣*/
  if( ( fp = fopen( path, "rb" ) ) == NULL )
    return False ;
  /* Τʤ¸ߤ롣եĤ return True! */ 
  fclose( fp ) ;
  return True ;
}

static void skkinput_updateRecord( unsigned long lines )
{
  FILE *fpd, *fps ;
  time_t tval ;
  struct tm *lt ;
  char buffer[ TRANSBUFSIZE ] ;
  int exist_record_p ;
  static char *skk_week_alist[] = {
    "Sun", "Mon", "Tue", "Wed", "Thr", "Fri", "Sat",
  } ;
  static char *skk_month_alist[] = {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep",
    "Oct", "Nov", "Dec",  
  } ;

  /* 1970/1/1ηв롣*/
  if( time( &tval ) == -1 )
    return ;

  /* ꤷȤʤäΤƤ롣*/
  if( skkinput_j_count_kakutei <= 0 )
    return ;
  /* 顼ȯܤǤ礦*/
  exist_record_p = isFileExist( skkinput_record_path ) ;
  if( exist_record_p ){
    /* ե򥳥ԡ롣link Ǥɤɤͤġ*/
    if( !skkinput_copyFile
       ( skkinput_record_path, skkinput_record_path_tmp ) ){
      return ;
    }
  }
  /* ե뤬ʤä顢롣*/
  if( ( fpd = fopen( skkinput_record_path, "w" ) ) == NULL )
    return ;
  /* ǯβǤ뤫롣*/
#if 0
  (void)strftime
    ( buffer, TEXTBUFSIZE, "%a %b %d %T %Y", localtime( &tval ) ) ;
  fprintf
    ( fpd, "%s  Ͽ: %3ld  : %4ld  Ψ: %3ld%%  : %6ld\n",
     buffer, skkinput_j_count_touroku, skkinput_j_count_kakutei,
     ( skkinput_j_count_kakutei - skkinput_j_count_touroku ) * 100 /
     skkinput_j_count_kakutei, lines ) ;
#else
  lt = localtime( &tval ) ;
  fprintf( fpd, "%s %s %2d %02d:%02d:%02d %d",
	   skk_week_alist [ lt->tm_wday ],
	   skk_month_alist[ lt->tm_mon  ],
	   lt->tm_mday, lt->tm_hour, lt->tm_min, lt->tm_sec,
	   lt->tm_year + 1900 ) ;
  fprintf
    ( fpd, "  Ͽ: %3ld  : %4ld  Ψ: %3ld%%  : %6ld\n",
      skkinput_j_count_touroku, skkinput_j_count_kakutei,
      ( skkinput_j_count_kakutei - skkinput_j_count_touroku ) * 100 /
      skkinput_j_count_kakutei, lines ) ;
#endif

  if( exist_record_p ){
    size_t num ;

    if( ( fps = fopen( skkinput_record_path_tmp, "r" ) ) == NULL ){
      fclose( fpd ) ;
      return ;
    }
    /* Ĥϥԡ롣*/
    while( !feof( fps ) ){
      num = fread( buffer, sizeof( char ), TEXTBUFSIZE, fps ) ;
      /* ǥե륷ƥեΥåäƤäɤȻפΤ */
      /* ɡ */
      if( fwrite( buffer, sizeof( char ), num, fpd ) < num ){
	/* ȥ顼ȯϴǤ*/
	fclose( fps ) ;
	fclose( fpd ) ;
	/* 񤳤Ȥեϻߤᡣ*/
	unlink( skkinput_record_path ) ;
	/* Ȥ᤹Ǥϥ顼åʤäƤ */
	/* äɤΡ */
	/* ա֤줸㡢ꤵ󡣤ɤޤ礦*/
	/* 1. դ̼ˤ롣*/
	/* 2. οͤ˻Ƥ餦*/
	/* 3. Τ󤾡*/
	link( skkinput_record_path_tmp, skkinput_record_path ) ;
	return ;
      }
    }
    fclose( fps ) ;
    /* եõ롣*/
    unlink( skkinput_record_path_tmp ) ;
  }
  fclose( fpd ) ;
  skkinput_j_count_kakutei = 0 ;
  skkinput_j_count_touroku  = 0 ;
  return ;
}

/*
 * ե򥳥ԡؿġ
 */
static int skkinput_copyFile( unsigned char *from, unsigned char *to )
{
  FILE *fpTo, *fpFrom ;
  int rnum ;
  unsigned char buffer[ TRANSBUFSIZE ] ;

  /* ԡ褬ʤäФ̣*/
  if( ( fpTo = fopen( to, "wb" ) ) == NULL )
    return False ;
  /* ԡʤäƤ⼺ԡ*/
  if( ( fpFrom = fopen( from, "rb" ) ) == NULL ){
    fclose( fpTo ) ;
    return False ;
  }
  rnum = 0 ;
  while( !feof( fpFrom ) ){
    rnum =
      fread( buffer, sizeof( unsigned char ), TRANSBUFSIZE, fpFrom ) ;
    /* ɤ߹᤿̤񤭹ġ*/
    if( fwrite( buffer, sizeof( unsigned char ), rnum, fpTo ) < rnum ){
      /* 񤭹̤ΤʤʤäƤĤϰ۾ȯ */
      /* ̤ϥե륷ƥե򵿤ɤ͡*/
      fclose( fpFrom ) ;
      fclose( fpTo ) ;
      /* Ȥ櫓ǡԡߤƺ꤫Υեõ롣*/
      unlink( to ) ;
      /* ԡȡ*/
      return False ;
    }
  }
  fclose( fpTo ) ;
  fclose( fpFrom ) ;
  return True ;
}

/*
 * ˺ѴꤷƤ񤭹ؿ
 */
void skkinput_updateLocalJisyo( void )
{
  FILE *fpSrc, *fpDest ;
  unsigned long lines ;
  char *tempfilename ;

#ifdef DEBUG_LDIC
  fprintf( stderr, "Now saving ....\"%s\"\n", skkinput_local_jisyo_path ) ;
#endif
  /*
   * ֤ࡣɤäƼ褦ġ
   * ֤ͰͤλƤ뿿¤ʤɤ٤ΤΤǤʤΤ
   * ֤餳르ꥺ
   * ֤ɡߤʤϥܥΥ르ꥺʤΤʡ
   * ֤󤿡Х
   */
  /*
   * ʤơġ
   * 椫ꤷΤäƤΤʤ뤳ȤϰĤ
   *  A->B ؤ COPY ʤ顢դä٤Τä
   * 롣
   * A  backup ˤơbackup  B եˤ롣
   *  OK ΤϤǤϤ뤱ɡ
   * ֡ķ purge Ȥդ˺Ƥʡ߷
   */
  /* Хåå׼õ롣󡣤äȲİʡ */

  /* Ȥ BACKUP JISYO ¸ߤʤ硢ơLOCAL-JISYO  *
   * ¸ߤʤϤɤΤ */

  /* ιԤݤѤƥݥե롣*/
  tempfilename = tmpnam( NULL ) ;

  /* ɽ꼭ΥХååפ롣Ԥʤ󤫤Τʤ*/
  unlink( skkinput_jisyo_backup_path ) ;

  /* öƥݥեؤȥԡ롣
   * ԡ褦Ԥ褦ɬ tempfile Ϻ뤳Ȥ
   * դ뤳ȡ顢θ fopen Ԥ뤳ȤϤʤ*/ 
  skkinput_copyFile
    ( skkinput_local_jisyo_path, tempfilename ) ;
  /* ɽ꼭Υԡ¸ߤʤ̣֤Ǥ롣*/
  if( ( fpSrc = fopen( tempfilename, "rb" ) ) == NULL ){
#ifdef DEBUG_LDIC
    fprintf( stderr, "cannot create backup jisyo...error!\n" ) ;
#endif
    return ;
  }
  /* 񤭹ʤĤ̵ġ*/
  if( ( fpDest = fopen( skkinput_local_jisyo_path, "wb" ) ) == NULL ){
#ifdef DEBUG_LDIC
    fprintf( stderr, "cannot create local jisyo...error!\n" ) ;
#endif
    fclose( fpSrc ) ;
    /* backup 򸵤̾˥͡ह롣Ԥ뤫⤷ʤɡĤ *
     * ξˤ̵뤹뤷ʤʡ */
    skkinput_copyFile
      ( tempfilename, skkinput_local_jisyo_path ) ;
    /* permission 򸵤᤹*/
    chmod( skkinput_local_jisyo_path, skkinput_local_jisyo_mode ) ;
    /* file coding system Ĵľ*/
    skkinput_local_jisyo_coding_system = 
      check_skkinput_jisyo_code( skkinput_local_jisyo_path ) ;
    return ;
  }
  lines = 0 ;
  /* 겾̾Ѵη̤񤭹ࡣ*/
  lines += skkinput_updateHenkanResult
    ( fpSrc, fpDest, True, ";; okuri-ari entries.",
      skkinput_jisyo_backup_coding_system ) ;
  /* 겾̵̾Ѵη̤񤭹ࡣ*/
  lines += skkinput_updateHenkanResult
    ( fpSrc, fpDest, False, ";; okuri-nasi entries.",
      skkinput_jisyo_backup_coding_system ) ;
  /* եݥ󥿤Ĥ롣*/
  fclose( fpSrc ) ;
  fclose( fpDest ) ;
  /* permission ꡣ*/
  chmod( skkinput_local_jisyo_path, skkinput_local_jisyo_mode ) ;
  /* backup ˥ԡ롣*/
  skkinput_copyFile
    ( tempfilename, skkinput_jisyo_backup_path ) ;
  /* ǥХååפ coding system  skkinput-local-jisyo  * 
   * coding system Ʊˤʤä*/
  skkinput_jisyo_backup_coding_system =
    skkinput_local_jisyo_coding_system ;
  /* permission ꡣ*/
  chmod( skkinput_jisyo_backup_path, skkinput_local_jisyo_mode ) ;
  /* եõ롣*/
  unlink( tempfilename ) ;
  /* ϥå򥯥ꥢåľ*/
  clearHenkanKakuteiHash() ;
  skkinput_local_jisyo_coding_system =
    check_skkinput_jisyo_code( skkinput_local_jisyo_path ) ;
  /* skkinput-keep-record ʤСġ*/
  if( skkinput_keep_record ){
    /* record file 򹹿롣*/
    skkinput_updateRecord( lines ) ;
  }
  /* ֤줿Τ顢ե skkinput μƱΤ
   * ΤȤʤäΤ顢ι(ѹ)ե饰 False ˤʤ롣*/
  skkinput_jisyo_dirty          = False ;
  skkinput_autosave_jisyo_dirty = False ;
  /* ȥ֥ե뤬äˤϺ롣˥֤줿
   * Τ顢֥եϤ⤦פǤ*/
  if( skkinput_autosave_path != NULL ){
    unlink( skkinput_autosave_path ) ;
  }
#ifdef DEBUG_LDIC
  fprintf( stderr, ".......Done\n" ) ;
#endif
  return ;
}

/*
 * ˺ѴꤷƤ񤭹ؿ
 */
void skkinput_autosaveLocalJisyo( void )
{
  FILE *fp ;
  if( skkinput_autosave_path == NULL )
    return ;
  /* 񤱤ʤäʤäΤʤ*/
  if( ( fp = fopen( skkinput_autosave_path, "wb" ) ) == NULL )
    return ;
  /* äȽ񤭹ࡣ*/
  skkinputNoNaibuNoKouhoWoFileNiKaku( fp, False, False ) ;
  skkinputNoNaibuNoKouhoWoFileNiKaku( fp, True,  False ) ;
  /* äѡξ*/
  skkinputNoNaibuNoKouhoWoFileNiKaku( fp, False, True  ) ;
  /* եĤƽλ*/
  fclose( fp ) ;
  return ;
}

/*
 * ư˰Ȥؿġȥ֤η̤ɤ
 * 뵡ǽġХäƤʤǽ̵ĤɤΤ顣
 */
void skkinput_readAutoSavedLocalJisyo( void )
{
  FILE *fp ;
  if( skkinput_autosave_path == NULL )
    return ;
  /*
   * ʤäΤʤ
   * ƥʡ֤ꤵܶǤ Υե̾ʬäƤ
   *         ˡġ
   * ֤䡢Ρ̾ʬäƤƤΤʤȤ⤢뤷ġ
   */
  if( ( fp = fopen( skkinput_autosave_path, "rb" ) ) == NULL )
    return ;
  skkinputAutoSaveFileWoYondeFukugenSuru( fp ) ;
  fclose( fp ) ;
  /* ȥ֤ƤեɤФʤΤ顢ä
   * ȦǤ롣*/
  skkinput_autosave_jisyo_dirty = False ;
  return ;
}
