# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: postgresql module, dbi import frame

=end
module  SiSU_DBI                                                                 #% database building
  require_relative 'help'                               # help.rb
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env; include SiSU_Screen
  require_relative 'param'                              # param.rb
    include SiSU_Param
  require_relative 'db_dbi'                             # db_dbi.rb
    include SiSU_DbDBI
  require_relative 'shared_html_lite'                   # shared_html_lite.rb
    include SiSU_FormatShared
  class SQL
    def initialize(opt)
      SiSU_Env::Load.new('dbi',true).prog
      @opt=opt
      @db=SiSU_Env::InfoDb.new
      if @opt.cmd =~/[Dd]/ \
      or  @opt.mod.inspect =~/--(pg(?:sql)?|(?:sq)?lite)/
        @sql_type=if @opt.cmd=~/D/ \
        or @opt.mod.inspect =~/--pg(?:sql)?/
          maintenance_check(@opt,__FILE__,__LINE__) if @opt.cmd.inspect =~/M/
          'pg'
        elsif @opt.cmd =~/d/ \
        and @opt.mod.inspect =~/--(?:db[=-])?pg(?:sql)?/
          maintenance_check(@opt,__FILE__,__LINE__) if @opt.cmd.inspect =~/M/
          'pg'
        elsif @opt.cmd=~/d/ \
        or @opt.mod.inspect =~/--(?:sq)?lite/
          maintenance_check(@opt,__FILE__,__LINE__) if @opt.cmd.inspect =~/M/
          'sqlite'
        elsif @opt.cmd =~/d/ \
        and @opt.mod.inspect =~/--(?:db[=-])?(?:sq)?lite/
          maintenance_check(@opt,__FILE__,__LINE__) if @opt.cmd.inspect =~/M/
          'sqlite'
        else
          maintenance_check(@opt,__FILE__,__LINE__) if @opt.cmd.inspect =~/M/
          'sqlite'
        end
      end
    end
    def maintenance_check(opt,file,line)
      p opt.mod
      p opt.cmd
      p "at #{file} #{line}"
    end
    def read_psql
      begin
        @conn=@db.psql.conn_dbi
      rescue
        if @opt.mod.inspect=~/--(createall|create)/
          puts %{manually create the database: "#{@db.db}" if it does not yet exist}
          #sudo su -p postgres;  createdb #{@db.db}; #[createuser?]
        end
        SiSU_DbDBI::Case.new(@opt,@conn,@sql_type).cases
        @conn=DBI.connect(@db.dbi,@db.user,@db.db)
      ensure
      end
    end
    def read_sqlite
      begin
        sql_type='sqlite'
        @conn=@db.sqlite.conn_sqlite3
      rescue
      ensure
      end
    end
    def connect
      case @sql_type
      when /pg/;     read_psql
      when /sqlite/; read_sqlite
      end
      SiSU_Screen::Ansi.new(@opt.cmd,"DBI (#{@sql_type}) #{@opt.mod}",@opt.fno).dbi_title unless @opt.cmd =~/q/
      begin
        SiSU_DbDBI::Case.new(@opt,@conn,@sql_type).cases
      rescue
        SiSU_Errors::InfoError.new($!,$@,@cf,@opt.fns).error do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
      begin
      rescue
        connect
      end
    end
  end
end
__END__
