// -*-c++-*-
/* $Id: sfssd.h,v 1.9 2001/06/28 04:47:24 dm Exp $ */

/*
 *
 * Copyright (C) 1999 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "arpc.h"
#include "sfsmisc.h"
#include "list.h"
#include "qhash.h"
#include "itree.h"

struct sfssrv {
  /* How to invoke this server */
  const vec<str> argv;
  rpc_ptr<int> uid;
  rpc_ptr<int> gid;

  /* Copy of the server we are running */
  ptr<axprt_unix> x;
  ihash_entry<sfssrv> link;

private:
  void setprivs ();
  void getpkt (const char *, ssize_t, const sockaddr *);

public:
  sfssrv (const vec<str> &argv);
  ~sfssrv ();
  void launch ();
};
extern ihash<const vec<str>, sfssrv, &sfssrv::argv, &sfssrv::link> srvtab;

struct extension {
  vec<str> names;
  qhash<u_int32_t, sfssrv *> srvtab;
  list_entry<extension> link;
  bool covered (const bhash<str> &eh);
  bool covered (const vec<str> &ev);
};

struct release {
  const u_int32_t rel;
  list<extension, &extension::link> extlist;
  itree_entry<release> link;
  release (u_int32_t rel);
  ~release ();
  extension *getext (const vec<str> &ev);
};

struct server {
  const str host;
  rpc_ptr<sfs_hash> hostid;
  itree<const u_int32_t, release, &release::rel, &release::link> reltab;
  list_entry<server> link;

  server (const str &host, sfs_hash *hostid);
  ~server ();
  release *getrel (u_int32_t r);
  bool clone (ref<axprt_clone> x, svccb *sbp,
	      u_int32_t rel, sfs_service service, const bhash<str> &eh);
};

extern list<server, &server::link> serverlist;
