/***************************************************************************
 *  Module:      $Id: report.c,v 2.18 1997/12/31 05:18:32 nemesis Exp nemesis $
 *  Description: reporting with and without syslog
 *  Author:      maf, cjc
 *
 * Copyright (c) 1995 Mark Fullmer and The Ohio State University
 * Copyright (c) 1997 Cornelius Cook and Counterpoint Networking, Inc.
 * http://www.cpoint.net/projects/sendpage
 ***************************************************************************/
/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * report() - calls syslog
 * $Log: report.c,v $
 * Revision 2.18  1997/12/31 05:18:32  nemesis
 * CLOCAL for all, GCC fixes, WAIT_WORD finished
 *
 * Revision 2.17  1997/12/28 23:20:45  nemesis
 * include cleanups, configure additions/corrections
 *
 * Revision 2.16  1997/12/26 02:37:31  nemesis
 * code clean up, b* -> mem* funcs, finding NL -> # bug
 *
 * Revision 2.15  1997/12/25 08:30:52  nemesis
 * code cleanups
 *
 * Revision 2.14  1997/12/25 06:44:34  nemesis
 * time_t declarations and "make install" fix
 *
 * Revision 2.13  1997/12/24 21:50:04  nemesis
 * mailing list updates
 *
 * Revision 2.12  1997/12/24 21:42:54  nemesis
 * 0.8a released.
 *
 * Revision 2.11  1997/12/24 21:02:02  nemesis
 * more changes
 *
 * Revision 2.10  1997/12/24 20:56:03  nemesis
 * gearing up for 0.8a more
 *
 * Revision 2.9  1997/12/24 20:45:35  nemesis
 * trying to make 0.8a release
 *
 * Revision 2.8  1997/12/24 20:29:08  nemesis
 * fixed up autoconf modifications, cleaned up signal stuff
 *
 * Revision 2.7  1997/12/24 20:15:13  nemesis
 * sendpage.h now mostly contained within 'configure'
 *
 * Revision 2.6  1997/12/24 19:52:04  nemesis
 * fixing posix checking
 *
 * Revision 2.5  1997/12/24 19:41:49  nemesis
 * posix additions, syslog autoconf'd
 *
 * Revision 2.4  1997/12/24 19:33:03  nemesis
 * check for POSIX
 *
 * Revision 2.3  1997/12/17 09:37:27  nemesis
 * more autoconf changes... mostly strerror.o
 *
 */

#include "sendpage.h"
#include "report.h"

#ifdef	STDC_HEADERS
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#ifndef LOG_NDELAY
#define LOG_NDELAY	0
#endif
#ifndef LOG_DAEMON
#define LOG_DAEMON	0
#endif

extern int debug;
extern char *progname;

/*
 * This is initialized so you get stderr until you call
 *	report_init()
 */
static int stderr_only = 1;

void report_init(int nolog) {
	stderr_only = nolog;
#ifdef HAVE_SYSLOG
	if (!stderr_only) {
		openlog(progname, LOG_PID | LOG_NDELAY, LOG_SENDPAGE);
	}
#endif
}

/*
 * This routine reports errors and such via stderr and syslog() if
 * appopriate.  It just helps avoid a lot of "#ifdef SYSLOG" constructs
 * from being scattered throughout the code.
 *
 * The syntax is identical to syslog(3), but %m is not considered special
 * for output to stderr (i.e. you'll see "%m" in the output. . .).  Also,
 * control strings should normally end with \n since newlines aren't
 * automatically generated for stderr output (whereas syslog strips out all
 * newlines and adds its own at the end).
 */

static char *levelnames[] = {
#ifdef LOG_SALERT
	"level(0): ",
	"alert(1): ",
	"alert(2): ",
	"emerg(3): ",
	"error(4): ",
	"crit(5):  ",
	"warn(6):  ",
	"note(7):  ",
	"info(8):  ",
	"debug(9): ",
	"level(?): "
#else
	"emerg(0): ",
	"alert(1): ",
	"crit(2):  ",
	"error(3): ",
	"warn(4):  ",
	"note(5):  ",
	"info(6):  ",
	"debug(7): ",
	"level(?): "
#endif
};
static int numlevels = sizeof(levelnames) / sizeof(levelnames[0]);


/*
 * Print a log message using syslog(3) and/or stderr.
 * The message passed in should not include a newline.
 */
#ifdef	STDC_HEADERS
void report(int priority, char *fmt,...) {
#else
/*VARARGS2*/
void report(int priority, char *fmt, va_dcl va_alist) {
#endif
	va_list ap;
	static char buf[4096]; /* evil */

	if ((priority < 0) || (priority >= numlevels)) {
		priority = numlevels - 1;
	}
#ifdef	STDC_HEADERS
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	vsprintf(buf, fmt, ap);
	va_end(ap);

	/*
	 * Print the message
	 */
	if (stderr_only || (debug > 2)) {
		fprintf(stderr, "%s: %s %s\n",
				progname, levelnames[priority], buf);
	}
#ifdef HAVE_SYSLOG
	if ((!stderr_only) && (debug <= 2))
		syslog(priority, buf);
#endif
}
