/***************************************************************************
                          util.cpp  -  description
                             -------------------
    begin                : Fri Sep 14 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qstring.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qpainter.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qtextstream.h>
#include <qstringlist.h>
#include <qmap.h>
#include <qdom.h>
#include <qimage.h>
#include <stdlib.h>
#include "config.h"
#include "scribusdoc.h"
#ifdef HAVE_TIFF
	#include <tiffio.h>
#endif
#ifdef HAVE_CMS
	#include <lcms.h>
extern cmsHPROFILE CMSinputProf;
extern cmsHPROFILE CMSoutputProf;
extern cmsHPROFILE CMSprinterProf;
extern bool SoftProofing;
extern bool CMSuse;
extern int IntentMonitor;
extern int IntentPrinter;
#endif
extern ProfilesL InputProfiles;
// #include <iostream.h>

QPixmap loadIcon(QString nam);
bool loadText(QString nam, QString *Buffer);
bool loadTextQS(QString nam, QString *Buffer);
float Cwidth(ScribusDoc *doc, QPainter *p, QString name, QString ch, int Siz);
float QStoFloat(QString in);
int QStoInt(QString in);
QString GetAttr(QDomElement *el, QString at, QString def="0");
QImage LoadPict(QString fn);
#ifdef HAVE_CMS
QImage ProofPict(QImage *Im, QString Prof, int Rend, cmsHPROFILE emPr=0);
#else
QImage ProofPict(QImage *Im, QString Prof, int Rend);
#endif

#ifdef HAVE_CMS
QImage ProofPict(QImage *Im, QString Prof, int Rend, cmsHPROFILE emPr)
#else
QImage ProofPict(QImage *Im, QString Prof, int Rend)
#endif
{
	if (Prof == "")
		return Im->copy();
#ifdef HAVE_CMS
	QImage out = Im->copy();
	if ((CMSuse) && (SoftProofing))
		{
		QImage buf = QImage(Im->width(), 2, 32);
		cmsHTRANSFORM xform, xfor2;
		cmsHPROFILE inputProf;
  	DWORD dwOut;
  	if (emPr != 0)
  		inputProf = emPr;
  	else
  		inputProf = cmsOpenProfileFromFile(InputProfiles[Prof], "r");
  	icColorSpaceSignature OutputColorSpace;
  	OutputColorSpace = cmsGetColorSpace(CMSprinterProf);
  	dwOut  = BYTES_SH(1) | CHANNELS_SH(_cmsChannelsOf(OutputColorSpace));
		xform = cmsCreateTransform(inputProf, TYPE_RGBA_8,
															 CMSprinterProf, dwOut,
															 IntentPrinter,
															 0);
		xfor2 = cmsCreateTransform(CMSprinterProf, dwOut,
															 CMSoutputProf, TYPE_RGBA_8,
															 Rend,
															 0);
		for (int i=0; i < out.height(); i++)
			{
			LPBYTE ptr = out.scanLine(i);
			LPBYTE ptr2 = buf.scanLine(0);
			cmsDoTransform(xform, ptr, ptr2, out.width());
			cmsDoTransform(xfor2, ptr2, ptr, out.width());
			}
		cmsDeleteTransform(xform);
		cmsDeleteTransform(xfor2);
		if (emPr == 0)
			cmsCloseProfile(inputProf);
		}
	else
		{
		if (CMSuse)
			{
			cmsHTRANSFORM xform;
			cmsHPROFILE inputProf;
  		if (emPr != 0)
  			inputProf = emPr;
  		else
  		inputProf = cmsOpenProfileFromFile(InputProfiles[Prof], "r");
			xform = cmsCreateTransform(inputProf, TYPE_RGBA_8,
															 	 CMSoutputProf, TYPE_RGBA_8,
															 	 Rend,
															 	 0);
			for (int i=0; i < out.height(); i++)
				{
				LPBYTE ptr = out.scanLine(i);
				cmsDoTransform(xform, ptr, ptr, out.width());
				}
			cmsDeleteTransform(xform);
			if (emPr == 0)
				cmsCloseProfile(inputProf);
			}
		}
	return out;
#else
	return Im->copy();
#endif
}

QImage LoadPict(QString fn)
{
	QString tmp, dummy, cmd1, cmd2, BBox;
	QChar tc;
	QImage Bild;
	float x, y, b, h;
	bool found = false;
	int ret = -1;
	QFileInfo fi = QFileInfo(fn);
	QString ext = fi.extension(false).lower();
	if ((ext == "eps") || (ext == "ps"))
		{
		QFile f(fn);
		if (f.open(IO_ReadOnly))
			{
			QTextStream ts(&f);
			while (!ts.atEnd())
				{
				tc = ' ';
				tmp = "";
				while ((tc != '\n') && (tc != '\r'))
					{
					ts >> tc;
					if ((tc != '\n') && (tc != '\r'))
						tmp += tc;
					}
				if (tmp.startsWith("%%BoundingBox"))
					{
					found = true;
					BBox = tmp;
					}
				if (tmp.startsWith("%%EndComments"))
					break;
				}	
			f.close();
			if (found)
				{
				QTextStream ts2(&BBox, IO_ReadOnly);
				ts2 >> dummy >> x >> y >> b >> h;
				cmd1 = "gs -q -dNOPAUSE -sDEVICE=png16m -r72 -sOutputFile=/tmp/sc.png -g";
				cmd2 = " -c showpage -c quit";
				ret = system(cmd1 + tmp.setNum(qRound(b)) + "x" + tmp.setNum(qRound(h)) + " " + fn + cmd2);
				if (ret == 0)
					{
					QImage im4;
					QImage image;
					image.load("/tmp/sc.png");
  				image = image.convertDepth(32);
					int wi = image.width();
					int hi = image.height();
					QBitmap bm("/tmp/sc.png");
					bm.fill(Qt::color1);
    			int i = 0;
    			QPainter pp;
    			pp.begin(&bm);
    			pp.setPen(Qt::color0);
    			QString tmp2;
    			if ( image.depth() == 8 ) {
        			for( int yi=0; yi < hi; yi++ ) {
            			uchar * s = image.scanLine( yi );
            			for( int xi=0; xi < wi; xi++ ) {
                			if(image.color(s[xi]) == 0xffffffff)
                				pp.drawPoint(xi, yi);
                			i++;
            			}
        			}
    			} else {
        			for( int yi=0; yi < hi; yi++ ) {
            			QRgb * s = (QRgb*)(image.scanLine( yi ));
            			for( int xi=0; xi < wi; xi++ )
                			for( xi=0; xi < wi; xi++ ) {
                					if((*s++) == 0xffffffff)
                							pp.drawPoint(xi, yi);
                    			i++;
                			}
        			}
    			}
    			pp.end();
					QPixmap pm;
					pm.convertFromImage(image);
					pm.setMask(bm);
					im4.setAlphaBuffer(true);
					im4 = pm.convertToImage();
					Bild = im4.copy(x, 0, b-x, h-y);
					system("rm -f /tmp/sc.png");
					}
				}
			}
		}
#ifdef HAVE_TIFF
	if (ext == "tif")
		{
		QImage img;
		QImage inI2;
		TIFF* tif = TIFFOpen(fn, "r");
		if(tif)
			{
			unsigned width, height,size;
			TIFFGetField(tif, TIFFTAG_IMAGEWIDTH, &width);
			TIFFGetField(tif, TIFFTAG_IMAGELENGTH, &height);
			size=width*height;
			uint32 *bits=(uint32*) _TIFFmalloc(size * sizeof (uint32));
			if(bits)
				{
				if (TIFFReadRGBAImage(tif, width, height, bits, 0))
					{
        	img.create(width,height,32);
					if(TIFFGetR(0x1234567)==qRed  (0x1234567) &&
						 TIFFGetG(0x1234567)==qGreen(0x1234567) &&
						 TIFFGetB(0x1234567)==qBlue (0x1234567))
						{
						for(unsigned y=0; y<height; y++)
							memcpy(img.scanLine(height-1-y),bits+y*width,width*4);
						}
					else
						{
						uint32 *inp=bits;
						for(unsigned y=0; y<height; y++)
							{
							QRgb *row=(QRgb*) (img.scanLine(height-1-y));
							for(unsigned x=0; x<width; x++)
								{
								const uint32 col=*(inp++);
								row[x]=qRgb(TIFFGetR(col), TIFFGetG(col), TIFFGetB(col) ) | (TIFFGetA(col)<<24);
								}
							}
						}
					Bild = img.copy();
					}
				_TIFFfree(bits);
				}
			TIFFClose(tif);
			}
		}
#endif
	else
		{
		Bild.load(fn);
  	Bild = Bild.convertDepth(32);
		}
	return Bild;
}

QString GetAttr(QDomElement *el, QString at, QString def)
{
	return el->attribute(at, def);
}

int QStoInt(QString in)
{
	bool ok = false;
	int c = in.toInt(&ok);
	if (ok)
		return c;
	else
		return 0;
}

float QStoFloat(QString in)
{
	bool ok = false;
	float c = in.toFloat(&ok);
	if (ok)
		return c;
	else
		return 0.0;
}

QPixmap loadIcon(QString nam)
{
  QString pfad = PREL;
  pfad += "/share/scribus/icons/"+nam;
	QPixmap pm;
	pm.load(pfad);
	return pm;
}

bool loadText(QString nam, QString *Buffer)
{
	QFile f(nam);
	uint posi;
	bool ret = false;
	QByteArray bb(f.size());
	if (f.open(IO_ReadOnly))
		{
		f.readBlock(bb.data(), f.size());
		f.close();
		for (posi = 0; posi < bb.size(); posi++)
			{
			*Buffer += bb[posi];
			}
		ret = true;
		}
	else
		{
		ret = false;
		}
	return ret;
}

bool loadTextQS(QString nam, QString *Buffer)
{
	QFile f(nam);
	bool ret = false;
	if (f.open(IO_ReadOnly))
		{
		QTextStream t(&f);
		*Buffer = t.read();
		f.close();
		ret = true;
		}
	else
		{
		ret = false;
		}
	return ret;
}

float Cwidth(ScribusDoc *doc, QPainter *p, QString name, QString ch, int Siz)
{
	if ((*doc->AllFonts)[name]->HasMetrics)
		return (*doc->AllFonts)[name]->CharWidth[QMIN(ch.at(0).unicode(),255)]*Siz;
	else
		return p->fontMetrics().width(ch);
}

