/***************************************************************************
                          page.h  -  description
                             -------------------
    begin                : Sat Apr 7 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PAGE_H
#define PAGE_H
#include <qobject.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qlist.h>
#include <qevent.h>
#include <qscrollview.h>
#include "scribusdoc.h"
#include "pageitem.h"
/**
  *@author Franz Schmid
  */

class Page : public QWidget  {

Q_OBJECT

public:
	Page(QWidget *pa, int x, int y, int b, int h, ScribusDoc *doc, QScrollView *view);
	~Page();
  /** Zeichnet eine Ellipse */
  int PaintEllipse(float x, float y, float b, float h, int w, QString fill, QString outline);
  /** Zeichnet eine Bildbox */
  int PaintPict(float x, float y, float b, float h);
  /** Zeichnet ein Rechteck */
  int PaintRect(float x, float y, float b, float h, int w, QString fill, QString outline);
  /** Zeichnet eine Linie */
  int PaintLine(float x, float y, float b, float h, int w, QString outline);
  /** Zeichnet eine Textbox */
  int PaintText(float x, float y, float b, float h, int w, QString outline);
  /** Ldt ein Bild */
  void LoadPict(QString fn, int ItNr);
  void insertColor(QString nam, float c, float m, float y, float k);
  void DrawPageMarks(QPaintEvent *e);
  void DrawPageItems(QPaintEvent *e);
	void paintEvent(QPaintEvent *e);
	void mouseReleaseEvent(QMouseEvent *m);
	void mouseMoveEvent(QMouseEvent *m);
	void mousePressEvent(QMouseEvent *m);
	void dragEnterEvent(QDragEnterEvent *e);
	void dragMoveEvent(QDragMoveEvent *e);
	void dropEvent(QDropEvent *e);
	bool SeleItem(QMouseEvent *m);
	bool SeleItemPos(QPoint m);
	void Deselect();
	void SelectItemNr(int nr);
	void SetupDraw(int Nr);
	void MoveItemI(float newX, float newY, int ite);
	bool MoveItem(float newX, float newY, int ite);
	void UpdateClip(PageItem* b);
	bool SizeItem(float newX, float newY, int ite);
	bool MoveSizeItem(QPoint newX, QPoint newY, int ite);
	float xy2Deg(float x, float y);
	void RotateItem(float win, int ite);
	void MarkClip(PageItem *b);
	void Transform(PageItem *b, QPainter *p);
	void TransformM(PageItem *b, QPainter *p);
	void RefreshItem(PageItem *b);
	void RepaintTextRegion(PageItem *b, QRegion alt);
	void DrawCursChar(PageItem *b, QPainter *p, int po);
	void EmitValues(PageItem *b);
	QRegion ViewReg();
  /** Liste der Elemente */
  QList<PageItem> Items;
  /** Dokument zu dem die Seite gehrt */
  ScribusDoc *doku;
  /** Nummer der Seite */
  uint PageNr;
  /** Name der Seite, wenn Musterseite */
  QString PageNam;
  QString MPageNam;
  QScrollView *Anz;
  /** Seitenrnder */
/*  struct { float Top;
           float Left;
           float Right;
           float Bottom;
          }  */
  Margs Margins;
  int Mxp;
  int Myp;
  bool Mpressed;
  bool mCG;
  float oldW;
  QList<uint> SelItem;
  int HowTo;
  int ClRe;
  int ClRe2;
  bool CursVis;
  int oldCp;
  int Dxp;
  int Dyp;
  bool Imoved;
  int SeRx;
  int SeRy;
  bool HaveSelRect;
  bool LeftPg;
  bool Magnify;

public slots:
	void ChLineWidth(int w);
	void ChLineArt(PenStyle w);
	void ChLineJoin(PenJoinStyle w);
	void ChLineEnd(PenCapStyle w);
	void ChLocalXY(float x, float y);
	void ChLocalSc(float x, float y);
	void ToggleBookmark();
	void ToggleAnnotation();
	void TogglePic();
	void FlipImageH();
	void FlipImageV();
	void ItemFont(QString fon);
	void chFSize(int size);
	void ItemPen(QString farbe);
	void ItemBrush(QString farbe);
	void ItemPenShade(int sha);
	void ItemBrushShade(int sha);
	void QueryFarben();
	void SetFrameRect();
	void SetFrameRounded();
	void SetFrameOval();
	void ToBack();
	void ToFront();
	void LowerItem();
	void RaiseItem();
	void DeleteItem();
	void PasteItem(struct CLBuf *Buffer, bool loading);
	bool slotSetCurs(int x, int y);
	void slotDoCurs(bool draw);
	void BlinkCurs();
	void ChLineSpa(float w);
	void chKerning(float us);
	void chTyStyle(int s);
	void SetAbStyle(int s);
	void chAbStyle(PageItem *b, int s);
	void AlignObj(bool xa, bool ya, bool Vth, bool Vtv, float xdisp, float ydisp, int xart, int yart);
signals: // Signals
  /** Mausposition X */
  void Hrule(int);
  /** Mausposition Y */
  void Vrule(int);
  /** Seite gewechselt */
  void PgCh(int);
  /** Element gezeichnet */
  void PaintingDone();
  /** Element ausgewhlt */
  void HaveSel(int);
  /** Seite verndert */
  void DocChanged();
  /** Position eines Elementes */
  void ItemPos(float, float);
  /** Breite und Hhe eines Elementes */
  void ItemGeom(float, float);
  void ItemRadius(float);
  /** Setzt den Drehungswinkel des Elementes */
  void SetAngle(float);
  /** Zoomfunktionen */
  void ZoomIn();
  void ZoomOut();
  void ZoomAbs();
  void AbsPosi(int, int);
  /** Sendet die Linienstrke an die Mapalette */
  void SetSizeValue(int);
  /** Sendet die Linienart an die Mapalette */
  void SetLineArt(PenStyle, PenCapStyle, PenJoinStyle);
  /** Sendet die lokalen Bildeigenschaften an die Mapalette */
  void SetLocalValues(float, float, float, float);
  /** Sendet die Stiftfarbe an die Farbpalette */
  void ItemFarben(QString, QString, int, int);
  /** Sendet die Textattribute an die Mapalette */
  void ItemTextAttr(float);
  /** Sendet die Schriftart */
  void ItemTextFont(QString);
  /** Sendet die Schriftgre */
  void ItemTextSize(int);
  void ItemTextUSval(float);
  void ItemTextAbs(int);
  /** Text in Textbox selektiert */
  void HasTextSel();
  void HasNoTextSel();
  void CutItem();
  void CopyItem();
  void ItemTextStil(int);
  void LoadPic();
  void ModifyIt();
  void LoadElem(QString, int, int, bool, bool);
  void Amode(int);
	void AnnotProps();
};

#endif
