;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribehtmlgui/api.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Nov 23 10:00:00 2001                          */
;*    Last change :  Mon Nov 26 17:56:11 2001 (serrano)                */
;*    Copyright   :  2001 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    The htmlgui API                                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribehtmlgui_api
   
   (include "pervasive.sch"
	    "../scribeapi/markup.sch")
   
   (library scribeapi)
   
   (import  __scribehtmlgui_ast)
   
   (eval    (export-exports))
   
   (export  (form . body)
	    (label . body)
	    (button . body)
	    (checkbutton . body)
	    (radio . body)
	    (entry . exp)
	    (password . exp)
	    (text . exp)
	    (fileselector . exp)
	    (listbox . exp)
	    (combobox . exp)
	    (hidden . exp)
	    
	    (scribehtmlgui-api-apache-initialize)))

;*---------------------------------------------------------------------*/
;*    scribehtmlgui-api-apache-initialize ...                          */
;*---------------------------------------------------------------------*/
(define (scribehtmlgui-api-apache-initialize)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    form ...                                                         */
;*---------------------------------------------------------------------*/
(define-markup (form :url
		     (:submit "Submit")
		     (:reset "Reset")
		     (:submit-name "submit") 
		     (:reset-name "reset")
		     (:options '())
		     (:method #f) . exp)
   (if (not (list? options))
       (error "form" "Illegal options" options)
       (for-each (lambda (opt)
		    (match-case opt
		       (((? string?) (? string?))
			#t)
		       (else
			(error "form" "Illegal options" options))))
		 options))
   (instantiate::%form
      (url url)
      (method method) 
      (submit submit)
      (reset reset)
      (submit-name submit-name)
      (reset-name reset-name)
      (body (append (map (lambda (option)
			    (hidden :name (car option) (cadr option)))
			 options)
		    exp))))

;*---------------------------------------------------------------------*/
;*    label ...                                                        */
;*---------------------------------------------------------------------*/
(define-markup (label . exp)
   (instantiate::%label
      (name "alabel")
      (body exp)))

;*---------------------------------------------------------------------*/
;*    button ...                                                       */
;*---------------------------------------------------------------------*/
(define-markup (button :name . exp)
   (instantiate::%button
      (name name)
      (body exp)))

;*---------------------------------------------------------------------*/
;*    checkbutton ...                                                  */
;*---------------------------------------------------------------------*/
(define-markup (checkbutton :name . exp)
   (instantiate::%checkbutton
      (name name)
      (body exp)))

;*---------------------------------------------------------------------*/
;*    radio ...                                                        */
;*---------------------------------------------------------------------*/
(define-markup (radio :name
		      (:orientation 'horizontal)
		      (:value #f)
		      . values)
   (instantiate::%radio
      (name name)
      (orientation orientation)
      (value value)
      (body (map (lambda (v)
		      (if (string? v)
			  (list v v)
			  (match-case v
			     (((and (? string?) ?k) ?-)
			      v)
			     (else
			      (error "radio" "Illegal value" v)))))
		 values))))
		   
;*---------------------------------------------------------------------*/
;*    entry ...                                                        */
;*---------------------------------------------------------------------*/
(define-markup (entry :name (:width 40) . exp)
   (instantiate::%entry
      (name name)
      (width width)
      (default (if (and (pair? exp) (string? (car exp)))
		   (car exp)
		   #f))))
   
;*---------------------------------------------------------------------*/
;*    password ...                                                     */
;*---------------------------------------------------------------------*/
(define-markup (password :name (:width 20))
   (instantiate::%passwd
      (name name)
      (width width)))
   
;*---------------------------------------------------------------------*/
;*    text ...                                                         */
;*---------------------------------------------------------------------*/
(define-markup (text :name (:cols 40) (:rows 20) (:read-only #f). exp)
   (instantiate::%editor
      (name name)
      (cols cols)
      (rows rows)
      (ronly read-only)
      (body exp)))

;*---------------------------------------------------------------------*/
;*    fileselector ...                                                 */
;*---------------------------------------------------------------------*/
(define-markup (fileselector :name (:width 40) . exp)
   (instantiate::%fileselector
      (width width)
      (name name)))

;*---------------------------------------------------------------------*/
;*    listbox ...                                                      */
;*---------------------------------------------------------------------*/
(define-markup (listbox :name (:height 10) (:selected-items '()) . exp)
   (instantiate::%listbox
      (name name)
      (height height)
      (selected-items selected-items)
      (items exp)))

;*---------------------------------------------------------------------*/
;*    combobox ...                                                     */
;*---------------------------------------------------------------------*/
(define-markup (combobox :name (:selected-item #f) . exp)
   (instantiate::%combobox
      (name name)
      (selected-item selected-item)
      (items exp)))

;*---------------------------------------------------------------------*/
;*    hidden ...                                                       */
;*---------------------------------------------------------------------*/
(define-markup (hidden :name . exp)
   (instantiate::%hidden
      (name name)
      (body exp)))
