;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeapi/ast.scm                    */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Sep 23 14:52:06 2001                          */
;*    Last change :  Mon Jan 14 14:53:34 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The AST representing the scribe program                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribeapi_ast
   
   (export (abstract-class %node
	      (loc read-only (default (evmeaning-location))))
	   
	   ;; node with an associated user text
	   (abstract-class %text::%node
	      (body (default #unspecified)))
	   
	   ;; a text that holds some blocks
	   (abstract-class %container::%text
	      ;; the contained children
	      (children::pair-nil (default '()))
	      ;; the stamp used for references
	      (stamp::symbol read-only (default (gensym 'container))))
	   
	   ;; document
	   (class %document::%container
	      ;; the facultative file where to produce the output
	      (file (default #f))
	      ;; the title of the document
	      (title read-only)
	      ;; the authors list of the document
	      (authors::pair-nil read-only)
	      ;; chapters
	      (chapters (default #unspecified))
	      ;; sections
	      (sections (default #unspecified))
	      ;; sections*
	      (sections* (default #unspecified))
	      ;; anchor-table
	      (mark-table (default (make-hashtable)))
	      ;; footnotes
	      (footnotes::pair-nil (default '())))
	   
	   ;; the abstract class denoting an container that is not
	   ;; a document
	   (abstract-class %block::%container
	      (parent (default #f))
	      (toc read-only (default #t))
	      (number (default #t))
	      ;; tmp-mark
	      (tmp-marks-list (default '()))
	      ;; tmp-footnote
	      (tmp-footnotes-list (default '())))
	   
	   ;; chapter
	   (class %chapter::%block
	      ;; the facultative file where to produce the output
	      (file (default #f))
	      ;; the title of the document
	      (title read-only)
	      ;; the subtitle if the chapter title is built from the
	      ;; document title
	      (subtitle read-only (default #f))
	      ;; sections
	      (sections (default #unspecified))
	      ;; footnotes
	      (footnotes::pair-nil (default '())))
	   
	   ;; section
	   (class %section::%block
	      (title read-only)
	      (subsections (default #unspecified)))
	   
	   ;; subsection
	   (class %subsection::%block
	      (title read-only)
	      (subsubsections (default #unspecified)))
	   
	   ;; subsubsection
	   (class %subsubsection::%block
	      (title read-only))
	   
	   ;; paragraph
	   (class %paragraph::%block)
	   
	   ;; table of contents
	   (class %toc::%block
	      (chapter read-only (default #t))
	      (section read-only (default #t)))

	   ;; ornament
	   (abstract-class %ornament::%text)
	   
	   ;; bold
	   (class %bold::%ornament)
	   
	   ;; underline
	   (class %underline::%ornament)
	   
	   ;; emphasize
	   (class %emph::%ornament)
	   
	   ;; italic
	   (class %it::%ornament)
	   
	   ;; typewriter
	   (class %tt::%ornament)
	   
	   ;; source code
	   (class %code::%ornament)
	   
	   ;; sample
	   (class %samp::%ornament)
	   
	   ;; source variable
	   (class %var::%ornament)
	   
	   ;; smallcaps
	   (class %sc::%ornament)
	   
	   ;; subscripts
	   (class %sub::%ornament)
	   
	   ;; superscripts
	   (class %sup::%ornament)
	   
	   ;; space sensitive
	   (class %pre::%ornament)
	   
	   ;; keyboard representation
	   (class %kbd::%ornament)
	   
	   ;; fontification
	   (class %font::%ornament
	      (face read-only)
	      (size read-only))
	   
	   ;; reference
	   (abstract-class %reference::%text
	      (anchor read-only (default #f)))
	   
	   ;; url-ref
	   (class %url-ref::%reference
	      (url read-only (default #f)))
	   
	   ;; unknown-ref
	   (class %unknown-ref::%reference)
	   
	   ;; chapter-ref
	   (class %chapter-ref::%reference)
	   
	   ;; section-ref
	   (class %section-ref::%reference)
	   
	   ;; subsection-ref
	   (class %subsection-ref::%reference)
	   
	   ;; subsubsection-ref
	   (class %subsubsection-ref::%reference)
	   
	   ;; mark-ref
	   (class %mark-ref::%reference)
	   
	   ;; biblio-ref
	   (class %biblio-ref::%reference)
	   
	   ;; hook
	   (class %hook::%text
	      (before read-only (default #f))
	      (after read-only (default #f))
	      (process::bool read-only (default #f)))
	   
	   ;; foonote
	   (class %footnote::%text
	      (id::symbol read-only (default (gensym 'footnote)))
	      note
	      (parent (default #f))
	      (number (default 0)))
	   
	   ;; figure
	   (class %figure::%text
	      legend
	      (number (default 0)))
	   
	   ;; mailto
	   (class %mailto::%text
	      (email read-only (default #f)))
	   
	   ;; special
	   (abstract-class %special::%node)
	   
	   ;; atom
	   (class %atom::%special
	      (value read-only))
	   
	   ;; %character
	   (class %character::%special
	      (value read-only))
	   
	   ;; hrule
	   (class %hrule::%special
	      (width read-only (default 1.))
	      (height::int read-only (default -1)))
	   
	   ;; linebreak
	   (class %linebreak::%special
	      (repetition::int read-only (default 1)))

	   ;; image
	   (class %image::%text
	      (file read-only)
	      (width read-only)
	      (height read-only)
	      (zoom read-only))
	   
	   ;; author
	   (class %author::%special
	      (name read-only)
	      (affiliation read-only (default #f))
	      (email read-only (default #f))
	      (url read-only (default #f))
	      (address read-only (default #f))
	      (phone read-only (default #f))
	      (photo read-only (default #f)))
	   
	   ;; list
	   (abstract-class %list::%node
	      (items::pair-nil read-only))
	   
	   ;; itemize
	   (class %itemize::%list)
	   
	   ;; description
	   (class %description::%list)
	   
	   ;; enumerate
	   (class %enumerate::%list)

	   ;; item
	   (class %item::%text
	      (value read-only (default '())))
	   
	   ;; boxes
	   (abstract-class %box::%text
	      (width read-only (default #f))
	      (margin read-only (default #f)))
	   
	   ;; color
	   (class %color::%box
	      (fg read-only)
	      (bg read-only))
	   
	   ;; frame
	   (class %frame::%box
	      (border-width::int (default 1)))
	   
	   ;; table
	   (class %table::%node
	      (border read-only (default #f))
	      (width read-only (default #f))
	      (cellpadding read-only (default 0))
	      (rows::pair read-only)
	      (nbcols::int read-only
			   (get (lambda (t)
				   (%table-nb-columns t)))))
	   
	   ;; table-row
	   (class %table-row::%node
	      (bg read-only (default #f))
	      (cells::pair-nil read-only))
	   
	   ;; table-cell
	   (abstract-class %table-cell::%text
	      (rowspan::int read-only (default 1))
	      (colspan::int read-only (default 1))
	      (width read-only (default #f))
	      (align read-only (default 'center))
	      (valign read-only (default 'top))
	      (bg read-only (default #f)))
	   
	   ;; table-header
	   (class %table-header::%table-cell)
	   
	   ;; table-data
	   (class %table-data::%table-cell)
	   
	   ;; layout
	   (abstract-class %layout::%text)
	   
	   ;; margin
	   (class %margin::%layout
	      (bg read-only (default #f))
	      (tbg read-only (default #f))
	      (tfg read-only (default #f))
	      (width read-only (default #f)))
	   
	   ;; center
	   (class %center::%layout)
	   
	   ;; flush
	   (class %flush::%layout
	      (side::symbol read-only))
	   
	   ;; anchor
	   (abstract-class %anchor::%node
	      (id read-only (default #f))
	      (parent (default #f)))
	   
	   ;; mark
	   (class %mark::%anchor)
	   
	   ;; index
	   (class %index::%mark
	      (note read-only (default #f))
	      (name read-only (default #f))
	      (shape read-only (default #f)))

	   ;; bibentry
	   (class %bibentry::%mark
	      (stamp::symbol read-only (default (gensym 'bibentry)))
	      (kind::symbol read-only)
	      (fields::pair read-only)
	      (number::int (default 0)))))

;*---------------------------------------------------------------------*/
;*    %table-nb-columns ...                                            */
;*    -------------------------------------------------------------    */
;*    This function computes how columns are contained by the table.   */
;*---------------------------------------------------------------------*/
(define (%table-nb-columns t::%table)
   (define (row-columns row)
      (let loop ((cells (%table-row-cells row))
		 (nbcols 0))
	 (if (null? cells)
	     nbcols
	     (loop (cdr cells)
		   (+fx nbcols (%table-cell-colspan (car cells)))))))
   (let loop ((rows (%table-rows t))
	      (nbcols 0))
      (if (null? rows)
	  nbcols
	  (loop (cdr rows)
		(max (row-columns (car rows)) nbcols)))))
