/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io;

import com.sun.midp.io.ConnectionBaseAdapter;
import java.io.IOException;
import java.io.InputStream;

class BaseInputStream
extends InputStream {
    private ConnectionBaseAdapter parent;
    int bytesAvailable = 0;
    byte[] available = new byte[1];
    byte[] buf = new byte[1];

    BaseInputStream(ConnectionBaseAdapter parent) throws IOException {
        this.parent = parent;
    }

    private void ensureOpen() throws IOException {
        if (this.parent == null) {
            throw new IOException("Stream closed");
        }
    }

    public int available() throws IOException {
        this.ensureOpen();
        if (this.bytesAvailable > 0) {
            return this.bytesAvailable;
        }
        this.bytesAvailable = this.parent.readBytesNonBlocking(this.available, 0, this.available.length);
        return this.bytesAvailable;
    }

    public int read() throws IOException {
        if (this.read(this.buf, 0, 1) > 0) {
            return this.buf[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesToCopy = 0;
        this.ensureOpen();
        if (len == 0) {
            return 0;
        }
        int test = b[off] + b[len - 1] + b[off + len - 1];
        if (this.bytesAvailable == 0) {
            return this.parent.readBytes(b, off, len);
        }
        bytesToCopy = len < this.bytesAvailable ? len : this.bytesAvailable;
        System.arraycopy(this.available, 0, b, off, bytesToCopy);
        this.bytesAvailable -= bytesToCopy;
        if ((len -= bytesToCopy) == 0) {
            return bytesToCopy;
        }
        return this.parent.readBytesNonBlocking(b, off + bytesToCopy, len) + bytesToCopy;
    }

    public void close() throws IOException {
        if (this.parent != null) {
            --this.parent.iStreams;
            this.parent.closeCommon();
            this.parent = null;
        }
    }
}

