/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kssl;

import com.sun.kssl.Utils;

class Session {
    private static final byte MAX_SESSIONS = 4;
    private static int delIdx = 0;
    private String host;
    private int port = 0;
    private byte[] Id = null;
    private byte[] master = null;
    private static Session[] sessions = new Session[4];

    Session() {
    }

    static byte[] getSId(String h, int p) {
        int i = 0;
        while (i < 4) {
            if (sessions[i] != null && Session.sessions[i].Id != null && Session.sessions[i].host.compareTo(h) == 0 && Session.sessions[i].port == p) {
                byte[] sid = new byte[Session.sessions[i].Id.length];
                System.arraycopy(Session.sessions[i].Id, 0, sid, 0, sid.length);
                return sid;
            }
            ++i;
        }
        return null;
    }

    static byte[] getMaster(String h, int p, byte[] sid) {
        int i = 0;
        while (i < 4) {
            if (sessions[i] != null && Session.sessions[i].Id != null && Utils.byteMatch(Session.sessions[i].Id, 0, sid, 0, sid.length) && Session.sessions[i].host.compareTo(h) == 0 && Session.sessions[i].port == p) {
                byte[] m = new byte[Session.sessions[i].master.length];
                System.arraycopy(Session.sessions[i].master, 0, m, 0, m.length);
                return m;
            }
            ++i;
        }
        return null;
    }

    static void add(String h, int p, byte[] id, byte[] mas) {
        int idx = 4;
        int i = 0;
        while (i < 4) {
            if (sessions[i] == null || Session.sessions[i].Id == null) {
                idx = i;
            } else if (Session.sessions[i].host.compareTo(h) == 0 && Session.sessions[i].port == p) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx == 4) {
            idx = delIdx++;
            if (delIdx == 4) {
                delIdx = 0;
            }
        }
        if (sessions[idx] == null) {
            Session.sessions[idx] = new Session();
        }
        Session.sessions[idx].Id = new byte[id.length];
        System.arraycopy(id, 0, Session.sessions[idx].Id, 0, id.length);
        Session.sessions[idx].master = new byte[mas.length];
        System.arraycopy(mas, 0, Session.sessions[idx].master, 0, mas.length);
        Session.sessions[idx].host = new String(h);
        Session.sessions[idx].port = p;
    }

    static void del(String h, int p, byte[] sid) {
        int i = 0;
        while (i < 4) {
            if (sessions[i] != null && Session.sessions[i].Id != null && Utils.byteMatch(Session.sessions[i].Id, 0, sid, 0, sid.length) && Session.sessions[i].host.compareTo(h) == 0 && Session.sessions[i].port == p) {
                Session.sessions[i].Id = null;
                break;
            }
            ++i;
        }
    }
}

