/*
 * Decompiled with CFR 0.152.
 */
package vizant;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import vizant.VizProject;
import vizant.VizProjectLoader;
import vizant.VizReference;
import vizant.VizTarget;

public class VizProjectLoaderImpl
implements VizProjectLoader {
    private InputStream stream;
    private boolean uniqueref = false;
    private boolean ignoreAnt = false;
    private boolean ignoreAntcall = false;
    private boolean ignoreDepends = false;

    public void uniqueRef(boolean bl) {
        this.uniqueref = bl;
    }

    public void ignoreAnt(boolean bl) {
        this.ignoreAnt = bl;
    }

    public void ignoreAntcall(boolean bl) {
        this.ignoreAntcall = bl;
    }

    public void ignoreDepends(boolean bl) {
        this.ignoreDepends = bl;
    }

    public void setInputStream(InputStream inputStream) {
        this.stream = inputStream;
    }

    public Vector getProjects() throws BuildException {
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            SAXHandler sAXHandler = new SAXHandler();
            sAXParser.parse(new InputSource(this.stream), (DefaultHandler)sAXHandler);
            return sAXHandler.getProjects();
        }
        catch (SAXException sAXException) {
            throw new BuildException((Throwable)sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new BuildException((Throwable)parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }

    private class SAXHandler
    extends DefaultHandler {
        private String defaultName = "main";
        private Vector projects;
        private VizTarget target;
        private VizProject baseProject = new VizProject();

        public Vector getProjects() {
            return this.projects;
        }

        public void startDocument() {
            this.projects = new Vector();
            this.projects.addElement(this.baseProject);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ("project".equals(string3)) {
                String string4 = attributes.getValue("default");
                String string5 = attributes.getValue("dir");
                if (string4 != null) {
                    this.defaultName = string4;
                }
                if (string5 != null) {
                    this.baseProject.setDir(string5);
                }
            } else if ("target".equals(string3)) {
                String string6 = attributes.getValue("name");
                String string7 = attributes.getValue("depends");
                this.target = this.baseProject.getTarget(string6);
                this.target.setDefault(string6.equals(this.defaultName));
                this.baseProject.appendTarget(this.target);
                if (null != string7 && !VizProjectLoaderImpl.this.ignoreDepends) {
                    this.addDepends(this.target, string7);
                }
            } else if ("antcall".equals(string3)) {
                if (!VizProjectLoaderImpl.this.ignoreAntcall) {
                    this.addAntCall(this.target, attributes.getValue("target"));
                }
            } else if ("ant".equals(string3) && !VizProjectLoaderImpl.this.ignoreAnt) {
                this.addAnt(this.target, attributes.getValue("dir"), attributes.getValue("antfile"), attributes.getValue("target"));
            }
        }

        private void addReference(VizTarget vizTarget, VizTarget vizTarget2, int n) {
            VizReference vizReference = new VizReference();
            vizReference.setFrom(vizTarget);
            vizReference.setTo(vizTarget2);
            vizReference.setType(n);
            vizTarget.addReferenceOut(vizReference, VizProjectLoaderImpl.this.uniqueref);
            vizTarget2.addReferenceIn(vizReference, VizProjectLoaderImpl.this.uniqueref);
        }

        private void addDepends(VizTarget vizTarget, String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                VizTarget vizTarget2 = this.baseProject.getTarget(stringTokenizer.nextToken().trim());
                this.addReference(vizTarget, vizTarget2, 0);
            }
        }

        private void addAntCall(VizTarget vizTarget, String string) {
            VizTarget vizTarget2 = this.baseProject.getTarget(string);
            this.addReference(vizTarget, vizTarget2, 1);
        }

        private void addAnt(VizTarget vizTarget, String string, String string2, String string3) {
            string = string != null ? string : "";
            string2 = string2 != null ? string2 : "";
            string3 = string3 != null ? string3 : "";
            VizProject vizProject = this.getProject(string, string2);
            VizTarget vizTarget2 = vizProject.getTarget(string3);
            if ("".equals(string3)) {
                vizTarget2.setDefault(true);
            }
            vizProject.appendTarget(vizTarget2);
            this.addReference(vizTarget, vizTarget2, 2);
        }

        private VizProject getProject(String string, String string2) {
            VizProject vizProject;
            Enumeration enumeration = this.projects.elements();
            while (enumeration.hasMoreElements()) {
                vizProject = (VizProject)enumeration.nextElement();
                if (!string.equals(vizProject.getDir()) || !string2.equals(vizProject.getFile())) continue;
                return vizProject;
            }
            vizProject = new VizProject();
            vizProject.setDir(string);
            vizProject.setFile(string2);
            this.projects.addElement(vizProject);
            return vizProject;
        }
    }
}

