/* 
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Sablotron XSLT Processor.
 * 
 * The Initial Developer of the Original Code is Ginger Alliance Ltd.
 * Portions created by Ginger Alliance are Copyright (C) 2000 Ginger
 * Alliance Ltd. All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL"), in which case the provisions of the GPL are applicable 
 * instead of those above.  If you wish to allow use of your 
 * version of this file only under the terms of the GPL and not to
 * allow others to use your version of this file under the MPL,
 * indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by
 * the GPL.  If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */

#ifndef JSDOMHIncl
#define JSDOMHIncl

#include "base.h"
#include "jsext.h"


#define JS_METHOD(name) JSBool name(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
#define JS_PROP(name) JSBool name(JSContext *cx, JSObject *obj, jsval id, jsval *rval)

#define PROP_OPT  JSPROP_ENUMERATE | JSPROP_READONLY | JSPROP_PERMANENT

#define DOM_EX(stmt) if (int c = stmt) {jsdom_raiseException(cx, c); return FALSE;}


struct NodePrivate
{
  Situation *situa;
  NodeHandle node;
};

struct DomExPrivate
{
  int code;
};

struct NLPrivate
{
  JSObject_Sab *array;
};

/* classes */
#ifdef HAVE_JSAPI_H
extern JSClass nlistClass;
extern JSClass nodeClass;

/* functions */
void jsdom_delegateDOM(JSContext *cx);
JSObject *jsdom_wrapNode(Sit S, JSContext *cx, NodeHandle node);
JSObject *jsdom_createNode(JSContext *cx, NodePrivate *np_, NodeHandle node);
void jsdom_raiseException(JSContext *cx, int code);
JSObject *jsdom_createNodeList(JSContext *cx, int num);
JSObject *jsdom_createNamedNodeMap(JSContext *cx, int num);
#endif
//have jsapi.h

#endif //JSDOMHIncl
