// This is a roxen module. Copyright  2000 - 2004, Roxen IS.

inherit "module";

constant cvs_version = "$Id: whitespace_remover.pike,v 1.3 2004/06/30 16:59:02 mast Exp $";
constant thread_safe = 1;
constant module_type = MODULE_FILTER;
constant module_name = "Whitespace Remover";
constant module_doc  = "Removes all whitespace from pages.";

void create() {

  defvar("comment",
	 Variable.Flag(0, 0, "Strip HTML comments",
		       "Removes all &lt;!-- --&gt; type of comments") );
  defvar("verbatim",
	 Variable.StringList( ({ "pre", "textarea", "script", "style",
				 "code" }),
			      0, "Verbatim tags",
			      "Whitespace stripping is not performed on the "
			      "contents of these tags." ) );
}

int gain;

string status()
{
  return sprintf("<b>%d bytes</b> have been dropped.", gain);
}

static string most_significant_whitespace(string ws)
{
  int size = sizeof( ws );
  if( size )
    gain += size-1;
  return !size ? "" : has_value(ws, "\n") ? "\n"
		    : has_value(ws, "\t") ? "\t" : " ";
}

static array(string) remove_consecutive_whitespace(Parser.HTML p, string in)
{
  sscanf(in, "%{%[ \t\r\n]%[^ \t\r\n]%}", array ws_nws);
  if(sizeof(ws_nws))
  {
    ws_nws = Array.transpose( ws_nws );
    ws_nws[0] = map(ws_nws[0], most_significant_whitespace);
  }
  return ({ Array.transpose( ws_nws ) * ({}) * "" });
}

array(string) verbatim(Parser.HTML p, mapping(string:string) args, string c) {
  return ({ p->current() });
}

mapping filter(mapping result, RequestID id)
{
  if(!result
  || !has_prefix(result->type||"", "text/html")
  || (id->misc->moreheads && id->misc->moreheads["Content-Type"] &&
      id->misc->moreheads["Content-Type"] != "text/html")
  || !stringp(result->data)
  || id->prestate->keepws
  || id->misc->ws_filtered++)
    return 0;

  Parser.HTML parser = Parser.HTML();
  foreach(query("verbatim"), string tag)
    parser->add_container( tag, verbatim );
  parser->add_quote_tag("!--", query("comment")&&"", "--");
  parser->_set_data_callback( remove_consecutive_whitespace );
  result->data = parser->finish( result->data )->read();
  return result;
}
