/*
 *  Copyright (C) 2002 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "rfbClient.h"

#include <iostream>
#include <fstream>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>

#include "d3des.h"

#include "version.h"

#define DEBUG

#ifdef DEBUG
#include <iostream>
#define debug(msg) (cerr << msg << endl)
#else // DEBUG
#define debug(msg)
#endif // DEBUG


#include "FBStreamRecorder.h"


int doConnect( char *hostname, int port );


namespace rfb {

class rfbcat: public Client
{
  public:
    rfbcat( Connection *_connection );
    virtual ~rfbcat();

    virtual void handleProtocolVersion( ProtocolVersion &protocolVersion );
    virtual void handleVNCAuthentication( CARD8 challenge[16] );
    virtual void handleAuthenticated();
    virtual void handleAuthenticationFailed();
    virtual void handleServerInitialisation( ServerInitialisation &serverInitialisation );
    virtual void handleFramebufferUpdateCompleted( FramebufferUpdate &framebufferUpdate );
    
    int frame_index;
    FBStreamRecorder *recorder;
};




rfbcat::rfbcat( Connection *_connection )
  : Client()
{
  framebuffer = NULL;
  connection = _connection;
  frame_index = 0;
  recorder = new FBStreamRecorder();
}



rfbcat::~rfbcat()
{
}


void rfbcat::handleProtocolVersion( ProtocolVersion &protocolVersion )
{
  Client::handleProtocolVersion( protocolVersion );
  protocolVersion[12] = 0;
}



void rfbcat::handleServerInitialisation( ServerInitialisation &serverInitialisation )
{
  Client::handleServerInitialisation( serverInitialisation );

  framebuffer = new Framebuffer();
  framebuffer->pixelFormat = serverInitialisation.server_pixel_format;
  framebuffer->width = serverInitialisation.framebuffer_width;
  framebuffer->height = serverInitialisation.framebuffer_height;
  framebuffer->bytesPerLine = serverInitialisation.framebuffer_width
                            * ((framebuffer->pixelFormat.bits_per_pixel + 7) / 8);
  framebuffer->data = (unsigned char*) malloc( framebuffer->bytesPerLine
                                             * framebuffer->height );

  { 
    struct {
      CARD8 message_type;
      CARD8 padding;
      CARD16 number_of_encodings;
      CARD32 preferredEncoding;
      CARD32 copyRect;
    } Encodings;
    Encodings.message_type = 2;
    Encodings.number_of_encodings = 2;
    Encodings.preferredEncoding = 5;
    Encodings.copyRect = 1;
    connection->send( (unsigned char*) &Encodings, 12 );
  }
 
  {
    MessageFramebufferUpdateRequest message;
    message.message_type = 3;
    message.framebufferUpdateRequest.incremental = 0;
    message.framebufferUpdateRequest.x_position = 0;
    message.framebufferUpdateRequest.y_position = 0;
    message.framebufferUpdateRequest.width = serverInitialisation.framebuffer_width;
    message.framebufferUpdateRequest.height = serverInitialisation.framebuffer_height;
    connection->send( (unsigned char*) &message, 10 );
  }
}



void rfbcat::handleFramebufferUpdateCompleted( FramebufferUpdate &framebufferUpdate )
{
  saveFramebufferAsPPM( 1, framebuffer );
  exit( 1 );
  Client::handleFramebufferUpdateCompleted( framebufferUpdate );
  frame_index++;
  recorder->startTimer();
}


void rfbcat::handleVNCAuthentication( CARD8 challenge[16] )
{
    char key[16] = "\0\0\0\0\0\0\0\0";

    char *passwd = getpass("Password: ");
    if ((!passwd) || (strlen(passwd) == 0)) {
      delete this;
    }
    if (strlen(passwd) > 8) {
      passwd[8] = '\0';
    }
    strcpy(key,passwd);

    unsigned char response[16];

    deskey( (unsigned char*) key, EN0 );
    des( challenge, response );
    des( challenge+8, response+8 );

    connection->send( response, 16 );
}


void rfbcat::handleAuthenticationFailed()
{
  cerr << "WRONG PASSWORD" << endl;
  exit( 1 );
}



void rfbcat::handleAuthenticated()
{
  ClientInitialisation message;
  message.shared_flag = 1;
  connection->send( (unsigned char*) &message, 1 );
  currentState = &stateInitialisation;
}


} // namespace _003_003


void printVersion_xrfbviewer()
{
  cerr << endl << "heXoNet RFB viewer for the X Window System"
       << endl << "Version " << VERSION_xrfbviewer
       << endl;
}

void printHelp_xrfbviewer()
{
  printVersion_xrfbviewer();
  cerr 
    << endl
    << "usage: rfbcat [options] [host]:<display>" << endl
    << "       rfbcat [options] -fbs <file>" << endl
    << "       rfbcat [options] -rfb <file>" << endl
    << endl
    << "       -o <file>   default is -o - for STDOUT" << endl
    << "       -x <program>" << endl
    << "       -f <format> format ::= PPM | RFB | FBS"  << endl
    << "                   default is PPM"  << endl
    << "       -d <delay> delay in ms"  << endl
    << endl
    << "<options>" << endl
    << "       -shared" << endl
    << "       -viewonly" << endl
    << "       -bgr233 | -spf" << endl
    << "       -scale <num>/<denum>" << endl;
  ;
  exit( 1 );
}


void parseCommandLine_xrfbviewer( int argc, char **argv )
{
  int i = 1;
  while ( i < argc ) {

    if ( !strcmp( argv[i], "-help" ) ) {
      printHelp_xrfbviewer();
    } else

    if ( !strcmp( argv[i], "-listen" ) ) {
      i++;
    }
  }
}




int main( int argc, char **argv ) {

  char hostname[255] = "localhost";
  int display = 0;

  int i = 1;
  while ( i < argc ) {
      if ( argv[i][0] != '-' ) {
        char *pos = strstr( argv[i], ":" );
        if ( pos ) {
          if ( pos != argv[i] ) {
              strncpy( hostname, argv[i], pos - argv[i] );
              hostname[pos - argv[i]] = 0;
          }
          display = atoi(pos+1);
        } else {
          strcpy( hostname, argv[i] );
        }
      }
      i++;
  }
  int fd = doConnect(hostname, (display>100)? display : 5900+display );
  if ( fd <= 0 ) exit(1);

  BufferedConnection *c = new BufferedConnection();
  rfb::rfbcat r(c);

  while (1) {

    int writeSize = c->senderBuffer.end - c->senderBuffer.pos;
    if ( writeSize > 0 ) {
      int bytesWritten =
        write( fd,
               c->senderBuffer.data + c->senderBuffer.pos,
               writeSize );
        c->senderBuffer.pos += bytesWritten;
    }

    int readSize = c->receiverBuffer.size - c->receiverBuffer.end;
    int bytesRead;
    bytesRead = read( fd,
                      c->receiverBuffer.data + c->receiverBuffer.end,
                      readSize );
    if ( bytesRead <= 0 ) exit(1);
    c->receiverBuffer.end += bytesRead;
    while ( c->hasReceiverBufferData() ) r.update();
    c->receiverBuffer.end = 0;
    c->receiverBuffer.pos = 0;
  }
  
  return 0;
}





void init_sockaddr (struct sockaddr_in *name, const char *hostname, uint16_t port)
{
  struct hostent *hostinfo;
  
  name->sin_family = AF_INET;
  name->sin_port = htons (port);
  hostinfo = gethostbyname (hostname);
  if (hostinfo == NULL)
    {
      printf( "Error\n" );
      exit (EXIT_FAILURE);
    }
  name->sin_addr = *(struct in_addr *) hostinfo->h_addr;
}


int doConnect( char *hostname, int port )
{
    struct sockaddr_in name;
    
    int s = socket( PF_INET, SOCK_STREAM, 0 );

    init_sockaddr( &name, hostname, port );

    if ( connect( s, (struct sockaddr*) &name, sizeof( name ) ) ) {
        printf( "connect Error\n" );
    }

    int one = 1;
    setsockopt(s, IPPROTO_TCP, TCP_NODELAY, (char *)&one, sizeof(one));
//    fcntl(s, F_SETFL, O_NONBLOCK);

    return s;
}




