/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "PixelFormatFramebuffer.h"
#include <stdlib.h>

namespace rfb {

PixelFormatFramebuffer::PixelFormatFramebuffer( Framebuffer & _fb,
                                                PixelFormat & _pixelFormat )
    {
      fb = &_fb;
      width = fb->width;
      height = fb->height;
      pixelFormat = _pixelFormat;
      bytesPerLine = (pixelFormat.bits_per_pixel >> 3) * width;
      data = (unsigned char*) malloc( bytesPerLine * height );
      if ( pixelFormat.bits_per_pixel == 8 ) {
        unsigned int i;
        colourTable = (CARD32 *) malloc( 256 * 4 );
        for ( i = 0; i < 256; i++) {
          unsigned int red = pixelFormat.red_max & (i >> pixelFormat.red_shift);
          unsigned int green = pixelFormat.green_max & (i >> pixelFormat.green_shift);
          unsigned int blue = pixelFormat.blue_max & (i >> pixelFormat.blue_shift);
          red = (red * fb->pixelFormat.red_max / pixelFormat.red_max) << fb->pixelFormat.red_shift;
          green = (green * fb->pixelFormat.green_max / pixelFormat.green_max) << fb->pixelFormat.green_shift;
          blue = (blue * fb->pixelFormat.blue_max / pixelFormat.blue_max) << fb->pixelFormat.blue_shift;
          colourTable[i] = red | green | blue;
        }
      }
      if ( pixelFormat.bits_per_pixel == 16 ) {
        unsigned int i;
        colourTable = (CARD32 *) malloc( 65536 * 4 );
        for ( i = 0; i < 65536; i++) {
          unsigned int red = pixelFormat.red_max & (i >> pixelFormat.red_shift);
          unsigned int green = pixelFormat.green_max & (i >> pixelFormat.green_shift);
          unsigned int blue = pixelFormat.blue_max & (i >> pixelFormat.blue_shift);
          red = (red * fb->pixelFormat.red_max / pixelFormat.red_max) << fb->pixelFormat.red_shift;
          green = (green * fb->pixelFormat.green_max / pixelFormat.green_max) << fb->pixelFormat.green_shift;
          blue = (blue * fb->pixelFormat.blue_max / pixelFormat.blue_max) << fb->pixelFormat.blue_shift;
          colourTable[i] = red | green | blue;
        }
      }
    }


void PixelFormatFramebuffer::update( unsigned int _x,
                                     unsigned int _y,
                                     unsigned int _w,
                                     unsigned int _h
                                   )
{
  unsigned int x, y;
 if ( pixelFormat.bits_per_pixel == 8 )
  for ( y = _y; y < _y + _h; y++ ) {
    for ( x = _x; x < _x + _w; x++ ) {
      switch ( fb->pixelFormat.bits_per_pixel ) {
        case 8: fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) ]
                  = colourTable[ data[ y * bytesPerLine + x ] ].value[3];
                break;
        case 16: fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) ]
                   = colourTable[ data[ y * bytesPerLine + x ] ].value[3];
                 fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) +1 ]
                   = colourTable[ data[ y * bytesPerLine + x ] ].value[2];
                 break;
        case 24: fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) ]
                   = colourTable[ data[ y * bytesPerLine + x ] ].value[3];
                 fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) +1 ]
                   = colourTable[ data[ y * bytesPerLine + x ] ].value[2];
                 fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) +2 ]
                   = colourTable[ data[ y * bytesPerLine + x ] ].value[1];
                 break;
        case 32: fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) ]
                   = colourTable[ data[ y * bytesPerLine + x ] ].value[3];
                 fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) +1 ]
                   = colourTable[ data[ y * bytesPerLine + x ] ].value[2];
                 fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) +2 ]
                   = colourTable[ data[ y * bytesPerLine + x ] ].value[1];
                 fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) +3 ]
                   = colourTable[ data[ y * bytesPerLine + x ] ].value[0];
                 break;
        default: break;
      }
    }
  }
  else
 if ( pixelFormat.bits_per_pixel == 16 )
  for ( y = _y; y < _y + _h; y++ ) {
    for ( x = _x; x < _x + _w; x++ ) {
      switch ( fb->pixelFormat.bits_per_pixel ) {
        case 8: fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) ]
                  = colourTable[ (data[ y*bytesPerLine + 2*x +1 ] << 8) | data[ y*bytesPerLine + 2*x ] ].value[3];
                break;
        case 16: fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) ]
                   = colourTable[ (data[ y*bytesPerLine + 2*x +1 ] << 8) | data[ y*bytesPerLine + 2*x ] ].value[3];
                 fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) +1 ]
                   = colourTable[ (data[ y*bytesPerLine + 2*x +1 ] << 8) | data[ y*bytesPerLine + 2*x ] ].value[2];
                 break;
        case 24: fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) ]
                   = colourTable[ (data[ y*bytesPerLine + 2*x +1 ] << 8) | data[ y*bytesPerLine + 2*x ] ].value[3];
                 fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) +1 ]
                   = colourTable[ (data[ y*bytesPerLine + 2*x +1 ] << 8) | data[ y*bytesPerLine + 2*x ] ].value[2];
                 fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) +2 ]
                   = colourTable[ (data[ y*bytesPerLine + 2*x +1 ] << 8) | data[ y*bytesPerLine + 2*x ] ].value[1];
                 break;
        case 32: fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) ]
                   = colourTable[ (data[ y*bytesPerLine + 2*x +1 ] << 8) | data[ y*bytesPerLine + 2*x ] ].value[3];
                 fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) +1 ]
                   = colourTable[ (data[ y*bytesPerLine + 2*x +1 ] << 8) | data[ y*bytesPerLine + 2*x ] ].value[2];
                 fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) +2 ]
                   = colourTable[ (data[ y*bytesPerLine + 2*x +1 ] << 8) | data[ y*bytesPerLine + 2*x ] ].value[1];
                 fb->data[ y * fb->bytesPerLine + x * (fb->pixelFormat.bits_per_pixel >> 3) +3 ]
                   = colourTable[ (data[ y*bytesPerLine + 2*x +1 ] << 8) | data[ y*bytesPerLine + 2*x ] ].value[0];
                 break;
        default: break;
      }
    }
  }
  fb->update( _x, _y, _w, _h );
}

void PixelFormatFramebuffer::copyRect( unsigned int _destX,
                           unsigned int _destY,
                           unsigned int _width,
                           unsigned int _height,
                           unsigned int _srcX,
                           unsigned int _srcY
                         )
{
  fb->copyRect( _destX, _destY, _width, _height, _srcX, _srcY );
}


}
