#include <iostream>
#include <stdlib.h>
#include <string.h>

#include "Connection.h"


Connection::Connection() {}
Connection::~Connection() {}
int Connection::send( unsigned char* _data, unsigned int _size ) { return -1; }
int Connection::receive( unsigned char* _data, unsigned int _size ) { return -1; }
bool Connection::isAlive() { return true; }



BufferedConnection::BufferedConnection( unsigned int _receiverSize,
                                        unsigned int _senderSize,
                                        unsigned int _senderSizeDelta )
{
  senderBuffer.pos = 0;
  senderBuffer.end = 0;
  senderBuffer.size = _senderSize;
  if ( senderBuffer.size )
    senderBuffer.data = (unsigned char*) malloc( senderBuffer.size );
  else
    senderBuffer.data = NULL;
  receiverBuffer.pos = 0;
  receiverBuffer.end = 0;
  receiverBuffer.size = _receiverSize;
  if ( receiverBuffer.size )
    receiverBuffer.data = (unsigned char*) malloc( receiverBuffer.size );
  else
    receiverBuffer.data = NULL;
  senderSizeDelta = _senderSizeDelta;
}


BufferedConnection::~BufferedConnection()
{
  if ( senderBuffer.data ) free( senderBuffer.data );
  if ( receiverBuffer.data ) free( receiverBuffer.data );
}


int BufferedConnection::send( unsigned char* _data, unsigned int _size )
{
  if ( (senderBuffer.size + senderBuffer.pos - senderBuffer.end) < _size ) {
    if ( !resizeSenderBuffer( senderBuffer.end + _size - senderBuffer.pos ) )
      return -1;
  }
  if ( (senderBuffer.size - senderBuffer.end) < _size ) {
    memmove( senderBuffer.data,
             senderBuffer.data + senderBuffer.pos,
             senderBuffer.end - senderBuffer.pos );
    senderBuffer.end -= senderBuffer.pos;
    senderBuffer.pos = 0;
  }
  memcpy( senderBuffer.data + senderBuffer.end, _data, _size );
  senderBuffer.end += _size;
  return _size;
}


int BufferedConnection::receive( unsigned char* _data, unsigned int _size )
{
  if ( _size > (receiverBuffer.end - receiverBuffer.pos) )
    _size = receiverBuffer.end - receiverBuffer.pos;
  if ( !_size ) return 0;
  memcpy( _data, receiverBuffer.data + receiverBuffer.pos, _size );
  receiverBuffer.pos += _size;
  return _size;
}


bool BufferedConnection::resizeSenderBuffer( unsigned int _senderSize )
{
  void *data = realloc( senderBuffer.data, _senderSize );
  if ( !data ) return false;
  senderBuffer.data = (unsigned char*) data;
  senderBuffer.size = _senderSize;
  return true;
}


bool BufferedConnection::resizeReceiverBuffer( unsigned int _receiverSize )
{
  void *data = realloc( receiverBuffer.data, _receiverSize );
  if ( !data ) return false;
  receiverBuffer.data = (unsigned char*) data;
  receiverBuffer.size = _receiverSize;
  return true;
}

