/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#ifndef _hexonet_rfbClient_h_
#define _hexonet_rfbClient_h_

#include "rfb.h"
#include "Framebuffer.h"
#include "Connection.h"

namespace rfb {

class Client;

class ClientStateReaderBase: public State
{
 public:
  ClientStateReaderBase( Client &_client, unsigned char *_target, unsigned int _size );
  virtual ~ClientStateReaderBase();

  virtual void update();
 
 protected:
   Client *client;
   unsigned char *target;
   unsigned int size;
   unsigned int offset;
};


class ClientStateProtocolVersion: public ClientStateReaderBase
{
 public:
  ClientStateProtocolVersion( Client &client );
  virtual void update();

 protected:
  ProtocolVersion protocolVersion;
};


class ClientStateAuthentication: public ClientStateReaderBase
{
 public:
  ClientStateAuthentication( Client &client );
  virtual void update();

 protected:
  ServerAuthentication serverAuthentication;
};


class ClientStateInitialisation: public ClientStateReaderBase
{
 public:
  ClientStateInitialisation( Client &client );
  virtual void update();

 protected:
  ServerInitialisation serverInitialisation;
};


class ClientStateHandleMessages: public ClientStateReaderBase
{
 public:
  ClientStateHandleMessages( Client &client );
  virtual void update();

  CARD8 message_type;
};


class ClientStateFramebufferUpdate: public ClientStateReaderBase
{
 public:
  ClientStateFramebufferUpdate( Client &client );
  virtual void update();

 protected:
  FramebufferUpdate framebufferUpdate;
  unsigned int remaining_rectangles;
};


class ClientStateDecodingRaw: public ClientStateReaderBase
{
 public:
  ClientStateDecodingRaw( Client &client );
  void startDecoder( Rectangle &rectangle );

  virtual void update();
  
  unsigned int remaining_lines;
};

class ClientStateDecodingCopyRect: public ClientStateReaderBase
{
 public:
  ClientStateDecodingCopyRect( Client &client );
  void startDecoder( Rectangle &_rectangle );

  virtual void update();
  struct {
    CARD16 src_x_position;
    CARD16 src_y_position;
  } data;
  Rectangle rectangle;
};






class ClientStateDecodingRRESubrectangle: public ClientStateReaderBase
{
 public:
  ClientStateDecodingRRESubrectangle( Client &client );
  void startDecoder();

  virtual void update();
  CARD32 subrect_pixel_value;
  int has_subrect_pixel_value;
  struct {
    CARD16 x_position;
    CARD16 y_position;
    CARD16 width;
    CARD16 height;
  } subrectangle;
};


class ClientStateDecodingRRE: public ClientStateReaderBase
{
 public:
  ClientStateDecodingRRE( Client &client );
  void startDecoder( Rectangle &_rectangle );

  virtual void update();
  CARD32 number_of_subrectangles;
  int has_number_of_subrectangles;
  CARD32 background_pixel_value;
  int has_background_pixel_value;
  Rectangle rectangle;
  unsigned int remaining_subrectangles;
  ClientStateDecodingRRESubrectangle stateDecodingRRESubrectangle;
};


class ClientStateDecodingCoRRESubrectangle: public ClientStateReaderBase
{
 public:
  ClientStateDecodingCoRRESubrectangle( Client &client );
  void startDecoder();

  virtual void update();
  CARD32 subrect_pixel_value;
  int has_subrect_pixel_value;
  struct {
    CARD8 x_position;
    CARD8 y_position;
    CARD8 width;
    CARD8 height;
  } subrectangle;
};


class ClientStateDecodingCoRRE: public ClientStateReaderBase
{
 public:
  ClientStateDecodingCoRRE( Client &client );
  void startDecoder( Rectangle &_rectangle );

  virtual void update();
  CARD32 number_of_subrectangles;
  int has_number_of_subrectangles;
  CARD32 background_pixel_value;
  int has_background_pixel_value;
  Rectangle rectangle;
  unsigned int remaining_subrectangles;
  ClientStateDecodingCoRRESubrectangle stateDecodingCoRRESubrectangle;
};




class ClientStateDecodingHextileTile: public ClientStateReaderBase
{
 public:
  ClientStateDecodingHextileTile( Client &client );
  void startDecoder( unsigned int _x,
                     unsigned int _y,
                     unsigned int _width,
                     unsigned int _height 
                   );

  virtual void update();

  unsigned int x, y, width, height;
  CARD8 subencoding_mask;
  int has_subencoding_mask;
  int raw;
  CARD32 background_pixel_value;
  int has_background_pixel_value;
  CARD32 foreground_pixel_value;
  int has_foreground_pixel_value;
  CARD8 number_of_subrectangles;
  int has_number_of_subrectangles;
  unsigned int remaining_subrectangles;
  CARD32 subrect_pixel_value;
  int has_subrect_pixel_value;
  struct {
    CARD8 x_and_y_position;
    CARD8 width_and_height;
  } subrectangle;
};


class ClientStateDecodingHextile: public ClientStateReaderBase
{
 public:
  ClientStateDecodingHextile( Client &client );
  void startDecoder( Rectangle &_rectangle );

  virtual void update();
  Rectangle rectangle;
  unsigned int current_x;
  unsigned int current_y;
  ClientStateDecodingHextileTile stateDecodingHextileTile;
};



class ClientStateReadingRectangle: public ClientStateReaderBase
{
 public:
  ClientStateReadingRectangle( Client &client );
  virtual void update();

 protected:
  Rectangle rectangle;
  friend ClientStateDecodingRaw;
};




class ClientStateCutText: public ClientStateReaderBase
{
 public:
  ClientStateCutText( Client &client );
  void init();
  virtual void update();
 
 protected:
  struct {
    CARD8 padding[3];
    CARD32 length;
  } data;
};




class Client
{
 public:
  Client();
  virtual ~Client();

  virtual void update();
  virtual void handleProtocolVersion( ProtocolVersion &protocolVersion );
  virtual void handleAuthenticated();
  virtual void handleAuthenticationFailed();
  virtual void handleVNCAuthentication( CARD8 challenge[16] );
  virtual void handleServerInitialisation( ServerInitialisation &serverInitialisation );
  virtual void handleFramebufferUpdate( FramebufferUpdate &framebufferUpdate );
  virtual void handleDecodeRectangle( Rectangle &rectangle );
  virtual void handleRectangleDecoded( Rectangle &rectangle );
  virtual void handleFramebufferUpdateCompleted( FramebufferUpdate &framebufferUpdate );
  virtual void handleBell();
  virtual unsigned char* handleServerCutText( CARD32 &length );
  virtual void handleServerCutTextCompleted();

#ifdef USE_ZLIB_WARREN
  virtual void handleZlibEnabled();
#endif // USE_ZLIB_WARREN

#ifdef RFB_PROTOCOL_EXTENSION
  virtual void handleExtension( Data &messageType, Data &message );
#endif

  ClientStateProtocolVersion   stateProtocolVersion;
  ClientStateAuthentication    stateAuthentication;
  ClientStateInitialisation    stateInitialisation;
  ClientStateHandleMessages    stateHandleMessages;
  ClientStateFramebufferUpdate stateFramebufferUpdate;
  ClientStateReadingRectangle  stateReadingRectangle;
  ClientStateCutText           stateCutText;
  ClientStateDecodingRaw       stateDecodingRaw;
  ClientStateDecodingCopyRect  stateDecodingCopyRect;
  ClientStateDecodingRRE       stateDecodingRRE;
  ClientStateDecodingCoRRE     stateDecodingCoRRE;
  ClientStateDecodingHextile   stateDecodingHextile;

  State *currentState;
  
  Connection *connection;
  Framebuffer *framebuffer;
};



}

#endif // _hexonet_rfbClient_h_
