/**/
Call Rxfuncadd 'TkLoadFuncs','rexxtk','TkLoadFuncs'
If TkLoadFuncs() \= 0 Then exit

Call Rxfuncadd 'TkTreeLoadFuncs','rexxtktree','TkTreeLoadFuncs'
If TkTreeLoadFuncs(TkGetBaseData()) \= 0 Then exit

Call Rxfuncadd 'TkComboboxLoadFuncs','rexxtkcombobox','TkComboboxLoadFuncs'
If TkComboboxLoadFuncs(TkGetBaseData()) \= 0 Then exit

Trace o

/* a test Tcl command to see the Tcl interpreter working */
rc = TkTcl('puts','HI')

Say 'You are running' TkVariable('VERSION') 'using Tcl/Tk' TkVar('tk_version')

/* create the main window */
Call CreateMain

/* This is a typical dispatch loop if you set the "command"
   options in the widgets to be a name of a subroutine that
   you write (like below). */
do forever
   /* TkWait returns whatever you typed as the value of the
      "command" option for whatever control is pushed, moved,
      chosen, etc */
   interpret 'call' TkWait()
/*
   rc = TkWait()
   cmd = Word(rc,1)
   args = SubWord(rc,2)
   interpret 'call' cmd '"'args'"'
*/
end

return 0

CreateMain:

   /* 
    * make the main window menu 
    */

   /* make a menu that will be our menubar */
   menubar = TkMenu('.m1')

   /* Add a File menu to the menubar.  The file
      menu will 'cascade' off of the menu bar */

   /* Create another menu widget to be our file menu
      and tell the menubar menu about it... the "tearoff"
      option, well, just remove it and see what happens.*/
   menu = TkMenu('.m1.m1','-tearoff', 0)
   label = 'File'
   call TkAdd menubar, 'cascade', 'label', 'menu', 

   /* now add items to the File menu */
   call TkAdd menu, 'command', '-label', 'Test...', '-rexx', 'AnotherWin'
   call TkAdd menu, 'command', '-label', 'Tree...', '-rexx', 'OpenTree'
   call TkAdd menu, 'command', '-label', 'Open...', '-rexx', 'GetFileName'

   /* adding another item... but am using
      the 'array' options method just for
      grins */
   call SetArgs 'clear'
   call SetArgs 'label', 'Quit'
   call SetArgs 'rexx', 'exit'
   call TkAdd '.m1.m1', 'command', 'n.', 'v.'

   /* attach the menubar to the main window */
   call TkConfig '.', '-menu', menubar

   /* create a frame to put a row of buttons in */
   f1 = TkFrame('.f1')

   /* create each button and remember the name */
   text = 'Press Me!'
   rexx = 'YesButton'
   b1 = TkButton(f1'.b1', 'text', 'rexx')

   text = 'No'
   rexx = 'NoButton'
   b2 = TkButton(f1'.b2', 'text', 'rexx')

   text = 'Count'
   rexx = 'CountToggle'
   b3 = TkButton(f1'.b3', 'text', 'rexx')

   cb = TkCombobox(f1'.cb','-editable','false','-highlightthickness', 1)
   If rc \= 0 Then Say rc TkError()
   Call TkConfig cb, '-textvariable', 'family'
   If rc \= 0 Then Say rc TkError()
   Call TkComboboxListInsert cb, 'end', 'value1', 'value2'
   /* "pack" the buttons... since we created them
      under the "frame" by naming them that way, they
      will be packed into the frame (.f1).
      We pack them with the option "side" = "left"
      which is like sliding (or packing)  them into
      the frame toward the left side... */
   call TkPack b1,  b2,  b3,  '-side',  'left'
   call TkPack cb, '-side', 'bottom'

   /* now create a label widget - it's blank for now */
   prompt = TkLabel('.l1')

   /* create an entry widget... notice how we use the
      'dash' method of specifying the options here
      since there is only one option we are setting */
   entry = TkEntry('.e1', '-width', 20)

   /*
    * Create a canvas and add some objects to it...
    */
   canvas = TkCanvas('.canvas1', '-width', '10c', '-height', '10c')
   outlinerect = TkCanvasRectangle(canvas, 5, 5, 30, 20, '-outline', 'red', '-width', '3')
   fillrect = TkCanvasRectangle(canvas, '1c', '1c', '4c', '5c', '-fill', 'green', '-width', '3')
   arc = TkCanvasOval(canvas, 15, 15, '5c', '2c', '-width', '2m', '-outline', 'black')
   text = TkCanvasText(canvas, '5c', '8c', '-width', '4c', '-anchor', 'center', '-text', 'Here is some text. It should hopefully wrap around to the next line.')
   line = TkCanvasLine(canvas, '8c', '4c', '3c', '2c', '1c', '9c', '7.7c' , '3.5c') 
/*   poly = TkCanvasPolygon(canvas, '8c', '4c', '3c', '2c', '1c', '9c', '7.7c' , '3.5c', '-fill', 'blue', '-width' ,1) */
   Call TkCanvasBind canvas, outlinerect, '<Any-Enter>', '*EnterObject %W'
   Call TkCanvasBind canvas, arc, '<Any-Enter>', '*EnterObject %W'
   Call TkCanvasBind canvas, outlinerect, '<Any-Leave>', '*LeaveObject %W'
   Call TkCanvasBind canvas, arc, '<Any-Leave>', '*LeaveObject %W'
   Call TkCanvasBind canvas, fillrect, '<Any-Enter>', '*EnterFillRect %W'
   Call TkCanvasBind canvas, fillrect, '<Any-Leave>', '*LeaveFillRect %W'

   /* Now pack the frame, the entry, the canvas, and the prompt.
      Since they are all named with names at the
      "root" then they are children of the main window
      and will be packed into that.  We are not saying
      which side to pack towards, so it assumes the top. */
   call TkPack f1, entry, prompt, canvas

   /* Finally, set some file types and associated extensions
      for the TkGetOpenFile call used in the GetFileName
      routine.*/
   call TkSetFileType 'Text', '.txt'
   call TkSetFileType 'Program Source', '.c', '.h', '.rexx'
   call TkSetFileType 'All', '*'

   return

/* the "press me" button was pressed */
YesButton:
   procedure expose fillrect canvas
   
   /* Config changes the configuration of the widget
      given as argument one. */
   call TkConfig '.l1', '-text', 'You deleted the green rectangle!'
   
   /* Wm does alot.  Here we are setting the title
      of the window given in arg 2 (the root window) */
   call TkWm 'title', '.', TkGet('.e1')
   
   call tkcanvasdelete canvas, fillrect
   /* delete the text out of the '.e1' widget which is
      the text 'entry' widget we created with the
      TkEntry call in the main routine.  The 2nd and
      3rd args are the beginning and end of the range
      that we want deleted. */
   call TkDelete '.e1', 0, 'end'
   return

NoButton:
   procedure expose prompt canvas
   n.1 = 'text'
   v.1 = 'What? No?'
   call TkConfig prompt, 'n.', 'v.'
   call TkWm 'title', '.', 'Hi Dudez'
   call TkCanvasPostscript canvas, '-file', 'aaa.ps'

   return

EnterObject: Procedure Expose canvas restorecmd
   Parse Arg obj
   type = TkCanvasType( canvas, 'current' )
   Select
      When type = 'rectangle' Then 
         Do
            Call TkItemConfig canvas, 'current', '-outline', 'blue'
            restorecmd = "TkItemConfig canvas, 'mycurr', '-outline', 'red'"
         End
      When type = 'oval' Then 
         Do
            Call TkItemConfig canvas, 'current', '-outline', 'red'
            restorecmd = "TkItemConfig canvas, 'mycurr', '-outline', 'black'"
         End
      Otherwise Nop
   End
   Call TKCanvasAddtag canvas, 'mycurr', 'withtag', 'current'
   Return

LeaveObject: Procedure Expose canvas restorecmd
   Parse Arg obj
   Interpret 'call' restorecmd
   Call TKCanvasDtag canvas, 'mycurr'
   Return

EnterFillRect: Procedure Expose restorecmd fillrect
   Parse Arg win .
   Call TkItemConfig win, 'current', '-fill', 'white'
   restorecmd = "TkItemConfig win , fillrect, '-fill', 'green'"
   Return

LeaveFillRect: Procedure Expose restorecmd fillrect
   Parse Arg win .
   Interpret 'call' restorecmd
   Return

SlidePrompt:
   parse arg nbr
   text = 'Slider set to' nbr
   call TkConfig '.l1', 'text'
   return

GetFileName:

   /* The file extensions/types are being set up
      in the main window init rouine (CreateMain) */

   FileName = TkGetOpenFile(,,'Open File')
   
   /* set the text prompt to the filename */
   call TkConfig '.l1', '-text', FileName
   
   return

quit:
exit:
   if TkMessageBox('Are you sure you want to quit?','Quit?','yesno','warning'),
      = 'no' then
      return
   exit

SetArgs:
   procedure expose  n. v.
   Parse Arg name, value
   if name = 'clear' then
      do
         drop n. v.
         n.0 = 0
         return 0
      end
   n.0 = n.0 + 1
   v.0 = n.0
   argc = n.0
   n.argc = name
   v.argc = value
   return 0

AnotherWin:
   procedure 

   win = TkTopLevel('.win2')

   l1 = TkLabel(win'.l1', '-text', 'Pick a number from 100 to 200')

   text = 'Done'
   rexx = 'AWinClose'
   b1 = TkButton(win'.b1', 'text', 'rexx')
   
   /* a perfect time to use the array options
      setting method since there are so many
      options we want to set on this widget */
   call SetArgs 'clear'
   call SetArgs 'from', 100
   call SetArgs 'to', 200
   call SetArgs 'orient', 'horiz'
   call SetArgs 'tickinterval', 50
   call SetArgs 'length', 200
   call SetArgs 'rexx', 'SlidePrompt'
   scale = TkScale(win'.s1', 'n.', 'v.')
   
   call TkPack l1, scale, b1

   /* this will prevent any other window
      from receiving any input */
   call TkGrab win

   do forever
      cmd = TkWait()
      if cmd = 'AWinClose' then leave
      interpret 'call' cmd
   end

   /* allow all the other windows
      to receive input as normal */
   call TkGrab 'release', win
  
   /* before we destroy (and quit displaying)
      the window, we need the value of the
      scale widget... the number they picked. */
   choice = TkGet(scale)

   /* set the prompt in the main window with it */
   call TkConfig '.l1', '-text', 'You chose:' choice
   
   /* now destroy the main window and all the
      child widgets in it */
   call TkDestroy win
   
   return

OpenTree:
   procedure 

   win = TkTopLevel('.win3')
   Call TkConfig win, '-bd', 3, '-relief', 'flat'
   frame = TkFrame(win'.f', '-bg', 'white' )
   Call TkPack frame, '-fill', 'both', '-expand', 1

   l1 = TkLabel(frame'.l1', '-text', 'Tree Demo')

   text = 'Done'
   rexx = 'TreeClose'
   b1 = TkButton(frame'.b1', 'text', 'rexx')
   
   /*
    * Create a frame for the tree and scrollbar
    */
   tree = TkTree( frame'.t1', '-width', 150, '-height', 400, '-yscrollcommand', frame'.sb set' )
   sb = TkScrollbar( frame'.sb', '-orient', 'vertical', '-command', tree 'yview')
   Call TkPack tree, '-side', 'left', '-fill', 'both', '-expand', 1, '-padx', 5, '-pady', 5
   Call TkPack sb, '-side', 'left', '-fill', 'y'
   idir_data = "R0lGODdhEAAQAPIAAAAAAHh4eLi4uPj4APj4+P///wAAAAAAACwAAAAAEAAQAAADPVi63P4wLkKCtTTnUsXwQqBtAfh910UU4ugGAEucpgnLNY3Gop7folwNOBOeiEYQ0acDpp6pGAFArVqthQQAO///"
   Call TkImagePhoto 'idir', '-data', idir_data
   ifile_data = "R0lGODdhEAAQAPIAAAAAAHh4eLi4uPj4+P///wAAAAAAAAAAACwAAAAAEAAQAAADPkixzPODyADrWE8qC8WN0+BZAmBq1GMOqwigXFXCrGk/cxjjr27fLtout6n9eMIYMTXsFZsogXRKJf6uP0kCADv/"
   Call TkImagePhoto 'ifile', '-data', ifile_data
   /*
    * Create another frame beside the tree frame for the filename
    * contents
    */
   frame2 = TkFrame( frame'.f2', '-height', 400, '-width', 400, '-bg', 'white')
   Call TKPack frame2, '-side', 'left', '-fill', 'both', '-expand', 1
   label = TkLabel( frame2'.l', '-width', 40, '-text', '', '-bg', TkCget( frame, '-bg') )
   Call TkPack label, '-expand', 1
   Call TkPack b1, '-side', 'bottom'

   Do i = 1 To 3
      Call TkTreeAddNode tree, '/dir'i, '-image', 'idir', '-tags', 'idir'
      Do j = 1 To 6
         Call TkTreeAddNode tree, '/dir'i'/file'j, '-image', 'ifile', '-tags', 'ifile'
      End
      Call TkTreeAddNode tree, '/dir'i'/subdir', '-image', 'idir', '-tags', 'idir'
      Do k = 1 To 2
         Call TkTreeAddNode tree, '/dir'i'/subdir/file'k, '-image', 'ifile', '-tags', 'ifile'
      End
      Do  zz = 1 To 4
         Call TkTreeAddNode tree,'/dir'i'/subdir/ssdir'zz, '-image', 'idir', '-tags', 'idir'
         Call TkTreeAddNode tree,'/dir'i'/subdir/ssdir'zz'/file1', '-tags', 'ifile'
         Call TkTreeAddNode tree,'/dir'i'/subdir/ssdir'zz'/file2', '-image', 'ifile', '-tags', 'ifile'
      End
   End
   Call TkCanvasBind tree, 'idir', '<1>', '*ClickOneDir %W %x %y'
   Call TkCanvasBind tree, 'idir', '<2>', '*ClickTwoDir %W %x %y'
   Call TkCanvasBind tree, 'ifile', '<1>', '*ClickOneFile %W %x %y'
   Call TkCanvasBind tree, 'ifile', '<2>', '*ClickTwoFile %W %x %y'
   Call TkCanvasBind tree, 'idir', '<Double-1>', '*DoubleClickOneDir %W %x %y'

   /* this will prevent any other window
      from receiving any input */
   call TkGrab win

   do forever
      cmd = TkWait()
      command = Word(cmd,1)
      args = Strip(Subword(cmd,2),'B','"')
      Select
         When command = 'TreeClose' Then leave
         When command = 'ClickOneDir' Then
            Do
               Parse var args window x y
               lab = TkTreeGetLabel( window, x, y )
               Call TkTreeSetSelection window, lab
               Call TkConfig label, '-text', 'dir:' lab
            End
         When command = 'ClickOneFile' Then
            Do
               Parse var args window x y
               lab = TkTreeGetLabel( window, x, y )
               Call TkTreeSetSelection window, lab
               Call TkConfig label, '-text', 'file:' lab
            End
         When command = 'ClickTwoDir' | command = 'ClickTwoFile' Then
            Do
               Parse var args window x y
               lab = TkTreeGetLabel( window, x, y )
               Call TkTreeDNode window, lab
            End
         When command = 'DoubleClickOneDir' Then
            Do
               Parse var args window x y
               Call TkTreeOpen window, TkTreeGetLabel( window, x, y )
            End
         Otherwise interpret 'call' cmd
      End
   end

   /* allow all the other windows
      to receive input as normal */
   call TkGrab 'release', win
  
   /* now destroy the main window and all the
      child widgets in it */
   call TkDestroy win
   
   return
   
CountToggle:

   /* If there is already a CountID, then
      we need to stop the counter, if not
      then we start it.*/
   If CountID = 'COUNTID' Then Do
      
      /* set a call to be made in one second */
      CountID = TkAfter(1000, 'Count')

      /* Set the global var to 0 */
      Count = 0

      /* call it here the first time for immediate
         feedback */
      Call Count

   End
   Else Do
      
      /* Cancel the next call */
      call TkAfter 'cancel', CountID

      /* Clear the CountID */
      Drop CountID

      /* And clear the prompt */
      call TkConfig '.l1', '-text', ''

   End

   Return
   
Count:

   /* increment the count */
   Count = Count + 1

   /* set the prompt */
   call TkConfig '.l1', '-text', 'Counting...' Count

   /* Set up another call to this routine
      one second from now */
   CountID = TkAfter(1000, 'Count')

   return

